/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.conversions.implicit.ConversionAnalyzer;
import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;

public class ArrayListAnalyzer
implements IOperationAnalyzer {
    private final XML xml;

    public ArrayListAnalyzer(XML aXml) {
        this.xml = aXml;
    }

    public InfoOperation getInfoOperation(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        Class<?> dItem = null;
        Class<?> sItem = null;
        InfoOperation operation = new InfoOperation().setConversionType(ConversionType.UNDEFINED);
        if (dClass.isArray() && GeneralUtility.collectionIsAssignableFrom(sClass)) {
            dItem = dClass.getComponentType();
            sItem = ClassesManager.getCollectionItemClass(source);
            operation.setInstructionType(OperationType.ARRAY_LIST);
            if (ClassesManager.areMappedObjects(dItem, sItem, this.xml)) {
                return operation.setInstructionType(OperationType.ARRAY_LIST_WITH_MAPPED_ITEMS).setConfigChosen(ClassesManager.configChosen(dItem, sItem, this.xml));
            }
        }
        if (GeneralUtility.collectionIsAssignableFrom(dClass) && sClass.isArray()) {
            dItem = ClassesManager.getCollectionItemClass(destination);
            sItem = sClass.getComponentType();
            operation.setInstructionType(OperationType.LIST_ARRAY);
            if (ClassesManager.areMappedObjects(dItem, sItem, this.xml)) {
                return operation.setInstructionType(OperationType.LIST_ARRAY_WITH_MAPPED_ITEMS).setConfigChosen(ClassesManager.configChosen(dItem, sItem, this.xml));
            }
        }
        if (ClassesManager.isAssignableFrom(dItem, sItem)) {
            return operation.setConversionType(ConversionType.ABSENT);
        }
        if (GeneralUtility.areBasic(dItem, sItem)) {
            return operation.setConversionType(ConversionAnalyzer.getConversionType(dItem, sItem));
        }
        return operation;
    }

    public boolean verifyConditions(Field destination, Field source) {
        return destination.getType().isArray() && GeneralUtility.collectionIsAssignableFrom(source.getType()) || source.getType().isArray() && GeneralUtility.collectionIsAssignableFrom(destination.getType());
    }
}

