/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.conversions.implicit.ConversionAnalyzer;
import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;

public final class BasicAnalyzer
implements IOperationAnalyzer {
    private XML xml;

    public BasicAnalyzer(XML xml) {
        this.xml = xml;
    }

    public InfoOperation getInfoOperation(Field destination, Field source) {
        InfoOperation operation = new InfoOperation().setInstructionType(OperationType.BASIC_INSTRUCTION).setConversionType(ConversionType.UNDEFINED);
        if (ClassesManager.isAssignableFrom(destination, source)) {
            return operation.setConversionType(ConversionType.ABSENT);
        }
        if (GeneralUtility.isBasic(destination.getType()) && GeneralUtility.isBasic(source.getType())) {
            return operation.setConversionType(ConversionAnalyzer.getConversionType(destination, source));
        }
        return operation;
    }

    public boolean verifyConditions(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        return !GeneralUtility.isStructure(dClass) && !GeneralUtility.isStructure(sClass) && !ClassesManager.areMappedObjects(dClass, sClass, this.xml) && (ClassesManager.areEqual(destination, source) || ClassesManager.isAssignableFrom(destination, source)) || GeneralUtility.isBasic(dClass) && GeneralUtility.isBasic(sClass);
    }
}

