/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.conversions.implicit.ConversionAnalyzer;
import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;

public final class CollectionAnalyzer
implements IOperationAnalyzer {
    private final XML xml;

    public CollectionAnalyzer(XML aXml) {
        this.xml = aXml;
    }

    public InfoOperation getInfoOperation(Field destination, Field source) {
        Class<?> sItem;
        InfoOperation operation = new InfoOperation().setInstructionType(OperationType.COLLECTION).setConversionType(ConversionType.UNDEFINED);
        if (ClassesManager.isAddAllPermitted(destination, source)) {
            return operation.setConversionType(ConversionType.ABSENT);
        }
        Class<?> dItem = ClassesManager.getCollectionItemClass(destination);
        if (GeneralUtility.areBasic(dItem, sItem = ClassesManager.getCollectionItemClass(source))) {
            return operation.setConversionType(ConversionAnalyzer.getConversionType(dItem, sItem));
        }
        if (ClassesManager.areMappedObjects(dItem, sItem, this.xml)) {
            return operation.setInstructionType(OperationType.COLLECTION_WITH_MAPPED_ITEMS).setConfigChosen(ClassesManager.configChosen(dItem, sItem, this.xml));
        }
        return operation;
    }

    public boolean verifyConditions(Field destination, Field source) {
        return GeneralUtility.collectionIsAssignableFrom(destination.getType()) && GeneralUtility.collectionIsAssignableFrom(source.getType());
    }
}

