/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import java.lang.reflect.Field;
import java.util.Calendar;
import java.util.Date;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateCalendarAnalyzer
implements IOperationAnalyzer {
    @Override
    public InfoOperation getInfoOperation(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        InfoOperation operation = new InfoOperation().setConversionType(ConversionType.UNDEFINED);
        if (this.isDate(dClass) && this.isCalendar(sClass)) {
            return operation.setInstructionType(OperationType.DATE_CALENDAR);
        }
        if (this.isCalendar(dClass) && this.isDate(sClass)) {
            return operation.setInstructionType(OperationType.CALENDAR_DATE);
        }
        return operation;
    }

    @Override
    public boolean verifyConditions(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        return this.isDate(dClass) && this.isCalendar(sClass) || this.isDate(sClass) && this.isCalendar(dClass);
    }

    private boolean isDate(Class<?> clazz) {
        return Date.class.isAssignableFrom(clazz);
    }

    private boolean isCalendar(Class<?> clazz) {
        return Calendar.class.isAssignableFrom(clazz);
    }
}

