/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EnumEnumAnalyzer
implements IOperationAnalyzer {
    @Override
    public InfoOperation getInfoOperation(Field destination, Field source) {
        InfoOperation operation = new InfoOperation().setConversionType(ConversionType.UNDEFINED);
        if (this.verifyConditions(destination, source)) {
            return operation.setInstructionType(OperationType.ENUM_ENUM);
        }
        return operation;
    }

    @Override
    public boolean verifyConditions(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        return this.isEnum(dClass) && this.isEnum(sClass);
    }

    private boolean isEnum(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }
}

