/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.conversions.implicit.ConversionAnalyzer;
import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoMapOperation;
import com.googlecode.jmapper.operations.info.InfoOperation;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MapAnalyzer
implements IOperationAnalyzer {
    private final XML xml;

    public MapAnalyzer(XML aXml) {
        this.xml = aXml;
    }

    @Override
    public InfoOperation getInfoOperation(Field destination, Field source) {
        InfoMapOperation operation = (InfoMapOperation)new InfoMapOperation().setInstructionType(OperationType.MAP).setConversionType(ConversionType.UNDEFINED);
        if (ClassesManager.isPutAllPermitted(destination, source)) {
            return operation.setConversionType(ConversionType.ABSENT);
        }
        operation.setConversionType(ConversionType.DEFINED);
        Class<?> dKItem = ClassesManager.getGenericMapKeyItem(destination);
        Class<?> sKItem = ClassesManager.getGenericMapKeyItem(source);
        Class<?> dVItem = ClassesManager.getGenericMapValueItem(destination);
        Class<?> sVItem = ClassesManager.getGenericMapValueItem(source);
        operation.keyValueUndefined();
        if (ClassesManager.areMappedObjects(dKItem, sKItem, this.xml) || ClassesManager.areMappedObjects(dVItem, sVItem, this.xml)) {
            operation.setInstructionType(OperationType.MAP_WITH_MAPPED_ITEMS);
        }
        if (ClassesManager.isAssignableFrom(dKItem, sKItem)) {
            operation.setKeyInstructionType(OperationType.BASIC_INSTRUCTION).setKeyConversionType(ConversionType.ABSENT);
        }
        if (ClassesManager.isAssignableFrom(dVItem, sVItem)) {
            operation.setValueInstructionType(OperationType.BASIC_INSTRUCTION).setValueConversionType(ConversionType.ABSENT);
        }
        if (GeneralUtility.areBasic(dKItem, sKItem)) {
            operation.setKeyInstructionType(OperationType.BASIC_INSTRUCTION).setKeyConversionType(MapAnalyzer.getConversion(dKItem, sKItem));
        }
        if (GeneralUtility.areBasic(dVItem, sVItem)) {
            operation.setValueInstructionType(OperationType.BASIC_INSTRUCTION).setValueConversionType(MapAnalyzer.getConversion(dVItem, sVItem));
        }
        if (ClassesManager.areMappedObjects(dKItem, sKItem, this.xml)) {
            operation.setKeyInstructionType(OperationType.OBJECT).setKeyConfigChosen(ClassesManager.configChosen(dKItem, sKItem, this.xml));
        }
        if (ClassesManager.areMappedObjects(dVItem, sVItem, this.xml)) {
            operation.setValueInstructionType(OperationType.OBJECT).setValueConfigChosen(ClassesManager.configChosen(dVItem, sVItem, this.xml));
        }
        return operation;
    }

    private static ConversionType getConversion(Class<?> dClass, Class<?> sClass) {
        return dClass.isAssignableFrom(sClass) ? ConversionType.UNDEFINED : ConversionAnalyzer.getConversionType(dClass, sClass);
    }

    @Override
    public boolean verifyConditions(Field destination, Field source) {
        return GeneralUtility.mapIsAssignableFrom(destination.getType()) && GeneralUtility.mapIsAssignableFrom(source.getType());
    }
}

