/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringEnumAnalyzer
implements IOperationAnalyzer {
    @Override
    public InfoOperation getInfoOperation(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        InfoOperation operation = new InfoOperation().setConversionType(ConversionType.UNDEFINED);
        if (this.isString(dClass) && this.isEnum(sClass)) {
            return operation.setInstructionType(OperationType.STRING_ENUM);
        }
        if (this.isEnum(dClass) && this.isString(sClass)) {
            return operation.setInstructionType(OperationType.ENUM_STRING);
        }
        return operation;
    }

    @Override
    public boolean verifyConditions(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        return this.isString(dClass) && this.isEnum(sClass) || this.isEnum(dClass) && this.isString(sClass);
    }

    private boolean isString(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    private boolean isEnum(Class<?> clazz) {
        return Enum.class.isAssignableFrom(clazz);
    }
}

