/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.operations.analyzer;

import com.googlecode.jmapper.enums.ConversionType;
import com.googlecode.jmapper.enums.OperationType;
import com.googlecode.jmapper.operations.IOperationAnalyzer;
import com.googlecode.jmapper.operations.info.InfoOperation;
import java.lang.reflect.Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringStringBufferAnalyzer
implements IOperationAnalyzer {
    @Override
    public InfoOperation getInfoOperation(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        InfoOperation operation = new InfoOperation().setConversionType(ConversionType.UNDEFINED);
        if (this.isString(dClass) && this.isStringBuffer(sClass)) {
            return operation.setInstructionType(OperationType.STRING_STRINGBUFFER);
        }
        if (this.isStringBuffer(dClass) && this.isString(sClass)) {
            return operation.setInstructionType(OperationType.STRINGBUFFER_STRING);
        }
        return operation;
    }

    @Override
    public boolean verifyConditions(Field destination, Field source) {
        Class<?> dClass = destination.getType();
        Class<?> sClass = source.getType();
        return this.isString(dClass) && this.isStringBuffer(sClass) || this.isString(sClass) && this.isStringBuffer(dClass);
    }

    private boolean isString(Class<?> clazz) {
        return String.class.isAssignableFrom(clazz);
    }

    private boolean isStringBuffer(Class<?> clazz) {
        return StringBuffer.class.isAssignableFrom(clazz);
    }
}

