/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.util;

import com.googlecode.jmapper.annotations.Annotation;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.enums.ChooseConfig;
import com.googlecode.jmapper.operations.NestedMappingHandler;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.util.AutoBoxing;
import com.googlecode.jmapper.util.FilesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ClassesManager {
    private ClassesManager() {
    }

    public static boolean isPutAllPermitted(Field destination, Field source) {
        boolean isFirst = true;
        boolean isAddAllFunction = false;
        boolean isPutAllFunction = true;
        return ClassesManager.isAssignableFrom(ClassesManager.getGenericString(destination), ClassesManager.getGenericString(source), destination.getType(), source.getType(), isFirst, isAddAllFunction, isPutAllFunction);
    }

    public static boolean isAddAllPermitted(Field destination, Field source) {
        boolean isFirst = true;
        boolean isAddAllFunction = true;
        boolean isPutAllFunction = false;
        return ClassesManager.isAssignableFrom(ClassesManager.getGenericString(destination), ClassesManager.getGenericString(source), destination.getType(), source.getType(), isFirst, isAddAllFunction, isPutAllFunction);
    }

    public static boolean isAssignableFrom(MappedField destination, MappedField source) {
        return ClassesManager.isAssignableFrom(destination.getValue(), source.getValue());
    }

    public static boolean isAssignableFrom(Field destination, Field source) {
        boolean isFirst = true;
        boolean isAddAllFunction = false;
        boolean isPutAllFunction = false;
        return ClassesManager.isAssignableFrom(ClassesManager.getGenericString(destination), ClassesManager.getGenericString(source), destination.getType(), source.getType(), isFirst, isAddAllFunction, isPutAllFunction);
    }

    public static boolean isAssignableFrom(Class<?> destination, Class<?> source) {
        return destination.isAssignableFrom(source) || ClassesManager.isBoxing(destination, source) || ClassesManager.isUnBoxing(destination, source);
    }

    private static boolean isAssignableFrom(String genericD, String genericS, Class<?> classD, Class<?> classS, boolean isFirst, boolean isAddAllFunction, boolean isPutAllFunction) {
        try {
            int dStartBracket = genericD.indexOf("<");
            int sStartBracket = genericS.indexOf("<");
            int dEndBracket = genericD.lastIndexOf(">");
            int sEndBracket = genericS.lastIndexOf(">");
            if (dStartBracket == -1 && sStartBracket == -1 && dEndBracket == -1 && sEndBracket == -1) {
                if (isFirst) {
                    return ClassesManager.functionsAreAllowed(isAddAllFunction, isPutAllFunction, classD, classS);
                }
                genericD = genericD.equals("?") ? "java.lang.Object" : genericD;
                genericS = genericS.equals("?") ? "java.lang.Object" : genericS;
                return ClassesManager.isAssignableFrom(Class.forName(genericD), Class.forName(genericS));
            }
            String dBeforeBracket = "";
            String sBeforeBracket = "";
            String dAfterBracket = "";
            String sAfterBracket = "";
            if (dStartBracket != -1 && dEndBracket != -1) {
                dBeforeBracket = genericD.substring(0, dStartBracket).trim();
                dAfterBracket = genericD.substring(dStartBracket + 1, dEndBracket);
            }
            if (sStartBracket != -1 && sEndBracket != -1) {
                sBeforeBracket = genericS.substring(0, sStartBracket).trim();
                sAfterBracket = genericS.substring(sStartBracket + 1, sEndBracket);
            }
            if (GeneralUtility.isEmpty(dBeforeBracket) && !GeneralUtility.isEmpty(sBeforeBracket)) {
                dBeforeBracket = genericD;
            }
            if (!GeneralUtility.isEmpty(dBeforeBracket) && GeneralUtility.isEmpty(sBeforeBracket)) {
                sBeforeBracket = genericS;
            }
            boolean isAssignableFrom = false;
            if (!GeneralUtility.isEmpty(dBeforeBracket) && !GeneralUtility.isEmpty(sBeforeBracket)) {
                boolean bl = isAssignableFrom = isFirst ? ClassesManager.functionsAreAllowed(isAddAllFunction, isPutAllFunction, classD, classS) : ClassesManager.isAssignableFrom(Class.forName(dBeforeBracket), Class.forName(sBeforeBracket));
            }
            if (!GeneralUtility.isEmpty(dAfterBracket) && !GeneralUtility.isEmpty(sAfterBracket)) {
                if (isAddAllFunction) {
                    return isAssignableFrom && ClassesManager.isAssignableFrom(dAfterBracket, sAfterBracket, null, null, false, false, false);
                }
                if (isPutAllFunction) {
                    int dSplitIndex = ClassesManager.pairSplitIndex(dAfterBracket);
                    String dKey = dAfterBracket.substring(0, dSplitIndex).trim();
                    String dValue = dAfterBracket.substring(dSplitIndex + 1).trim();
                    int sSplitIndex = ClassesManager.pairSplitIndex(sAfterBracket);
                    String sKey = sAfterBracket.substring(0, sSplitIndex).trim();
                    String sValue = sAfterBracket.substring(sSplitIndex + 1).trim();
                    return isAssignableFrom && ClassesManager.isAssignableFrom(dKey, sKey, null, null, false, false, false) && ClassesManager.isAssignableFrom(dValue, sValue, null, null, false, false, false);
                }
                return isAssignableFrom && dAfterBracket.equals(sAfterBracket);
            }
            return isAssignableFrom;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static boolean functionsAreAllowed(boolean isAddAllFunction, boolean isPutAllFunction, Class<?> classD, Class<?> classS) {
        if (isAddAllFunction) {
            return GeneralUtility.collectionIsAssignableFrom(classD) && GeneralUtility.collectionIsAssignableFrom(classS);
        }
        if (isPutAllFunction) {
            return GeneralUtility.mapIsAssignableFrom(classD) && GeneralUtility.mapIsAssignableFrom(classS);
        }
        return ClassesManager.isAssignableFrom(classD, classS);
    }

    public static boolean isUnBoxing(Class<?> destination, Class<?> source) {
        return ClassesManager.isAutoboxingOperation(AutoBoxing.unBoxingOperations, destination, source);
    }

    public static boolean isBoxing(Class<?> destination, Class<?> source) {
        return ClassesManager.isAutoboxingOperation(AutoBoxing.boxingOperations, destination, source);
    }

    private static boolean isAutoboxingOperation(HashMap<String, String[]> map, Class<?> destination, Class<?> source) {
        String[] names = map.get(destination.getName());
        if (names != null) {
            for (String name : names) {
                if (!name.equals(source.getName())) continue;
                return true;
            }
        }
        return false;
    }

    private static int pairSplitIndex(String str) {
        int openBracket = 0;
        int closedBracket = 0;
        char[] array = str.toCharArray();
        for (int i = 0; i < str.length(); ++i) {
            char it = array[i];
            if (it == '<') {
                ++openBracket;
            }
            if (it == '>') {
                ++closedBracket;
            }
            if (it != ',' || openBracket - closedBracket != 0) continue;
            return i;
        }
        return 0;
    }

    public static String getGenericString(Field field) {
        String fieldDescription = field.toGenericString();
        ArrayList<String> splitResult = new ArrayList<String>();
        char[] charResult = fieldDescription.toCharArray();
        boolean isFinished = false;
        int separatorIndex = fieldDescription.indexOf(" ");
        int previousIndex = 0;
        while (!isFinished) {
            int position = separatorIndex - 1;
            char specialChar = charResult[position];
            boolean isSpecialChar = true;
            if (specialChar != ',' && specialChar != '?') {
                if (specialChar == 's') {
                    String specialString = null;
                    try {
                        specialString = fieldDescription.substring(position - "extends".length(), position + 1);
                        if (GeneralUtility.isNull(specialString) || !specialString.equals(" extends")) {
                            isSpecialChar = false;
                        }
                    }
                    catch (IndexOutOfBoundsException e) {
                        isSpecialChar = false;
                    }
                } else {
                    isSpecialChar = false;
                }
            }
            if (!isSpecialChar) {
                splitResult.add(fieldDescription.substring(previousIndex, separatorIndex));
                previousIndex = separatorIndex + 1;
            }
            if ((separatorIndex = fieldDescription.indexOf(" ", separatorIndex + 1)) != -1) continue;
            isFinished = true;
        }
        for (String description : splitResult) {
            if (GeneralUtility.isAccessModifier(description)) continue;
            return description;
        }
        return null;
    }

    public static boolean areEqual(Field destination, Field source) {
        return ClassesManager.getGenericString(destination).equals(ClassesManager.getGenericString(source));
    }

    public static String mapperClassName(Class<?> destination, Class<?> source, String resource) {
        String className = destination.getName().replaceAll("\\.", "") + source.getName().replaceAll("\\.", "");
        if (GeneralUtility.isEmpty(resource)) {
            return className;
        }
        if (!FilesManager.isPath(resource)) {
            return GeneralUtility.write(className, String.valueOf(resource.hashCode()));
        }
        String[] dep = resource.split("\\\\");
        if (dep.length <= 1) {
            dep = resource.split("/");
        }
        String xml = dep[dep.length - 1];
        return GeneralUtility.write(className, xml.replaceAll("\\.", "").replaceAll(" ", ""));
    }

    public static String fieldName(Class<?> aClass, String regex) {
        if (NestedMappingHandler.isNestedMapping(regex)) {
            return regex;
        }
        String result = null;
        for (Class<?> clazz : ClassesManager.getAllsuperClasses(aClass)) {
            result = ClassesManager.getFieldName(clazz, regex);
            if (GeneralUtility.isNull(result)) continue;
            return result;
        }
        return result;
    }

    private static String getFieldName(Class<?> aClass, String regex) {
        for (Field field : aClass.getDeclaredFields()) {
            if (!field.getName().matches(regex)) continue;
            return field.getName();
        }
        return null;
    }

    public static boolean areMappedObjects(Class<?> dClass, Class<?> sClass, XML xml) {
        return ClassesManager.isMapped(dClass, xml) || ClassesManager.isMapped(sClass, xml);
    }

    private static boolean isMapped(Class<?> aClass, XML xml) {
        return xml.isInheritedMapped(aClass) || Annotation.isInheritedMapped(aClass);
    }

    public static List<Class<?>> getAllsuperClasses(Class<?> aClass) {
        ArrayList result = new ArrayList();
        result.add(aClass);
        for (Class<?> superclass = aClass.getSuperclass(); !GeneralUtility.isNull(superclass) && superclass != Object.class; superclass = superclass.getSuperclass()) {
            result.add(superclass);
        }
        return result;
    }

    public static List<Field> getListOfFields(Class<?> aClass) {
        ArrayList<Field> listOfFields = new ArrayList<Field>();
        for (Class<?> clazz : ClassesManager.getAllsuperClasses(aClass)) {
            GeneralUtility.enrichList(listOfFields, clazz.getDeclaredFields());
        }
        return ClassesManager.getFilteredFields(listOfFields);
    }

    private static List<Field> getFilteredFields(List<Field> listOfFields) {
        ArrayList<Field> fitleredFields = new ArrayList<Field>();
        for (Field field : listOfFields) {
            if (field.isSynthetic() || "serialVersionUID".equals(field.getName())) continue;
            fitleredFields.add(field);
        }
        return fitleredFields;
    }

    public static List<Method> getAllMethods(Class<?> aClass) {
        List<Method> listOfMethods = GeneralUtility.toList(aClass.getDeclaredMethods());
        for (Class<?> superclass = aClass.getSuperclass(); superclass != Object.class; superclass = superclass.getSuperclass()) {
            listOfMethods = ClassesManager.getMethods(listOfMethods, superclass);
        }
        return listOfMethods;
    }

    private static List<Method> getMethods(List<Method> existingMethods, Class<?> classToCheck) {
        ArrayList<Method> result = new ArrayList<Method>(existingMethods);
        for (Method methodToCheck : classToCheck.getDeclaredMethods()) {
            for (Method method : existingMethods) {
                if (method.getName().equals(methodToCheck.getName())) continue;
                result.add(methodToCheck);
            }
        }
        return result;
    }

    public static Field retrieveField(Class<?> clazz, String regex) {
        for (Field field : ClassesManager.getListOfFields(clazz)) {
            if (!field.getName().equals(regex)) continue;
            return field;
        }
        return null;
    }

    public static void verifiesAccessorMethods(Class<?> clazz, MappedField ... fields) {
        ClassesManager.verifyGetterMethods(clazz, fields);
        ClassesManager.verifySetterMethods(clazz, fields);
    }

    public static void verifyGetterMethods(Class<?> clazz, MappedField ... fields) {
        for (MappedField field : fields) {
            String fieldName = field.getName();
            Class<?> fieldType = field.getType();
            String customGet = field.getMethod();
            if (!GeneralUtility.isNull(customGet) && !customGet.equals("")) {
                try {
                    clazz.getMethod(customGet, new Class[0]);
                    continue;
                }
                catch (Exception e) {
                    Error.customMethod("get", customGet, clazz);
                }
            }
            String methodName = GeneralUtility.getMethod(fieldType, fieldName);
            try {
                clazz.getMethod(methodName, new Class[0]);
            }
            catch (Exception e) {
                if (!GeneralUtility.isBoolean(fieldType)) {
                    Error.method(methodName, fieldName, clazz);
                }
                try {
                    methodName = GeneralUtility.mGet(fieldName);
                    clazz.getMethod(methodName, new Class[0]);
                }
                catch (Exception e1) {
                    Error.method(methodName, fieldName, clazz);
                }
            }
            field.getMethod(methodName);
        }
    }

    public static void findSetterMethods(Class<?> clazz, MappedField ... fields) {
        try {
            ClassesManager.verifySetterMethods(clazz, fields);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void verifySetterMethods(Class<?> clazz, MappedField ... fields) {
        String methodName = null;
        String fieldName = null;
        Class<?> fieldType = null;
        try {
            for (MappedField field : fields) {
                fieldName = field.getName();
                fieldType = field.getType();
                String customSet = field.setMethod();
                if (!GeneralUtility.isNull(customSet) && !customSet.equals("")) {
                    try {
                        clazz.getMethod(customSet, fieldType);
                        field.setMethod(customSet);
                        continue;
                    }
                    catch (Exception e) {
                        Error.customMethod("set", customSet, clazz);
                    }
                }
                methodName = GeneralUtility.mSet(fieldName);
                clazz.getMethod(methodName, fieldType);
                field.setMethod(methodName);
            }
        }
        catch (Exception e) {
            Error.method(methodName, fieldName, clazz);
        }
    }

    public static ChooseConfig configChosen(Class<?> dItem, Class<?> sItem, XML xml) {
        return ClassesManager.isMapped(dItem, xml) && ClassesManager.isMapped(sItem, xml) ? null : (ClassesManager.isMapped(dItem, xml) ? ChooseConfig.DESTINATION : ChooseConfig.SOURCE);
    }

    private static String obtainGenericContent(String structure) {
        String item = structure.substring(structure.indexOf("<") + 1, structure.indexOf(">"));
        int internalGeneric = item.indexOf("<");
        if (internalGeneric != -1) {
            item = item.substring(0, internalGeneric);
        }
        return item.equals("?") ? "java.lang.Object" : item;
    }

    public static <T> T getFieldValue(Object obj, String fieldName) {
        try {
            Field field = obj.getClass().getDeclaredField(fieldName);
            field.setAccessible(true);
            return (T)field.get(obj);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getCollectionItemClass(MappedField generic) {
        return ClassesManager.getCollectionItemClass(generic.getValue());
    }

    public static Class<?> getCollectionItemClass(Field generic) {
        String item = ClassesManager.obtainGenericContent(ClassesManager.getGenericString(generic));
        try {
            return Class.forName(item);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getGenericMapKeyItem(MappedField generic) {
        return ClassesManager.getGenericMapKeyItem(generic.getValue());
    }

    public static Class<?> getGenericMapKeyItem(Field generic) {
        String item = ClassesManager.obtainGenericContent(ClassesManager.getGenericString(generic));
        try {
            return Class.forName(item.split(",")[0].trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getGenericMapValueItem(MappedField generic) {
        return ClassesManager.getGenericMapValueItem(generic.getValue());
    }

    public static Class<?> getGenericMapValueItem(Field generic) {
        String item = ClassesManager.obtainGenericContent(ClassesManager.getGenericString(generic));
        try {
            return Class.forName(item.split(",")[1].trim());
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Class<?> getArrayItemClass(MappedField field) {
        return field.getType().getComponentType();
    }

    public static void getKeyValueClasses(Field field, Class<?> key, Class<?> value) {
        if (!GeneralUtility.mapIsAssignableFrom(field.getType())) {
            throw new IllegalArgumentException("the field is not a map");
        }
        String generic = field.toGenericString();
        String[] pair = generic.substring(generic.indexOf("<") + 1, generic.indexOf(">")).split(", ");
        try {
            key = Class.forName(pair[0].trim());
            value = Class.forName(pair[1].trim());
        }
        catch (ClassNotFoundException e) {
            key = null;
            value = null;
        }
    }
}

