/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.util;

import com.googlecode.jmapper.api.JMapperAPI;
import com.googlecode.jmapper.config.JmapperLog;
import com.googlecode.jmapper.operations.NestedMappingHandler;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.XML;
import com.googlecode.jmapper.xml.beans.XmlAttribute;
import com.googlecode.jmapper.xml.beans.XmlClass;
import com.googlecode.jmapper.xml.beans.XmlJmapper;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigHelper<D, S> {
    private final Class<D> destinationClass;
    private final Class<S> sourceClass;
    private Class<?> mappedClass;
    private XmlClass xmlMappedClass;

    private static final XmlJmapper xmlToXStream(String xml) {
        try {
            return new XML(true, xml).toXStream();
        }
        catch (Exception e) {
            JmapperLog.error(e);
            throw new RuntimeException();
        }
    }

    private static final String annotationToXml(Class<?> destinationClass, Class<?> sourceClass) {
        return null;
    }

    private static final String checkNestedMapping(String fieldName) {
        if (NestedMappingHandler.isNestedMapping(fieldName)) {
            String[] nestedFields = NestedMappingHandler.nestedFields(fieldName);
            return nestedFields[nestedFields.length - 1];
        }
        return fieldName;
    }

    public ConfigHelper(Class<D> destinationClass, Class<S> sourceClass) {
        this(destinationClass, sourceClass, ConfigHelper.annotationToXml(destinationClass, sourceClass));
    }

    public ConfigHelper(Class<D> destinationClass, Class<S> sourceClass, String xml) {
        this(destinationClass, sourceClass, ConfigHelper.xmlToXStream(xml));
    }

    public ConfigHelper(Class<D> destinationClass, Class<S> sourceClass, JMapperAPI api) {
        this(destinationClass, sourceClass, api.toXStream());
    }

    private ConfigHelper(Class<D> destinationClass, Class<S> sourceClass, XmlJmapper root) {
        this.destinationClass = destinationClass;
        this.sourceClass = sourceClass;
        List<Class<?>> destinationHierarchy = ClassesManager.getAllsuperClasses(destinationClass);
        List<Class<?>> sourceHierarchy = ClassesManager.getAllsuperClasses(sourceClass);
        for (XmlClass xmlClass : root.classes) {
            for (Class<?> destinationHierarchyClass : destinationHierarchy) {
                if (!xmlClass.name.equals(destinationHierarchyClass.getName())) continue;
                this.mappedClass = destinationClass;
                break;
            }
            if (GeneralUtility.isNull(this.mappedClass)) {
                for (Class<?> sourceHierarchyClass : sourceHierarchy) {
                    if (!xmlClass.name.equals(sourceHierarchyClass.getName())) continue;
                    this.mappedClass = sourceClass;
                    break;
                }
            }
            if (GeneralUtility.isNull(this.mappedClass)) continue;
            this.xmlMappedClass = xmlClass;
        }
        if (GeneralUtility.isNull(this.mappedClass)) {
            // empty if block
        }
    }

    public String getSourceFieldName(String destinationFieldName) {
        if (this.mappedClass.equals(this.destinationClass)) {
            for (XmlAttribute xmlAttribute : this.xmlMappedClass.attributes) {
                if (!xmlAttribute.name.equals(destinationFieldName)) continue;
                if (GeneralUtility.isEmpty(xmlAttribute.classes)) {
                    // empty if block
                }
                Integer targetClassIndex = null;
                for (int i = 0; i < xmlAttribute.classes.size(); ++i) {
                    if (!xmlAttribute.classes.get((int)i).name.equals(this.sourceClass.getName())) continue;
                    targetClassIndex = i;
                }
                if (GeneralUtility.isNull(targetClassIndex)) {
                    // empty if block
                }
                if (!GeneralUtility.isEmpty(xmlAttribute.attributes)) {
                    return ConfigHelper.checkNestedMapping(xmlAttribute.attributes.get((int)targetClassIndex.intValue()).name);
                }
                return ConfigHelper.checkNestedMapping(xmlAttribute.value.name);
            }
        } else {
            String destinationField = ConfigHelper.checkNestedMapping(destinationFieldName);
            for (XmlAttribute xmlAttribute : this.xmlMappedClass.attributes) {
                int i;
                if (GeneralUtility.isEmpty(xmlAttribute.classes)) {
                    // empty if block
                }
                if (!GeneralUtility.isEmpty(xmlAttribute.attributes)) {
                    for (i = 0; i < xmlAttribute.attributes.size(); ++i) {
                        if (!xmlAttribute.attributes.get((int)i).name.equals(destinationField) || !xmlAttribute.classes.get((int)i).name.equals(this.destinationClass.getName())) continue;
                        return xmlAttribute.name;
                    }
                }
                if (!xmlAttribute.value.name.equals(destinationField)) continue;
                for (i = 0; i < xmlAttribute.classes.size(); ++i) {
                    if (!xmlAttribute.classes.get((int)i).name.equals(this.destinationClass.getName())) continue;
                    return xmlAttribute.name;
                }
            }
        }
        return "this return is never used";
    }

    public String getDestinationFieldName(String sourceFieldName) {
        if (this.mappedClass.equals(this.destinationClass)) {
            String sourceField = ConfigHelper.checkNestedMapping(sourceFieldName);
            for (XmlAttribute xmlAttribute : this.xmlMappedClass.attributes) {
                int i;
                if (GeneralUtility.isEmpty(xmlAttribute.classes)) {
                    // empty if block
                }
                if (!GeneralUtility.isEmpty(xmlAttribute.attributes)) {
                    for (i = 0; i < xmlAttribute.attributes.size(); ++i) {
                        if (!xmlAttribute.attributes.get((int)i).name.equals(sourceField) || !xmlAttribute.classes.get((int)i).name.equals(this.destinationClass.getName())) continue;
                        return xmlAttribute.name;
                    }
                }
                if (!xmlAttribute.value.name.equals(sourceField)) continue;
                for (i = 0; i < xmlAttribute.classes.size(); ++i) {
                    if (!xmlAttribute.classes.get((int)i).name.equals(this.destinationClass.getName())) continue;
                    return xmlAttribute.name;
                }
            }
        } else {
            for (XmlAttribute xmlAttribute : this.xmlMappedClass.attributes) {
                if (!xmlAttribute.name.equals(sourceFieldName)) continue;
                if (GeneralUtility.isEmpty(xmlAttribute.classes)) {
                    // empty if block
                }
                Integer targetClassIndex = null;
                for (int i = 0; i < xmlAttribute.classes.size(); ++i) {
                    if (!xmlAttribute.classes.get((int)i).name.equals(this.sourceClass.getName())) continue;
                    targetClassIndex = i;
                }
                if (GeneralUtility.isNull(targetClassIndex)) {
                    // empty if block
                }
                String valueName = !GeneralUtility.isEmpty(xmlAttribute.attributes) ? xmlAttribute.attributes.get((int)targetClassIndex.intValue()).name : xmlAttribute.value.name;
                return ConfigHelper.checkNestedMapping(valueName);
            }
        }
        return "this return is never used";
    }
}

