/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.util;

import com.googlecode.jmapper.annotations.JGlobalMap;
import com.googlecode.jmapper.annotations.JMap;
import com.googlecode.jmapper.annotations.JMapAccessor;
import com.googlecode.jmapper.annotations.JMapAccessors;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.config.ResourceLoader;
import com.googlecode.jmapper.exceptions.LoadingFileException;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.Attribute;
import com.googlecode.jmapper.xml.Global;
import com.googlecode.jmapper.xml.SimplyAttribute;
import com.googlecode.jmapper.xml.beans.XmlJmapper;
import com.thoughtworks.xstream.XStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilesManager {
    private static final String applicationRoot = "." + GeneralUtility.fileSeparator;

    public static void addConfigurationToClass(String path, Global global, List<Attribute> attributes, Class<?> aClass) throws NoSuchFieldException, IOException {
        FilesManager.writeFile(new File(path), FilesManager.linesToWrite(path, global, attributes, aClass));
    }

    private static List<String> linesToWrite(String path, Global global, List<Attribute> attributes, Class<?> aClass) throws NoSuchFieldException, IOException {
        String[] classIdentifier = new String[]{"class", "{", aClass.getSimpleName()};
        boolean classFound = false;
        FilesManager.verifyAttributes(aClass, attributes);
        HashMap<String, String> attributeTypes = FilesManager.getTypes(aClass, attributes);
        ArrayList<String> linesToWrite = new ArrayList<String>();
        List<String> lines = FilesManager.readFile(new File(path));
        if (!GeneralUtility.isEmpty(attributes)) {
            lines = FilesManager.addImport(lines, aClass, JMap.class);
            lines = FilesManager.addTargetClassesImport(lines, attributes, aClass);
        }
        if (!GeneralUtility.isNull(global)) {
            lines = FilesManager.addImport(lines, aClass, JGlobalMap.class);
        }
        if (FilesManager.containtsAccessors(global, attributes)) {
            lines = FilesManager.addImport(lines, aClass, JMapAccessor.class);
            lines = FilesManager.addImport(lines, aClass, JMapAccessors.class);
        }
        for (String line : lines) {
            if (GeneralUtility.containsAll(line, classIdentifier)) {
                if (global != null) {
                    linesToWrite.add(FilesManager.toAnnotation(global));
                }
                classFound = true;
            }
            if (classFound && !GeneralUtility.isEmpty(attributes)) {
                Attribute remove = null;
                for (Attribute attribute : attributes) {
                    String type;
                    String name = attribute.getName();
                    if (!GeneralUtility.containsAll(line, name, type = attributeTypes.get(name)) || line.contains("{")) continue;
                    linesToWrite.add(FilesManager.toAnnotation(attribute));
                    remove = attribute;
                }
                if (remove != null) {
                    attributes.remove(remove);
                }
            }
            linesToWrite.add(line);
        }
        return linesToWrite;
    }

    private static boolean containtsAccessors(Global global, List<Attribute> attributes) {
        if (!GeneralUtility.isNull(global)) {
            if (!GeneralUtility.isEmpty(global.getGet()) || !GeneralUtility.isEmpty(global.getSet())) {
                return true;
            }
            if (!GeneralUtility.isEmpty(global.getAttributes())) {
                for (SimplyAttribute attribute : global.getAttributes()) {
                    if (GeneralUtility.isEmpty(attribute.getGet()) && GeneralUtility.isEmpty(attribute.getSet())) continue;
                    return true;
                }
            }
        }
        if (!GeneralUtility.isEmpty(attributes)) {
            for (Attribute attribute : attributes) {
                if (!GeneralUtility.isEmpty(attribute.getGet()) || !GeneralUtility.isEmpty(attribute.getSet())) {
                    return true;
                }
                if (GeneralUtility.isEmpty(attribute.getAttributes())) continue;
                for (SimplyAttribute targetAttribute : attribute.getAttributes()) {
                    if (GeneralUtility.isEmpty(targetAttribute.getGet()) && GeneralUtility.isEmpty(targetAttribute.getSet())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private static String toAnnotation(Global global) {
        String[] excluded;
        Class<?>[] classes;
        SimplyAttribute[] attributes;
        Attribute attribute = new Attribute(global.getValue(), global.getAttributes());
        attribute.setGet(global.getGet());
        attribute.setSet(global.getSet());
        String accessor = FilesManager.toJMapAccessor(attribute);
        StringBuilder str = new StringBuilder();
        if (!GeneralUtility.isEmpty(accessor)) {
            str.append(accessor);
        }
        str.append("@JGlobalMap(");
        boolean before = false;
        if (global.getValue() != null) {
            str.append("value=\"" + global.getValue() + "\"");
            before = true;
        }
        if ((attributes = global.getAttributes()) != null) {
            if (before) {
                str.append(", ");
            } else {
                before = true;
            }
            str.append("attributes={");
            for (int i = 0; i < attributes.length; ++i) {
                str.append("\"" + attributes[i].getName() + "\"");
                if (i >= attributes.length - 1) continue;
                str.append(", ");
            }
            str.append("}");
        }
        if ((classes = global.getClasses()) != null) {
            if (before) {
                str.append(", ");
            } else {
                before = true;
            }
            str.append("classes={");
            for (int i = 0; i < classes.length; ++i) {
                str.append(classes[i].getSimpleName() + ".class");
                if (i >= classes.length - 1) continue;
                str.append(", ");
            }
            str.append("}");
        }
        if ((excluded = global.getExcluded()) != null) {
            if (before) {
                str.append(", ");
            }
            str.append("excluded={");
            for (int i = 0; i < excluded.length; ++i) {
                str.append("\"" + excluded[i] + "\"");
                if (i >= excluded.length - 1) continue;
                str.append(", ");
            }
            str.append("}");
        }
        str.append(")");
        if ("@JGlobalMap()".equals(str.toString())) {
            return "@JGlobalMap";
        }
        return str.toString();
    }

    private static String toJMap(Attribute attribute) {
        Class<?>[] classes;
        SimplyAttribute[] attributes;
        boolean before = false;
        StringBuilder str = new StringBuilder("@JMap(");
        if (attribute.getValue() != null) {
            str.append("value=\"" + attribute.getValue().getName() + "\"");
            before = true;
        }
        if ((attributes = attribute.getAttributes()) != null) {
            if (before) {
                str.append(", ");
            } else {
                before = true;
            }
            str.append("attributes={");
            for (int i = 0; i < attributes.length; ++i) {
                str.append("\"" + attributes[i].getName() + "\"");
                if (i >= attributes.length - 1) continue;
                str.append(", ");
            }
            str.append("}");
        }
        if ((classes = attribute.getClasses()) != null) {
            if (before) {
                str.append(", ");
            }
            str.append("classes={");
            for (int i = 0; i < classes.length; ++i) {
                str.append(classes[i].getSimpleName() + ".class");
                if (i >= classes.length - 1) continue;
                str.append(", ");
            }
            str.append("}");
        }
        str.append(")");
        if ("@JMap()".equals(str.toString())) {
            return "@JMap";
        }
        return str.toString();
    }

    private static String toJMapAccessor(String get, String set, String name) {
        if (GeneralUtility.isEmpty(get) && GeneralUtility.isEmpty(set)) {
            return "";
        }
        StringBuilder str = new StringBuilder("@JMapAccessor(name=\"" + name + "\"");
        if (!GeneralUtility.isEmpty(get)) {
            str.append(", get=\"" + get + "\"");
        }
        if (!GeneralUtility.isEmpty(set)) {
            str.append(", set=\"" + set + "\"");
        }
        str.append(")");
        return str.toString();
    }

    private static String toJMapAccessor(SimplyAttribute attribute) {
        String get = attribute.getGet();
        String set = attribute.getSet();
        String name = attribute.getName();
        return FilesManager.toJMapAccessor(get, set, name);
    }

    private static String toJMapAccessor(Attribute attribute) {
        String accessor;
        String get = attribute.getGet();
        String set = attribute.getSet();
        String name = attribute.getName();
        StringBuilder result = new StringBuilder("@JMapAccessors({");
        if (!GeneralUtility.isNull(attribute.getAttributes())) {
            for (SimplyAttribute targetAtr : attribute.getAttributes()) {
                String accessor2 = FilesManager.toJMapAccessor(targetAtr);
                if (GeneralUtility.isEmpty(accessor2)) continue;
                result.append("\n   " + accessor2 + ",");
            }
        }
        if (!GeneralUtility.isEmpty(accessor = FilesManager.toJMapAccessor(get, set, name))) {
            result.append("\n   " + accessor);
        } else {
            if (result.toString().equals("@JMapAccessors({")) {
                return "";
            }
            result = new StringBuilder(result.substring(0, result.length() - 1));
        }
        return result.append("\n})\n").toString();
    }

    private static String toAnnotation(Attribute attribute) {
        String accessor = FilesManager.toJMapAccessor(attribute);
        String jMap = FilesManager.toJMap(attribute);
        StringBuilder result = new StringBuilder();
        if (!GeneralUtility.isEmpty(accessor)) {
            result.append(accessor);
        }
        if (!GeneralUtility.isEmpty(jMap)) {
            result.append(jMap);
        }
        return result.toString();
    }

    private static HashMap<String, String> getTypes(Class<?> clazz, List<Attribute> attributes) throws SecurityException, NoSuchFieldException {
        HashMap<String, String> result = new HashMap<String, String>(attributes.size());
        for (Attribute attribute : attributes) {
            String attributeName = attribute.getName();
            String attributeType = FilesManager.getType(clazz.getDeclaredField(attributeName));
            result.put(attributeName, attributeType);
        }
        return result;
    }

    private static String getType(Field field) {
        String[] dep = field.getType().toString().split(" ");
        dep = dep[dep.length - 1].split("\\.");
        return dep[dep.length - 1];
    }

    private static void verifyAttributes(Class<?> clazz, List<Attribute> attributes) throws NoSuchFieldException {
        for (Attribute attribute : attributes) {
            try {
                clazz.getDeclaredField(attribute.getName());
            }
            catch (SecurityException e) {
                throw e;
            }
            catch (NoSuchFieldException e) {
                boolean founded = false;
                for (Class<?> superclass = clazz.getSuperclass(); superclass != Object.class && !founded; superclass = superclass.getSuperclass()) {
                    try {
                        superclass.getDeclaredField(attribute.getName());
                        founded = true;
                        continue;
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        // empty catch block
                    }
                }
                if (founded) continue;
                throw e;
            }
        }
    }

    public static void cleanClass(File file, Class<?> aClass, boolean cleanAll) throws IOException {
        FilesManager.writeFile(file, FilesManager.linesToWrite(file, aClass, cleanAll));
    }

    private static List<String> linesToWrite(File file, Class<?> aClass, boolean cleanAll) throws IOException {
        String[] classIdentifier = new String[]{"class", "{", aClass.getSimpleName()};
        List<String> linesToWrite = new ArrayList<String>();
        String previousLine = ":-P";
        boolean classFound = false;
        boolean classDefinitionFound = false;
        boolean moreLines = false;
        int annotatedFields = FilesManager.annotatedFieldsNumber(aClass);
        for (String line : FilesManager.readFile(file)) {
            String result;
            boolean newLine;
            HashMap<String, Object> cleanLine;
            if (GeneralUtility.containsAll(line, classIdentifier)) {
                classFound = true;
            }
            if (GeneralUtility.containsAll(line, "class", "{") && !GeneralUtility.containsAll(line, "=")) {
                classDefinitionFound = true;
            }
            if (!FilesManager.globalToClean(line) && FilesManager.globalToClean(previousLine)) {
                if (moreLines && (cleanAll && classDefinitionFound || classFound)) {
                    cleanLine = FilesManager.cleanLine(previousLine, moreLines, JGlobalMap.class);
                    newLine = (Boolean)cleanLine.get("newLine");
                    result = (String)cleanLine.get("result");
                    if (result != null) {
                        linesToWrite.add(result);
                    }
                    previousLine = line;
                    moreLines = newLine;
                    if (newLine) continue;
                    linesToWrite.add(line);
                    continue;
                }
                if (!classFound || cleanAll && !classDefinitionFound) {
                    linesToWrite.add(previousLine);
                    linesToWrite.add(line);
                    previousLine = line;
                    classDefinitionFound = false;
                    continue;
                }
                linesToWrite.add(line);
                previousLine = line;
                continue;
            }
            if (FilesManager.globalToClean(line)) {
                previousLine = line;
                continue;
            }
            if ((FilesManager.attributeToClean(line) || moreLines) && (cleanAll || classFound && annotatedFields > 0)) {
                cleanLine = FilesManager.cleanLine(line, moreLines, JMapAccessors.class, JMapAccessor.class, JMap.class);
                newLine = (Boolean)cleanLine.get("newLine");
                result = (String)cleanLine.get("result");
                if (result != null) {
                    linesToWrite.add(result);
                }
                moreLines = newLine;
                if (cleanAll || moreLines || newLine) continue;
                --annotatedFields;
                continue;
            }
            if (line.trim().equals("})")) continue;
            linesToWrite.add(line);
        }
        linesToWrite = FilesManager.deleteImport(linesToWrite);
        return linesToWrite;
    }

    private static HashMap<String, Object> cleanLine(String line, boolean moreLines, Class<?> ... annotation) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("newLine", moreLines);
        map.put("result", null);
        if (moreLines) {
            String result = FilesManager.verifyLine(line);
            if (!"newLine".equals(result)) {
                map.put("newLine", false);
                if (result.trim().length() > 0 && !result.trim().equals(",")) {
                    map.put("result", result);
                }
            }
            return map;
        }
        String result = FilesManager.subtractAnnotation(line, annotation);
        if (result.endsWith("newLine")) {
            map.put("newLine", true);
            result = result.substring(0, result.length() - "newLine".length());
        }
        if (result.trim().length() > 0) {
            map.put("result", result);
        }
        return map;
    }

    private static boolean attributeToClean(String line) {
        String jmap = "@" + JMap.class.getSimpleName();
        return line.contains(jmap);
    }

    private static boolean globalToClean(String line) {
        return line.contains("@" + JGlobalMap.class.getSimpleName());
    }

    private static String verifyLine(String line) {
        Integer end = line.indexOf(41);
        if (end == -1) {
            return "newLine";
        }
        end = end + 1;
        if (line.length() > end) {
            return line.substring(end, line.length());
        }
        return "";
    }

    private static String subtractAnnotation(String line, Class<?> ... annotations) {
        String afterAnnotation;
        Integer jmapEnd;
        String jmap = null;
        int jmapBegin = -1;
        String result = "";
        for (Class<?> annotation : annotations) {
            jmap = "@" + annotation.getSimpleName();
            jmapBegin = line.indexOf(jmap);
            if (jmapBegin != -1) break;
        }
        if (jmapBegin > 0) {
            result = line.substring(0, jmapBegin);
        }
        if (line.length() <= (jmapBegin += jmap.length())) {
            return result;
        }
        int apertura = line.indexOf(40, jmapBegin);
        if (apertura == -1) {
            result = result + line.substring(jmapBegin, line.length());
            return result;
        }
        if (apertura > jmapBegin + 1) {
            for (char c : line.substring(jmapBegin, apertura).toCharArray()) {
                if (c == ' ') continue;
                result = result + line.substring(jmapBegin, line.length());
                return result;
            }
        }
        if ((jmapEnd = Integer.valueOf(line.indexOf(41, jmapBegin))) == -1) {
            return result + "newLine";
        }
        jmapEnd = jmapEnd + 1;
        if (line.length() > jmapEnd && !(afterAnnotation = line.substring(jmapEnd, line.length())).trim().equals(",")) {
            result = result + afterAnnotation;
            return result;
        }
        return result;
    }

    private static int annotatedFieldsNumber(Class<?> aClass) {
        int count = 0;
        for (Field it : aClass.getDeclaredFields()) {
            if (it.getAnnotation(JMap.class) == null) continue;
            ++count;
        }
        return count;
    }

    private static List<String> addTargetClassesImport(List<String> lines, List<Attribute> attributes, Class<?> aClass) {
        ArrayList classes = new ArrayList();
        for (Attribute attribute : attributes) {
            if (attribute.getClasses() == null || attribute.getClasses().length <= 0) continue;
            for (Class<?> clazz : attribute.getClasses()) {
                if (classes.contains(clazz) || aClass.getPackage().getName().equals(clazz.getPackage().getName())) continue;
                classes.add(clazz);
            }
        }
        if (classes.isEmpty()) {
            return lines;
        }
        ArrayList<Class> alreadyImported = new ArrayList<Class>();
        for (Class clazz : classes) {
            if (!FilesManager.existImport(lines, clazz)) continue;
            alreadyImported.add(clazz);
        }
        classes.removeAll(alreadyImported);
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String line : lines) {
            arrayList.add(line);
            if (!FilesManager.packageFound(line, aClass)) continue;
            for (Class clazz : classes) {
                arrayList.add("import " + clazz.getName() + ";");
            }
        }
        return arrayList;
    }

    private static List<String> addImport(List<String> lines, Class<?> aClass, Class<?> classToImport) {
        if (FilesManager.existImport(lines, classToImport)) {
            return lines;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (String line : lines) {
            result.add(line);
            if (!FilesManager.packageFound(line, aClass)) continue;
            result.add("import " + classToImport.getName() + ";");
        }
        return result;
    }

    private static boolean existImport(List<String> lines, Class<?> aClass) {
        for (String line : lines) {
            if (!GeneralUtility.containsAll(line, "import", aClass.getName(), ";")) continue;
            return true;
        }
        return false;
    }

    private static List<String> deleteImport(List<String> lines) {
        return FilesManager.deleteSpecificImports(lines, JMap.class, JGlobalMap.class, JMapAccessors.class, JMapAccessor.class);
    }

    private static List<String> deleteSpecificImports(List<String> lines, Class<?> ... annotations) {
        List<String> result = lines;
        for (Class<?> annotation : annotations) {
            result = FilesManager.deleteSpecificImport(result, annotation);
        }
        return result;
    }

    private static List<String> deleteSpecificImport(List<String> lines, Class<?> annotation) {
        String[] annImport = new String[]{"import", annotation.getName() + ";"};
        boolean isAnnotated = false;
        for (String line : lines) {
            if (!line.contains("@" + annotation.getSimpleName())) continue;
            isAnnotated = true;
        }
        if (!isAnnotated) {
            ArrayList<String> result = new ArrayList<String>();
            for (String line : lines) {
                if (GeneralUtility.containsAll(line, annImport)) continue;
                result.add(line);
            }
            return result;
        }
        return lines;
    }

    private static boolean packageFound(String line, Class<?> aClass) {
        return GeneralUtility.containsAll(line, "package", aClass.getPackage().getName(), ";");
    }

    public static boolean verifyFileExistence(String path) {
        File file = new File(path);
        return file.exists() && file.isFile();
    }

    public static File searchFile(String name) throws FileNotFoundException {
        File file = FilesManager.searchFile(new File(applicationRoot), name);
        if (GeneralUtility.isNull(file)) {
            Error.fileNotFound(name);
        }
        return file;
    }

    private static File searchFile(File file, String name) {
        if (file.isDirectory()) {
            for (File it : file.listFiles()) {
                if (FilesManager.searchFile(it, name) == null) continue;
                return FilesManager.searchFile(it, name);
            }
        }
        if (file.getName().equals(name)) {
            return file;
        }
        return null;
    }

    public static List<String> classesPath() throws FileNotFoundException, LoadingFileException {
        List<File> files = FilesManager.getJavaFiles();
        ArrayList<String> paths = new ArrayList<String>();
        for (File file : files) {
            paths.add(file.getPath());
        }
        return paths;
    }

    public static List<File> annotatedFiles() throws FileNotFoundException, LoadingFileException, IOException {
        ArrayList<File> annotatedFiles = new ArrayList<File>();
        for (File javaFile : FilesManager.getJavaFiles()) {
            if (!FilesManager.isFileAnnotated(javaFile)) continue;
            annotatedFiles.add(javaFile);
        }
        return annotatedFiles;
    }

    public static List<Class<?>> annotatedClasses() throws LoadingFileException, IOException, ClassNotFoundException {
        ArrayList annotatedClasses = new ArrayList();
        for (File javaFile : FilesManager.annotatedFiles()) {
            String fileName = javaFile.getName().substring(0, javaFile.getName().length() - ".java".length());
            annotatedClasses.add(Class.forName(FilesManager.getPackage(javaFile) + "." + fileName));
        }
        return annotatedClasses;
    }

    private static String getPackage(File file) throws IOException {
        for (String line : FilesManager.readFile(file)) {
            if (!line.contains("package")) continue;
            String packageName = line.split(" ")[1];
            return packageName.substring(0, packageName.length() - 1);
        }
        return null;
    }

    private static List<File> getJavaFiles() throws FileNotFoundException, LoadingFileException {
        ArrayList<File> files = new ArrayList<File>();
        FilesManager.getFiles(new File(applicationRoot), files, ".java");
        return files;
    }

    private static void getFiles(File file, List<File> result, String suffix) {
        if (file.isDirectory()) {
            for (File it : file.listFiles()) {
                FilesManager.getFiles(it, result, suffix);
            }
        } else if (file.getName().endsWith(suffix)) {
            result.add(file);
        }
    }

    public static boolean isFileAnnotated(String path, Class<?> aClass) throws IOException {
        return FilesManager.isFileAnnotated(new File(path), aClass);
    }

    private static boolean isFileAnnotated(File file, Class<?> aClass) throws IOException {
        String[] classIdentifier = new String[]{"class", "{", aClass.getSimpleName()};
        boolean classFound = false;
        String previuosLine = "";
        for (String line : FilesManager.readFile(file)) {
            if (GeneralUtility.containsAll(line, classIdentifier)) {
                classFound = true;
            }
            if (classFound && (previuosLine.contains("@JGlobalMap") || line.contains("@JMap"))) {
                return true;
            }
            previuosLine = line;
        }
        return false;
    }

    private static boolean isFileAnnotated(File file) throws IOException {
        for (String line : FilesManager.readFile(file)) {
            if (!line.contains("@JMap") && !line.contains("@JGlobalMap")) continue;
            return true;
        }
        return false;
    }

    private static List<String> readFile(File file) throws IOException {
        String line;
        FileReader fr = new FileReader(file);
        BufferedReader br = new BufferedReader(fr);
        ArrayList<String> lines = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            lines.add(line);
        }
        fr.close();
        br.close();
        return lines;
    }

    private static void writeFile(File file, List<String> lines) throws IOException {
        if (!file.exists()) {
            file.createNewFile();
        }
        FileWriter fw = new FileWriter(file);
        BufferedWriter Bw = new BufferedWriter(fw);
        PrintWriter pw = new PrintWriter(Bw);
        for (String line : lines) {
            pw.println(line);
        }
        Bw.close();
        fw.close();
        pw.close();
    }

    public static void write(XmlJmapper jmapper, String xmlPath) throws IOException {
        XStream xstream = new XStream();
        xstream.processAnnotations(XmlJmapper.class);
        FilesManager.writeFile(new File(xmlPath), GeneralUtility.list(xstream.toXML((Object)jmapper)));
    }

    public static XmlJmapper readAtDevelopmentTime(String xmlPath) throws FileNotFoundException {
        return FilesManager.toXmlJmapper(xmlPath, new FileInputStream(FilesManager.searchFile(xmlPath)));
    }

    public static XmlJmapper readAtRuntime(String xmlPath) throws MalformedURLException, IOException {
        return FilesManager.toXmlJmapper(xmlPath, ResourceLoader.loadResource(xmlPath));
    }

    private static XmlJmapper toXmlJmapper(String path, InputStream is) throws FileNotFoundException {
        XStream xstream = new XStream();
        xstream.processAnnotations(XmlJmapper.class);
        if (is != null) {
            return (XmlJmapper)xstream.fromXML(is);
        }
        Error.fileNotFound(path);
        return null;
    }

    public static String fullPathOf(String fileName) throws FileNotFoundException {
        return FilesManager.searchFile(fileName).getAbsolutePath();
    }

    public static boolean isPath(String resource) {
        return resource.endsWith(".xml") || resource.endsWith(".properties");
    }
}

