/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.util;

import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.xml.SimplyAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.bidimap.DualHashBidiMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GeneralUtility {
    public static final String newLine = System.getProperty("line.separator");
    public static final String fileSeparator = System.getProperty("file.separator");
    public static final DualHashBidiMap implementationClass = new DualHashBidiMap();
    private static final ArrayList<String> basicTypes = new ArrayList();

    private GeneralUtility() {
    }

    public static boolean isCastCase(Class<?> destination, Class<?> source) {
        return GeneralUtility.areBasic(destination, source) && !ClassesManager.isAssignableFrom(destination, source) && GeneralUtility.isObject(source);
    }

    public static boolean isObject(Class<?> clazz) {
        return clazz.equals(Object.class);
    }

    public static boolean isBasic(Class<?> aClass) {
        return basicTypes.contains(aClass.getName());
    }

    public static boolean isAccessModifier(String str) {
        return str.equals("static") || str.equals("public") || str.equals("protected") || str.equals("private") || str.equals("final") || str.equals("transient");
    }

    public static <T> List<T> toList(T[] anArrayToConvert) {
        ArrayList aListToEnrich = new ArrayList();
        GeneralUtility.enrichList(aListToEnrich, anArrayToConvert);
        return aListToEnrich;
    }

    public static <T> void enrichList(List<T> aListToEnrich, T[] anArrayToAdd) {
        if (anArrayToAdd != null) {
            aListToEnrich.addAll(Arrays.asList(anArrayToAdd));
        }
    }

    public static boolean isStructure(Class<?> aClass) {
        return GeneralUtility.collectionIsAssignableFrom(aClass) || GeneralUtility.mapIsAssignableFrom(aClass) || GeneralUtility.isArray(aClass);
    }

    public static boolean areBasic(Class<?> dClass, Class<?> sClass) {
        return GeneralUtility.isBasic(dClass) && GeneralUtility.isBasic(sClass);
    }

    public static boolean collectionIsAssignableFrom(Class<?> aClass) {
        return Collection.class.isAssignableFrom(aClass);
    }

    public static boolean mapIsAssignableFrom(Class<?> aClass) {
        return Map.class.isAssignableFrom(aClass);
    }

    public static boolean listIsAssignableFrom(Class<?> aClass) {
        return List.class.isAssignableFrom(aClass);
    }

    public static boolean sortedSetIsAssignableFrom(Class<?> aClass) {
        return SortedSet.class.isAssignableFrom(aClass);
    }

    private static boolean isArray(Class<?> aClass) {
        return aClass.isArray();
    }

    public static String mGet(String fieldName) {
        return "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String mSet(String fieldName) {
        return "set" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    private static String mIs(String fieldName) {
        return "is" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
    }

    public static String getMethod(Class<?> clazz, String field) {
        return GeneralUtility.isBoolean(clazz) ? GeneralUtility.mIs(field) : GeneralUtility.mGet(field);
    }

    public static boolean isBoolean(Class<?> clazz) {
        return clazz == Boolean.TYPE || clazz == Boolean.class;
    }

    public static <E> ArrayList<E> list(E ... elements) {
        ArrayList<E> list = new ArrayList<E>();
        for (E element : elements) {
            list.add(element);
        }
        return list;
    }

    public static boolean isEmpty(Collection<?> collection) {
        return GeneralUtility.isNull(collection) || collection.isEmpty();
    }

    public static boolean isEmpty(String str) {
        return GeneralUtility.isNull(str) || str.length() <= 0;
    }

    public static boolean isEmpty(StringBuilder str) {
        return GeneralUtility.isNull(str) || str.length() <= 0;
    }

    public static boolean isEmpty(Object[] array) {
        return GeneralUtility.isNull(array) || array.length <= 0;
    }

    public static boolean containsAll(String line, String ... elements) {
        for (String element : elements) {
            if (line.contains(element)) continue;
            return false;
        }
        return true;
    }

    public static boolean isPresent(SimplyAttribute[] array, SimplyAttribute element) {
        if (!GeneralUtility.isNull(array)) {
            for (SimplyAttribute item : array) {
                if (!element.getName().matches(item.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isPresent(String[] array, String element) {
        if (!GeneralUtility.isNull(array)) {
            for (String item : array) {
                if (!element.matches(item)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isNull(Object obj) {
        return obj == null;
    }

    public static String replace$(String text, Map<String, String> vars) {
        return GeneralUtility.replace(text, vars, "$");
    }

    private static String replace(String text, Map<String, String> vars, String prefix) {
        for (Map.Entry<String, String> var : vars.entrySet()) {
            text = text.replaceAll(Pattern.quote(prefix + var.getKey()), Matcher.quoteReplacement(var.getValue()));
        }
        return text;
    }

    public static String write(String ... strings) {
        return GeneralUtility.write(new StringBuilder(), strings);
    }

    public static String write(StringBuilder sb, String ... strings) {
        for (String string : strings) {
            sb.append(string);
        }
        return sb.toString();
    }

    public static String join(String charSeparator, String ... strings) {
        String result = strings[0];
        for (int i = 1; i < strings.length; ++i) {
            result = result + charSeparator + strings[i];
        }
        return result;
    }

    static {
        implementationClass.put((Object)Collection.class.getName(), ArrayList.class);
        implementationClass.put((Object)List.class.getName(), ArrayList.class);
        implementationClass.put((Object)Set.class.getName(), HashSet.class);
        implementationClass.put((Object)Queue.class.getName(), LinkedList.class);
        implementationClass.put((Object)SortedSet.class.getName(), TreeSet.class);
        implementationClass.put((Object)Map.class.getName(), HashMap.class);
        implementationClass.put((Object)SortedMap.class.getName(), TreeMap.class);
        basicTypes.add(Byte.TYPE.getName());
        basicTypes.add(Short.TYPE.getName());
        basicTypes.add(Integer.TYPE.getName());
        basicTypes.add(Long.TYPE.getName());
        basicTypes.add(Float.TYPE.getName());
        basicTypes.add(Double.TYPE.getName());
        basicTypes.add(Character.TYPE.getName());
        basicTypes.add(Boolean.TYPE.getName());
        basicTypes.add(Byte.class.getName());
        basicTypes.add(Short.class.getName());
        basicTypes.add(Integer.class.getName());
        basicTypes.add(Long.class.getName());
        basicTypes.add(Float.class.getName());
        basicTypes.add(Double.class.getName());
        basicTypes.add(Character.class.getName());
        basicTypes.add(Boolean.class.getName());
        basicTypes.add(String.class.getName());
        basicTypes.add(Object.class.getName());
    }
}

