/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.xml;

import com.googlecode.jmapper.annotations.Annotation;
import com.googlecode.jmapper.annotations.JGlobalMap;
import com.googlecode.jmapper.annotations.JMap;
import com.googlecode.jmapper.annotations.JMapAccessor;
import com.googlecode.jmapper.annotations.JMapConversion;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.conversions.explicit.ConversionMethod;
import com.googlecode.jmapper.exceptions.ConversionParameterException;
import com.googlecode.jmapper.exceptions.DynamicConversionBodyException;
import com.googlecode.jmapper.exceptions.DynamicConversionMethodException;
import com.googlecode.jmapper.exceptions.DynamicConversionParameterException;
import com.googlecode.jmapper.exceptions.XmlConversionNameException;
import com.googlecode.jmapper.exceptions.XmlConversionParameterException;
import com.googlecode.jmapper.exceptions.XmlConversionTypeException;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.Attribute;
import com.googlecode.jmapper.xml.Global;
import com.googlecode.jmapper.xml.SimplyAttribute;
import com.googlecode.jmapper.xml.Value;
import com.googlecode.jmapper.xml.beans.XmlAttribute;
import com.googlecode.jmapper.xml.beans.XmlClass;
import com.googlecode.jmapper.xml.beans.XmlConversion;
import com.googlecode.jmapper.xml.beans.XmlExcludedAttribute;
import com.googlecode.jmapper.xml.beans.XmlGlobal;
import com.googlecode.jmapper.xml.beans.XmlTargetAttribute;
import com.googlecode.jmapper.xml.beans.XmlTargetClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Converter {
    public static XmlClass toXmlClass(Class<?> aClass) {
        XmlClass xmlClass = new XmlClass();
        xmlClass.name = aClass.getName();
        xmlClass.attributes = new ArrayList<XmlAttribute>();
        if (aClass.getAnnotation(JGlobalMap.class) != null) {
            xmlClass.global = Converter.toXmlGlobal(aClass);
        }
        for (Field field : aClass.getDeclaredFields()) {
            if (field.getAnnotation(JMap.class) == null) continue;
            xmlClass.attributes.add(Converter.toXmlAttribute(aClass, field));
        }
        return xmlClass;
    }

    public static ConversionMethod toConversionMethod(XmlConversion xmlConversion) {
        String[] stringArray;
        String[] from;
        String[] stringArray2;
        JMapConversion.Type type;
        if (GeneralUtility.isEmpty(xmlConversion.name)) {
            xmlConversion.name = "undefinedName";
            throw new XmlConversionNameException("it's mandatory define a name");
        }
        String name = xmlConversion.name;
        String conversionType = xmlConversion.type;
        boolean avoidSet = xmlConversion.avoidSet;
        JMapConversion.Type type2 = conversionType == null ? JMapConversion.Type.STATIC : (conversionType.equalsIgnoreCase("STATIC") ? JMapConversion.Type.STATIC : (type = conversionType.equalsIgnoreCase("DYNAMIC") ? JMapConversion.Type.DYNAMIC : null));
        if (type == null) {
            throw new XmlConversionTypeException("wrong type defined, only STATIC and DYNAMIC options are permitted");
        }
        if (xmlConversion.from == null) {
            String[] stringArray3 = new String[1];
            stringArray2 = stringArray3;
            stringArray3[0] = "all";
        } else {
            stringArray2 = from = Converter.trim(xmlConversion.from.split(","));
        }
        if (xmlConversion.to == null) {
            String[] stringArray4 = new String[1];
            stringArray = stringArray4;
            stringArray4[0] = "all";
        } else {
            stringArray = Converter.trim(xmlConversion.to.split(","));
        }
        String[] to = stringArray;
        String content = xmlConversion.content.trim();
        if (!content.contains("${source}") && content.contains("${destination}")) {
            throw new XmlConversionParameterException("the use of the destination isn't permitted without the use of the source");
        }
        ConversionMethod.ParameterNumber number = content.contains("${source}") ? (content.contains("${destination}") ? ConversionMethod.ParameterNumber.TWO : ConversionMethod.ParameterNumber.ONE) : ConversionMethod.ParameterNumber.ZERO;
        return new ConversionMethod(name, from, to, type, number, content, avoidSet);
    }

    public static ConversionMethod toConversionMethod(Method aMethod) {
        JMapConversion conversion = aMethod.getAnnotation(JMapConversion.class);
        String name = aMethod.getName();
        String[] from = Converter.trim(conversion.from());
        String[] to = Converter.trim(conversion.to());
        JMapConversion.Type type = conversion.type();
        boolean avoidSet = conversion.avoidSet();
        ConversionMethod.ParameterNumber number = null;
        String body = null;
        switch (type) {
            case STATIC: {
                switch (aMethod.getParameterTypes().length) {
                    case 1: {
                        number = ConversionMethod.ParameterNumber.ONE;
                        break;
                    }
                    case 2: {
                        number = ConversionMethod.ParameterNumber.TWO;
                        break;
                    }
                    default: {
                        throw new ConversionParameterException("is allowed to use from one to two parameters");
                    }
                }
                body = "not needed";
                break;
            }
            case DYNAMIC: {
                if (aMethod.getParameterTypes().length != 0) {
                    throw new DynamicConversionParameterException("is not allowed parameters usage in a dynamic method");
                }
                try {
                    body = (String)aMethod.invoke(null, new Object[0]);
                }
                catch (Exception e) {
                    throw new DynamicConversionMethodException("the method don't respects the conventions");
                }
                if (!body.contains("${source}") && body.contains("${destination}")) {
                    throw new DynamicConversionBodyException("the use of the destination isn't permitted without the use of the source");
                }
                number = body.contains("${source}") ? (body.contains("${destination}") ? ConversionMethod.ParameterNumber.TWO : ConversionMethod.ParameterNumber.ONE) : ConversionMethod.ParameterNumber.ZERO;
            }
        }
        return new ConversionMethod(name, from, to, type, number, body, avoidSet);
    }

    public static Attribute toAttribute(XmlAttribute xmlAttribute) {
        int i;
        String name = xmlAttribute.name;
        Value value = null;
        if (!GeneralUtility.isNull(xmlAttribute.value)) {
            value = new Value(xmlAttribute.value);
        }
        String get = xmlAttribute.get;
        String set = xmlAttribute.set;
        SimplyAttribute[] attributes = null;
        Class[] classes = null;
        if (!GeneralUtility.isEmpty(xmlAttribute.attributes)) {
            attributes = new SimplyAttribute[xmlAttribute.attributes.size()];
            i = xmlAttribute.attributes.size();
            while (i-- > 0) {
                attributes[i] = new SimplyAttribute(xmlAttribute.attributes.get(i));
            }
        }
        if (!GeneralUtility.isEmpty(xmlAttribute.classes)) {
            classes = new Class[xmlAttribute.classes.size()];
            i = xmlAttribute.classes.size();
            while (i-- > 0) {
                try {
                    classes[i] = Class.forName(xmlAttribute.classes.get((int)i).name);
                }
                catch (Exception e) {
                    Error.classInexistent(xmlAttribute.classes.get((int)i).name);
                }
            }
        }
        return new Attribute(name, value, get, set, attributes, classes);
    }

    public static Global toGlobal(XmlGlobal xmlGlobal) {
        int i;
        String name = !GeneralUtility.isNull(xmlGlobal.value) && !GeneralUtility.isNull(xmlGlobal.value.name) ? xmlGlobal.value.name : null;
        String get = !GeneralUtility.isNull(xmlGlobal.value) && !GeneralUtility.isNull(xmlGlobal.value.get) ? xmlGlobal.value.get : null;
        String set = !GeneralUtility.isNull(xmlGlobal.value) && !GeneralUtility.isNull(xmlGlobal.value.set) ? xmlGlobal.value.set : null;
        SimplyAttribute[] attributes = null;
        Class[] classes = null;
        String[] excluded = null;
        if (!GeneralUtility.isEmpty(xmlGlobal.attributes)) {
            attributes = new SimplyAttribute[xmlGlobal.attributes.size()];
            i = xmlGlobal.attributes.size();
            while (i-- > 0) {
                attributes[i] = new SimplyAttribute(xmlGlobal.attributes.get(i));
            }
        }
        if (!GeneralUtility.isEmpty(xmlGlobal.classes)) {
            classes = new Class[xmlGlobal.classes.size()];
            i = xmlGlobal.classes.size();
            while (i-- > 0) {
                try {
                    classes[i] = Class.forName(xmlGlobal.classes.get((int)i).name);
                }
                catch (Exception e) {
                    Error.classInexistent(xmlGlobal.classes.get((int)i).name);
                }
            }
        }
        if (!GeneralUtility.isEmpty(xmlGlobal.excluded)) {
            excluded = new String[xmlGlobal.excluded.size()];
            i = xmlGlobal.excluded.size();
            while (i-- > 0) {
                excluded[i] = xmlGlobal.excluded.get((int)i).name;
            }
        }
        return new Global(name, get, set, attributes, classes, excluded);
    }

    public static XmlGlobal toXmlGlobal(Global global) {
        return Converter.toXmlGlobal(global.getValue(), global.getGet(), global.getSet(), global.getAttributes(), global.getClasses(), global.getExcluded());
    }

    private static XmlGlobal toXmlGlobal(Class<?> aClass) {
        JGlobalMap globalMap = aClass.getAnnotation(JGlobalMap.class);
        JMapAccessor targetAccessor = aClass.getAnnotation(JMapAccessor.class);
        String get = targetAccessor != null ? targetAccessor.get() : "";
        String set = targetAccessor != null ? targetAccessor.set() : "";
        SimplyAttribute[] targetAttributes = Converter.toTargetAttributes(globalMap.attributes());
        return Converter.toXmlGlobal(globalMap.value(), get, set, targetAttributes, globalMap.classes(), globalMap.excluded());
    }

    private static XmlGlobal toXmlGlobal(String value, String get, String set, SimplyAttribute[] attributes, Class<?>[] classes, String[] excluded) {
        XmlGlobal xmlGlobal = new XmlGlobal();
        if (!GeneralUtility.isEmpty(value)) {
            xmlGlobal.value = new XmlTargetAttribute(value);
        }
        if (!GeneralUtility.isEmpty(get)) {
            xmlGlobal.value.get = get;
        }
        if (!GeneralUtility.isEmpty(set)) {
            xmlGlobal.value.set = set;
        }
        if (!GeneralUtility.isEmpty(attributes)) {
            xmlGlobal.attributes = new ArrayList<XmlTargetAttribute>();
            for (SimplyAttribute simplyAttribute : attributes) {
                xmlGlobal.attributes.add(new XmlTargetAttribute(simplyAttribute));
            }
        }
        if (!GeneralUtility.isEmpty(classes)) {
            xmlGlobal.classes = new ArrayList<XmlTargetClass>();
            for (Class<?> clazz : classes) {
                xmlGlobal.classes.add(new XmlTargetClass(clazz.getName()));
            }
        }
        if (!GeneralUtility.isEmpty(excluded)) {
            xmlGlobal.excluded = new ArrayList<XmlExcludedAttribute>();
            for (String string : excluded) {
                xmlGlobal.excluded.add(new XmlExcludedAttribute(string));
            }
        }
        return xmlGlobal;
    }

    public static SimplyAttribute[] toTargetAttributes(String[] attributes) {
        SimplyAttribute[] targetAttributes = new SimplyAttribute[attributes.length];
        for (int i = 0; i < attributes.length; ++i) {
            targetAttributes[i] = new SimplyAttribute(attributes[i]);
        }
        return targetAttributes;
    }

    public static XmlAttribute toXmlAttribute(Class<?> clazz, Field field) {
        JMap jMap = field.getAnnotation(JMap.class);
        SimplyAttribute[] targetAttributes = Converter.toTargetAttributes(jMap.attributes());
        String get = null;
        String set = null;
        JMapAccessor jMapAccessor = Annotation.getFieldAccessors(clazz, field);
        if (!GeneralUtility.isNull(jMapAccessor)) {
            get = jMapAccessor.get();
            set = jMapAccessor.set();
        }
        return Converter.toXmlAttribute(field.getName(), new Value(jMap.value()), get, set, targetAttributes, jMap.classes());
    }

    public static XmlAttribute toXmlAttribute(Attribute attribute) {
        return Converter.toXmlAttribute(attribute.getName(), attribute.getValue(), attribute.getGet(), attribute.getSet(), attribute.getAttributes(), attribute.getClasses());
    }

    private static XmlAttribute toXmlAttribute(String name, Value value, String get, String set, SimplyAttribute[] attributes, Class<?>[] classes) {
        String targetName;
        XmlAttribute xmlAttribute = new XmlAttribute();
        xmlAttribute.name = name;
        xmlAttribute.get = get;
        xmlAttribute.set = set;
        if (!(GeneralUtility.isNull(value) || GeneralUtility.isNull(targetName = value.getName()) || GeneralUtility.isEmpty(targetName) && !"".equals(targetName))) {
            xmlAttribute.value = new XmlTargetAttribute(Converter.getValue(targetName, name));
        }
        if (!GeneralUtility.isEmpty(attributes)) {
            xmlAttribute.attributes = new ArrayList<XmlTargetAttribute>();
            for (SimplyAttribute attribute : attributes) {
                xmlAttribute.attributes.add(new XmlTargetAttribute(Converter.getValue(attribute.getName(), name), attribute.getGet(), attribute.getSet()));
            }
        }
        if (!GeneralUtility.isEmpty(classes)) {
            xmlAttribute.classes = new ArrayList<XmlTargetClass>();
            for (Class<?> clazz : classes) {
                xmlAttribute.classes.add(new XmlTargetClass(clazz.getName()));
            }
        }
        return xmlAttribute;
    }

    private static String getValue(String value, String name) {
        if (value == null) {
            return null;
        }
        return value.equals("") ? name : value;
    }

    private static String[] trim(String[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = array[i].trim();
        }
        return array;
    }
}

