/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.xml;

import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.config.JmapperLog;
import com.googlecode.jmapper.conversions.explicit.ConversionMethod;
import com.googlecode.jmapper.exceptions.XmlConversionNameException;
import com.googlecode.jmapper.exceptions.XmlConversionParameterException;
import com.googlecode.jmapper.exceptions.XmlConversionTypeException;
import com.googlecode.jmapper.operations.beans.MappedField;
import com.googlecode.jmapper.util.ClassesManager;
import com.googlecode.jmapper.util.FilesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.Attribute;
import com.googlecode.jmapper.xml.Converter;
import com.googlecode.jmapper.xml.Global;
import com.googlecode.jmapper.xml.SimplyAttribute;
import com.googlecode.jmapper.xml.Value;
import com.googlecode.jmapper.xml.beans.XmlAttribute;
import com.googlecode.jmapper.xml.beans.XmlClass;
import com.googlecode.jmapper.xml.beans.XmlConversion;
import com.googlecode.jmapper.xml.beans.XmlJmapper;
import java.io.IOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class XML {
    private String xmlPath;
    private XmlJmapper xmlJmapper;

    public XML(boolean atRuntime, String xmlPath) throws MalformedURLException, IOException {
        if (!GeneralUtility.isNull(xmlPath)) {
            XmlJmapper xmlJmapper = this.xmlJmapper = atRuntime ? FilesManager.readAtRuntime(xmlPath) : FilesManager.readAtDevelopmentTime(xmlPath);
            this.xmlPath = FilesManager.isPath(xmlPath) ? (atRuntime ? xmlPath : FilesManager.fullPathOf(xmlPath)) : "";
        }
        if (GeneralUtility.isNull(this.xmlJmapper)) {
            this.xmlJmapper = new XmlJmapper();
        }
        if (GeneralUtility.isNull(this.xmlJmapper.classes)) {
            this.xmlJmapper.classes = new ArrayList<XmlClass>();
        }
    }

    public XML() {
        this.xmlJmapper = new XmlJmapper();
        this.xmlJmapper.classes = new ArrayList<XmlClass>();
    }

    public XmlJmapper toXStream() {
        return this.xmlJmapper;
    }

    public String getXmlPath() {
        return this.xmlPath;
    }

    public boolean exists() {
        return this.xmlPath != null;
    }

    public XML setXmlPath(String aXmlPath) {
        this.xmlPath = aXmlPath;
        return this;
    }

    public Map<String, Global> loadGlobals() {
        HashMap<String, Global> map = new HashMap<String, Global>();
        try {
            if (!GeneralUtility.isEmpty(this.xmlJmapper.classes)) {
                for (XmlClass xmlClass : this.xmlJmapper.classes) {
                    if (xmlClass.global == null) continue;
                    map.put(xmlClass.name, Converter.toGlobal(xmlClass.global));
                }
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return map;
    }

    public Map<String, List<Attribute>> loadAttributes() {
        HashMap<String, List<Attribute>> map = new HashMap<String, List<Attribute>>();
        try {
            if (!GeneralUtility.isEmpty(this.xmlJmapper.classes)) {
                for (XmlClass xmlClass : this.xmlJmapper.classes) {
                    ArrayList<Attribute> attributes = new ArrayList<Attribute>();
                    if (!GeneralUtility.isEmpty(xmlClass.attributes)) {
                        for (XmlAttribute xmlAttribute : xmlClass.attributes) {
                            attributes.add(Converter.toAttribute(xmlAttribute));
                        }
                    }
                    map.put(xmlClass.name, attributes);
                }
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return map;
    }

    public Map<String, List<ConversionMethod>> conversionsLoad() {
        HashMap<String, List<ConversionMethod>> map = new HashMap<String, List<ConversionMethod>>();
        try {
            if (!GeneralUtility.isEmpty(this.xmlJmapper.classes)) {
                for (XmlClass xmlClass : this.xmlJmapper.classes) {
                    ArrayList<ConversionMethod> conversions = new ArrayList<ConversionMethod>();
                    if (!GeneralUtility.isEmpty(xmlClass.conversions)) {
                        for (XmlConversion xmlConversion : xmlClass.conversions) {
                            try {
                                conversions.add(Converter.toConversionMethod(xmlConversion));
                            }
                            catch (XmlConversionNameException e) {
                                Error.xmlConversionNameUndefined(this.xmlPath, xmlClass.name);
                            }
                            catch (XmlConversionTypeException e) {
                                Error.xmlConversionTypeIncorrect(xmlConversion.name, this.xmlPath, xmlClass.name, xmlConversion.type);
                            }
                            catch (XmlConversionParameterException e) {
                                Error.improperUseOfTheParameter(xmlConversion.name, this.xmlPath, xmlClass.name);
                            }
                        }
                    }
                    if (conversions.isEmpty()) continue;
                    map.put(xmlClass.name, conversions);
                }
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return map;
    }

    public List<ConversionMethod> getConversionMethods(Class<?> clazz) {
        ArrayList<ConversionMethod> conversions = new ArrayList<ConversionMethod>();
        Map<String, List<ConversionMethod>> conversionsMap = this.conversionsLoad();
        for (Class<?> classToCheck : ClassesManager.getAllsuperClasses(clazz)) {
            List<ConversionMethod> methods = conversionsMap.get(classToCheck.getName());
            if (methods == null) continue;
            conversions.addAll(methods);
        }
        return conversions;
    }

    public List<String> getClasses() {
        ArrayList<String> classes = new ArrayList<String>();
        for (XmlClass xmlClass : this.xmlJmapper.classes) {
            classes.add(xmlClass.name);
        }
        return classes;
    }

    public XML write() {
        try {
            FilesManager.write(this.xmlJmapper, this.xmlPath);
        }
        catch (IOException e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XML addAnnotatedClass(Class<?> aClass) {
        this.checksClassAbsence(aClass);
        this.addClass(aClass);
        return this;
    }

    public XML addClass(Class<?> aClass, Attribute[] attributes) {
        this.checksClassAbsence(aClass);
        XmlClass xmlClass = new XmlClass();
        xmlClass.name = aClass.getName();
        xmlClass.attributes = new ArrayList<XmlAttribute>();
        this.xmlJmapper.classes.add(xmlClass);
        this.addAttributes(aClass, attributes);
        return this;
    }

    public XML addClass(Class<?> aClass, Global global) {
        this.checksClassAbsence(aClass);
        XmlClass xmlClass = new XmlClass();
        xmlClass.name = aClass.getName();
        this.xmlJmapper.classes.add(xmlClass);
        this.addGlobal(aClass, global);
        return this;
    }

    public XML addClass(Class<?> aClass, Global global, Attribute[] attributes) {
        XmlClass xmlClass = new XmlClass();
        xmlClass.name = aClass.getName();
        this.xmlJmapper.classes.add(xmlClass);
        if (!GeneralUtility.isEmpty(attributes)) {
            xmlClass.attributes = new ArrayList<XmlAttribute>();
            this.addAttributes(aClass, attributes);
        }
        if (global != null) {
            this.addGlobal(aClass, global);
        }
        return this;
    }

    public XML deleteClass(Class<?> aClass) {
        boolean isRemoved = this.xmlJmapper.classes.remove(new XmlClass(aClass.getName()));
        if (!isRemoved) {
            Error.xmlClassInexistent(this.xmlPath, aClass);
        }
        return this;
    }

    public XML addGlobal(Class<?> aClass, Global global) {
        this.checksGlobalAbsence(aClass);
        this.findXmlClass(aClass).global = Converter.toXmlGlobal(global);
        return this;
    }

    public XML deleteGlobal(Class<?> aClass) {
        this.checksGlobalExistence(aClass);
        XmlClass xmlClass = this.findXmlClass(aClass);
        if (GeneralUtility.isEmpty(xmlClass.attributes)) {
            this.deleteClass(aClass);
        } else {
            xmlClass.global = null;
        }
        return this;
    }

    public XML addAttributes(Class<?> aClass, Attribute[] attributes) {
        this.checksAttributesExistence(aClass, attributes);
        for (Attribute attribute : attributes) {
            if (this.attributeExists(aClass, attribute)) {
                Error.xmlAttributeExistent(this.xmlPath, attribute, aClass);
            }
            this.findXmlClass(aClass).attributes.add(Converter.toXmlAttribute(attribute));
        }
        return this;
    }

    public XML deleteAttributes(Class<?> aClass, String[] attributes) {
        this.checksAttributesExistence(aClass, attributes);
        if (GeneralUtility.isEmpty(this.findXmlClass(aClass).attributes) || this.findXmlClass(aClass).attributes.size() <= 1) {
            Error.xmlWrongMethod(aClass);
        }
        for (String attributeName : attributes) {
            XmlAttribute attribute = null;
            for (XmlAttribute xmlAttribute : this.findXmlClass(aClass).attributes) {
                if (!xmlAttribute.name.equals(attributeName)) continue;
                attribute = xmlAttribute;
            }
            if (attribute == null) {
                Error.xmlAttributeInexistent(this.xmlPath, attributeName, aClass);
            }
            this.findXmlClass(aClass).attributes.remove(attribute);
        }
        return this;
    }

    private XML addClass(Class<?> aClass) {
        this.xmlJmapper.classes.add(Converter.toXmlClass(aClass));
        return this;
    }

    private XML checksGlobalExistence(Class<?> aClass) {
        if (!this.classExists(aClass)) {
            Error.xmlClassInexistent(this.xmlPath, aClass);
        }
        if (this.findXmlClass(aClass).global == null) {
            Error.xmlGlobalInexistent(aClass);
        }
        return this;
    }

    private XML checksGlobalAbsence(Class<?> aClass) {
        if (!this.classExists(aClass)) {
            Error.xmlClassInexistent(this.xmlPath, aClass);
        }
        if (this.findXmlClass(aClass).global != null) {
            Error.xmlGlobalExistent(aClass);
        }
        return this;
    }

    private XML checksAttributesExistence(Class<?> aClass, Attribute[] attributes) {
        String[] attributesNames = new String[attributes.length];
        int i = attributes.length;
        while (i-- > 0) {
            attributesNames[i] = attributes[i].getName();
        }
        this.checksAttributesExistence(aClass, attributesNames);
        return this;
    }

    private XML checksAttributesExistence(Class<?> aClass, String[] attributes) {
        if (!this.classExists(aClass)) {
            Error.xmlClassInexistent(this.xmlPath, aClass);
        }
        for (String attributeName : attributes) {
            try {
                aClass.getDeclaredField(attributeName);
            }
            catch (Exception e) {
                Error.attributeInexistent(attributeName, aClass);
            }
        }
        return this;
    }

    private XML checksClassAbsence(Class<?> aClass) {
        if (this.classExists(aClass)) {
            Error.xmlClassExistent(this.xmlPath, aClass);
        }
        return this;
    }

    private boolean classExists(Class<?> aClass) {
        if (this.xmlJmapper.classes == null) {
            return false;
        }
        return this.findXmlClass(aClass) != null;
    }

    private boolean attributeExists(Class<?> aClass, Attribute attribute) {
        if (!this.classExists(aClass)) {
            return false;
        }
        for (XmlAttribute xmlAttribute : this.findXmlClass(aClass).attributes) {
            if (!xmlAttribute.name.equals(attribute.getName())) continue;
            return true;
        }
        return false;
    }

    private XmlClass findXmlClass(Class<?> aClass) {
        for (XmlClass xmlClass : this.xmlJmapper.classes) {
            if (!xmlClass.name.equals(aClass.getName())) continue;
            return xmlClass;
        }
        return null;
    }

    public boolean isInheritedMapped(Class<?> classToCheck) {
        for (Class<?> clazz : ClassesManager.getAllsuperClasses(classToCheck)) {
            if (!this.isMapped(clazz)) continue;
            return true;
        }
        return false;
    }

    public boolean isMapped(Class<?> classToCheck) {
        return !GeneralUtility.isNull(this.loadGlobals().get(classToCheck.getName())) || !GeneralUtility.isEmpty((Collection)this.loadAttributes().get(classToCheck.getName()));
    }

    private Attribute getGlobalAttribute(MappedField configuredField, Class<?> configuredClass) {
        Class<?> clazz;
        Global global = null;
        Map<String, Global> globals = this.loadGlobals();
        SimplyAttribute[] simplyAttributeArray = ClassesManager.getAllsuperClasses(configuredClass).iterator();
        while (simplyAttributeArray.hasNext() && GeneralUtility.isNull(global = globals.get((clazz = simplyAttributeArray.next()).getName()))) {
        }
        if (!GeneralUtility.isNull(global) && !GeneralUtility.isNull(global.getAttributes())) {
            for (SimplyAttribute globalAttribute : global.getAttributes()) {
                String name = globalAttribute.getName();
                if (!configuredField.getValue().getName().equals(name)) continue;
                String get = globalAttribute.getGet();
                String set = globalAttribute.getSet();
                if (GeneralUtility.isNull(get) && GeneralUtility.isNull(set)) continue;
                return new Attribute(name, null, get, set, null, null);
            }
        }
        return null;
    }

    private Attribute getAttribute(MappedField configuredField, Class<?> configuredClass) {
        for (Class<?> clazz : ClassesManager.getAllsuperClasses(configuredClass)) {
            if (!this.isMapped(clazz)) continue;
            for (Attribute attribute : this.loadAttributes().get(clazz.getName())) {
                if (GeneralUtility.isNull(ClassesManager.fieldName(clazz, attribute.getName()))) {
                    Error.attributeAbsent(clazz, attribute);
                }
                if (!attribute.getName().equals(configuredField.getValue().getName())) continue;
                return attribute;
            }
        }
        return null;
    }

    public XML fillMappedField(Class<?> configuredClass, MappedField configuredField) {
        Attribute attribute = this.getGlobalAttribute(configuredField, configuredClass);
        if (GeneralUtility.isNull(attribute)) {
            attribute = this.getAttribute(configuredField, configuredClass);
        }
        if (!GeneralUtility.isNull(attribute)) {
            if (GeneralUtility.isEmpty(configuredField.getMethod())) {
                configuredField.getMethod(attribute.getGet());
            }
            if (GeneralUtility.isEmpty(configuredField.setMethod())) {
                configuredField.setMethod(attribute.getSet());
            }
        }
        return this;
    }

    public XML fillOppositeField(Class<?> configuredClass, MappedField configuredField, MappedField targetField) {
        Object value;
        Attribute attribute = null;
        Global global = this.loadGlobals().get(configuredClass.getName());
        if (!GeneralUtility.isNull(global) && !GeneralUtility.isEmpty((String)(value = global.getValue())) && ((String)value).equals(targetField.getValue().getName())) {
            String get = global.getGet();
            String set = global.getSet();
            if (!GeneralUtility.isNull(get) || !GeneralUtility.isNull(set)) {
                attribute = new Attribute(null, new Value(global.getValue(), get, set));
            }
        }
        if (GeneralUtility.isNull(attribute)) {
            attribute = this.getAttribute(configuredField, configuredClass);
        }
        if (!GeneralUtility.isNull(attribute)) {
            SimplyAttribute[] attributes;
            value = attribute.getValue();
            if (!GeneralUtility.isNull(value) && targetField.getValue().getName().equals(((Value)value).getName())) {
                if (GeneralUtility.isEmpty(targetField.getMethod())) {
                    targetField.getMethod(((Value)value).getGet());
                }
                if (GeneralUtility.isEmpty(targetField.setMethod())) {
                    targetField.setMethod(((Value)value).getSet());
                }
            }
            if (!GeneralUtility.isNull(attributes = attribute.getAttributes())) {
                for (SimplyAttribute targetAttribute : attributes) {
                    if (!targetField.getValue().getName().equals(targetAttribute.getName())) continue;
                    if (GeneralUtility.isEmpty(targetField.getMethod())) {
                        targetField.getMethod(targetAttribute.getGet());
                    }
                    if (!GeneralUtility.isEmpty(targetField.setMethod())) continue;
                    targetField.setMethod(targetAttribute.getSet());
                }
            }
        }
        return this;
    }
}

