/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jmapper.xml;

import com.googlecode.jmapper.annotations.Annotation;
import com.googlecode.jmapper.config.Error;
import com.googlecode.jmapper.config.JmapperLog;
import com.googlecode.jmapper.exceptions.LoadingFileException;
import com.googlecode.jmapper.util.FilesManager;
import com.googlecode.jmapper.util.GeneralUtility;
import com.googlecode.jmapper.xml.Attribute;
import com.googlecode.jmapper.xml.Converter;
import com.googlecode.jmapper.xml.Global;
import com.googlecode.jmapper.xml.XML;
import com.googlecode.jmapper.xml.XmlBuilder;
import com.googlecode.jmapper.xml.beans.XmlClass;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlHandler {
    private XML xml;

    public XmlHandler() {
        this.xml = new XML().setXmlPath("jmapper.xml");
    }

    public XmlHandler(String xmlPath) {
        try {
            this.xml = XmlBuilder.loadXml(xmlPath).atDevelopmentTime();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
    }

    public XmlHandler cleanAnnotatedClassAll(Class<?> ... classes) {
        return this.cleanAnnotatedClass(true, GeneralUtility.list(classes));
    }

    public XmlHandler cleanAnnotatedClass(Class<?> ... classes) {
        return this.cleanAnnotatedClass(false, GeneralUtility.list(classes));
    }

    public XmlHandler cleanAnnotatedClass() {
        try {
            return this.cleanAnnotatedClass(false, FilesManager.annotatedClasses());
        }
        catch (Exception e) {
            JmapperLog.error(e);
            return this;
        }
    }

    private XmlHandler cleanAnnotatedClass(boolean cleanAll, List<Class<?>> classes) {
        try {
            List<File> annotatedFiles = FilesManager.annotatedFiles();
            for (Class<?> clazz : classes) {
                String classPath = this.getClassPath(clazz);
                for (File file : annotatedFiles) {
                    if (!file.getPath().contains(classPath)) continue;
                    FilesManager.cleanClass(file, clazz, cleanAll);
                }
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler addAnnotatedClassAll(Class<?> ... classes) {
        try {
            this.addClasses(true, classes);
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler addAnnotatedClass(Class<?> ... classes) {
        try {
            this.addClasses(false, classes);
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler addAnnotatedClass() {
        try {
            List<Class<?>> annotatedClasses = FilesManager.annotatedClasses();
            this.addClasses(true, annotatedClasses.toArray(new Class[annotatedClasses.size()]));
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler overrideAnnotatedClassAll(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.overrideAnnotatedClass(clazz, true);
        }
        return this;
    }

    public XmlHandler overrideAnnotatedClass(Class<?> ... classes) {
        try {
            for (Class<?> clazz : classes) {
                this.overrideAnnotatedClass(clazz, false);
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler overrideAnnotatedClass() {
        try {
            for (Class<?> clazz : FilesManager.annotatedClasses()) {
                this.overrideAnnotatedClass(clazz, true);
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    private void overrideAnnotatedClass(Class<?> clazz, boolean overrideAll) {
        if (Annotation.isInheritedMapped(clazz) && this.xml.isInheritedMapped(clazz)) {
            XmlClass xmlClass = Converter.toXmlClass(clazz);
            Attribute[] attributes = null;
            Global global = null;
            if (!GeneralUtility.isEmpty(xmlClass.attributes)) {
                attributes = new Attribute[xmlClass.attributes.size()];
                int i = xmlClass.attributes.size();
                while (i-- > 0) {
                    attributes[i] = Converter.toAttribute(xmlClass.attributes.get(i));
                }
            }
            if (xmlClass.global != null) {
                global = Converter.toGlobal(xmlClass.global);
            }
            this.overrideClass(clazz, global, attributes);
        }
        if (overrideAll) {
            for (Class<?> it : clazz.getClasses()) {
                if (!it.isMemberClass() || !Annotation.isInheritedMapped(clazz) || !this.xml.isInheritedMapped(clazz)) continue;
                this.overrideAnnotatedClass(it, true);
            }
        }
    }

    public XmlHandler deleteAnnotatedClasses() {
        for (String className : this.xml.getClasses()) {
            try {
                this.deleteAnnotatedClass(Class.forName(className));
            }
            catch (ClassNotFoundException e) {
                try {
                    Error.xmlMappingClassDoesNotExist(className);
                }
                catch (Exception e2) {
                    JmapperLog.error(e2);
                }
            }
            catch (LoadingFileException e) {
                JmapperLog.error(e);
            }
            catch (IOException e) {
                JmapperLog.error(e);
            }
        }
        this.xml.write();
        return this;
    }

    private XmlHandler deleteAnnotatedClass(Class<?> aClass) throws LoadingFileException, IOException {
        String path = this.getElement(FilesManager.classesPath(), this.getClassPath(aClass));
        if (FilesManager.isFileAnnotated(path, aClass)) {
            this.deleteClasses(aClass);
        }
        for (Class<?> it : aClass.getClasses()) {
            if (!it.isMemberClass()) continue;
            this.deleteAnnotatedClass(it);
        }
        return this;
    }

    private String getElement(Collection<String> list, String element) {
        for (String file : list) {
            if (!file.contains(element)) continue;
            return file;
        }
        return null;
    }

    public XmlHandler fromXmlToAnnotationAll(Class<?> ... classes) {
        for (Class<?> classe : classes) {
            this.fromXmlToAnnotation(classe);
            for (Class<?> inner : classe.getClasses()) {
                if (!inner.isMemberClass()) continue;
                this.fromXmlToAnnotation(inner);
            }
        }
        return this;
    }

    public XmlHandler fromXmlToAnnotation(Class<?> ... classes) {
        try {
            Map<String, List<Attribute>> xmlAttributes = this.xml.loadAttributes();
            Map<String, Global> xmlGlobal = this.xml.loadGlobals();
            List<String> simplyClasses = FilesManager.classesPath();
            for (Class<?> classe : classes) {
                String path;
                if (!xmlAttributes.containsKey(classe.getName()) && !xmlGlobal.containsKey(classe.getName()) || FilesManager.isFileAnnotated(path = this.getElement(simplyClasses, this.getClassPath(classe)), classe)) continue;
                FilesManager.addConfigurationToClass(path, xmlGlobal.get(classe.getName()), xmlAttributes.get(classe.getName()), classe);
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler fromXmlToAnnotation() {
        try {
            for (String className : this.xml.loadAttributes().keySet()) {
                this.fromXmlToAnnotation(Class.forName(className));
            }
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    private String getClassPath(Class<?> clazz) {
        return this.getMainClass(clazz).getName().replace(".", GeneralUtility.fileSeparator) + ".java";
    }

    private Class<?> getMainClass(Class<?> clazz) {
        while (clazz.isMemberClass()) {
            clazz = clazz.getDeclaringClass();
        }
        return clazz;
    }

    public XmlHandler addGlobal(Class<?> aClass, Global global) {
        try {
            this.xml.addGlobal(aClass, global);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler deleteGlobal(Class<?> aClass) {
        try {
            this.xml.deleteGlobal(aClass);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler overrideGlobal(Class<?> aClass, Global global) {
        this.deleteGlobal(aClass);
        this.addGlobal(aClass, global);
        return this;
    }

    public XmlHandler addAttributes(Class<?> aClass, Attribute ... attributes) {
        try {
            this.xml.addAttributes(aClass, attributes);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler deleteAttributes(Class<?> aClass, String ... attributes) {
        try {
            this.xml.deleteAttributes(aClass, attributes);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    private XmlHandler addClasses(boolean addAll, Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (Annotation.isInheritedMapped(clazz)) {
                this.xml.addAnnotatedClass(clazz);
            }
            if (!addAll) continue;
            for (Class<?> it : clazz.getClasses()) {
                if (!it.isMemberClass()) continue;
                this.addClasses(true, it);
            }
        }
        this.xml.write();
        return this;
    }

    public XmlHandler addClass(Class<?> clazz, String ... attributes) {
        Attribute[] listAttributes = new Attribute[attributes.length];
        int i = attributes.length;
        while (i-- > 0) {
            listAttributes[i] = new Attribute(attributes[i]);
        }
        return this.addClass(clazz, listAttributes);
    }

    public XmlHandler addClass(Class<?> clazz, Global global, String ... attributes) {
        Attribute[] listAttributes = new Attribute[attributes.length];
        int i = attributes.length;
        while (i-- > 0) {
            listAttributes[i] = new Attribute(attributes[i]);
        }
        return this.addClass(clazz, global, listAttributes);
    }

    public XmlHandler addClass(Class<?> clazz, Attribute ... attributes) {
        try {
            this.xml.addClass(clazz, attributes);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler addClass(Class<?> clazz, Global global) {
        try {
            this.xml.addClass(clazz, global);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler addClass(Class<?> clazz, Global global, Attribute ... attributes) {
        try {
            this.xml.addClass(clazz, global, attributes);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    private XmlHandler deleteClasses(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            if (!this.xml.isInheritedMapped(clazz)) continue;
            this.xml.deleteClass(clazz);
        }
        return this;
    }

    public XmlHandler deleteClass(Class<?> ... classes) {
        try {
            for (Class<?> clazz : classes) {
                this.xml.deleteClass(clazz);
            }
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler overrideClass(Class<?> aClass, Attribute ... attributes) {
        try {
            this.xml.deleteClass(aClass);
            this.xml.addClass(aClass, attributes);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XmlHandler overrideClass(Class<?> aClass, Global global) {
        this.overrideGlobal(aClass, global);
        return this;
    }

    public XmlHandler overrideClass(Class<?> aClass, Global global, Attribute ... attributes) {
        try {
            this.xml.deleteClass(aClass);
            this.xml.addClass(aClass, global, attributes);
            this.xml.write();
        }
        catch (Exception e) {
            JmapperLog.error(e);
        }
        return this;
    }

    public XML getXML() {
        return this.xml;
    }
}

