/*
 * Decompiled with CFR 0.152.
 */
package no.uib.cipr.matrix;

import com.github.fommil.netlib.BLAS;
import com.github.fommil.netlib.LAPACK;
import no.uib.cipr.matrix.AbstractBandMatrix;
import no.uib.cipr.matrix.DenseMatrix;
import no.uib.cipr.matrix.DenseVector;
import no.uib.cipr.matrix.Diag;
import no.uib.cipr.matrix.Matrices;
import no.uib.cipr.matrix.Matrix;
import no.uib.cipr.matrix.MatrixSingularException;
import no.uib.cipr.matrix.Transpose;
import no.uib.cipr.matrix.UpLo;
import no.uib.cipr.matrix.Vector;
import org.netlib.util.intW;

abstract class AbstractTriangBandMatrix
extends AbstractBandMatrix {
    private UpLo uplo;
    private Diag diag;
    int kd;

    AbstractTriangBandMatrix(int n, int kl, int ku, UpLo uplo, Diag diag) {
        super(n, kl, ku);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    AbstractTriangBandMatrix(Matrix A, int kl, int ku, UpLo uplo, Diag diag) {
        this(A, kl, ku, true, uplo, diag);
    }

    AbstractTriangBandMatrix(Matrix A, int kl, int ku, boolean deep, UpLo uplo, Diag diag) {
        super(A, kl, ku, deep);
        this.kd = Math.max(kl, ku);
        this.uplo = uplo;
        this.diag = diag;
    }

    @Override
    public Vector mult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.mult(alpha, x, y);
        }
        this.checkMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        BLAS.getInstance().dtbmv(this.uplo.netlib(), Transpose.NoTranspose.netlib(), this.diag.netlib(), this.numRows, this.kd, this.data, this.kd + 1, yd, 1);
        return y;
    }

    @Override
    public Vector transMult(double alpha, Vector x, Vector y) {
        if (!(y instanceof DenseVector)) {
            return super.transMult(alpha, x, y);
        }
        this.checkTransMultAdd(x, y);
        double[] yd = ((DenseVector)y).getData();
        y.set(alpha, x);
        BLAS.getInstance().dtbmv(this.uplo.netlib(), Transpose.Transpose.netlib(), this.diag.netlib(), this.numRows, this.kd, this.data, this.kd + 1, yd, 1);
        return y;
    }

    @Override
    public Matrix solve(Matrix B, Matrix X) {
        return this.solve(B, X, Transpose.NoTranspose);
    }

    @Override
    public Vector solve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.solve(B, X);
        return x;
    }

    @Override
    public Matrix transSolve(Matrix B, Matrix X) {
        return this.solve(B, X, Transpose.Transpose);
    }

    @Override
    public Vector transSolve(Vector b, Vector x) {
        DenseMatrix B = new DenseMatrix(b, false);
        DenseMatrix X = new DenseMatrix(x, false);
        this.transSolve(B, X);
        return x;
    }

    Matrix solve(Matrix B, Matrix X, Transpose trans) {
        if (!(X instanceof DenseMatrix)) {
            throw new UnsupportedOperationException("X must be a DenseMatrix");
        }
        this.checkSolve(B, X);
        double[] Xd = ((DenseMatrix)X).getData();
        X.set(B);
        intW info = new intW(0);
        LAPACK.getInstance().dtbtrs(this.uplo.netlib(), trans.netlib(), this.diag.netlib(), this.numRows, this.kd, X.numColumns(), this.data, Matrices.ld(this.kd + 1), Xd, Matrices.ld(this.n), info);
        if (info.val > 0) {
            throw new MatrixSingularException();
        }
        if (info.val < 0) {
            throw new IllegalArgumentException();
        }
        return X;
    }
}

