/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.form.slider;

import com.googlecode.wicket.jquery.core.JQueryAbstractBehavior;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.ui.form.slider.AbstractSlider;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.AbstractTextComponent;
import org.apache.wicket.markup.html.form.HiddenField;
import org.apache.wicket.markup.html.form.TextField;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.model.IModel;
import org.apache.wicket.validation.IValidator;
import org.apache.wicket.validation.validator.RangeValidator;

public class Slider
extends AbstractSlider<Integer> {
    private static final long serialVersionUID = 1L;
    private IValidator<Integer> rangeValidator = null;
    protected AbstractTextComponent<Integer> input = null;

    public Slider(String id) {
        super(id);
        this.initialize();
    }

    public Slider(String id, IModel<Integer> model) {
        super(id, model);
        this.initialize();
    }

    public Slider(String id, IModel<Integer> model, Label label) {
        super(id, model, label);
        this.initialize();
    }

    public Slider(String id, IModel<Integer> model, TextField<Integer> input) {
        super(id, model);
        this.input = input;
        this.input.setRequired(true);
        this.input.setOutputMarkupId(true);
        this.input.add(new Behavior[]{this.newInputBehavior()});
        this.initialize();
    }

    @Override
    public void convertInput() {
        this.setConvertedInput(this.input.getConvertedInput());
    }

    public Slider setRangeValidator(RangeValidator<Integer> validator) {
        this.rangeValidator = validator;
        return this;
    }

    protected String getLabelPattern() {
        return "ui.value";
    }

    @Override
    protected void onInitialize() {
        super.onInitialize();
        if (this.rangeValidator != null) {
            this.input.add(this.rangeValidator);
        }
    }

    @Override
    public void onConfigure(JQueryBehavior behavior) {
        super.onConfigure(behavior);
        StringBuilder statements = new StringBuilder();
        statements.append("jQuery('#").append(this.input.getMarkupId()).append("').val(ui.value); ");
        if (this.labelId != null) {
            statements.append("jQuery('#").append(this.labelId).append("').text(").append(this.getLabelPattern()).append("); ");
        }
        behavior.setOption("slide", (Object)String.format("function(event, ui) { %s }", statements));
        behavior.setOption("value", this.getModelObject());
    }

    public Slider setRange(Range range) {
        this.options.set("range", (Object)range);
        return this;
    }

    @Override
    protected Fragment newInputFragment(String id) {
        Fragment fragment;
        if (this.input == null) {
            this.input = new HiddenField("input", this.getModel(), Integer.class);
            fragment = new Fragment(id, "input-fragment", (MarkupContainer)this);
            fragment.add(new Component[]{this.input.setOutputMarkupPlaceholderTag(true)});
        } else {
            fragment = super.newInputFragment(id);
        }
        return fragment;
    }

    private JQueryAbstractBehavior newInputBehavior() {
        return new JQueryAbstractBehavior(){
            private static final long serialVersionUID = 1L;

            protected String $() {
                StringBuilder statements = new StringBuilder();
                statements.append("jQuery('#").append(Slider.this.input.getMarkupId()).append("').on('change', function() { ");
                statements.append("\t\tjQuery('#").append(Slider.this.label.getMarkupId()).append("').slider('value', jQuery(this).val()); ");
                statements.append("});");
                return statements.toString();
            }
        };
    }

    public static enum Range {
        MIN("'min'"),
        MAX("'max'");

        private String range;

        private Range(String range) {
            this.range = range;
        }

        public String toString() {
            return this.range;
        }
    }
}

