/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.interaction.sortable;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryBehavior;
import com.googlecode.wicket.jquery.core.JQueryGenericContainer;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.utils.ListUtils;
import com.googlecode.wicket.jquery.core.utils.RequestCycleUtils;
import com.googlecode.wicket.jquery.ui.interaction.sortable.ISortableListener;
import com.googlecode.wicket.jquery.ui.interaction.sortable.SortableBehavior;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.event.Broadcast;
import org.apache.wicket.event.IEvent;
import org.apache.wicket.event.IEventSink;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.util.lang.Args;

public abstract class Sortable<T>
extends JQueryGenericContainer<List<T>>
implements ISortableListener<T> {
    private static final long serialVersionUID = 1L;
    protected final Options options;
    private Sortable<T> connectedSortable = null;

    public Sortable(String id, List<T> list) {
        this(id, Model.ofList(list), new Options());
    }

    public Sortable(String id, List<T> list, Options options) {
        this(id, Model.ofList(list), options);
    }

    public Sortable(String id, IModel<List<T>> model) {
        this(id, model, new Options());
    }

    public Sortable(String id, IModel<List<T>> model, Options options) {
        super(id, model);
        this.options = (Options)Args.notNull((Object)options, (String)"options");
    }

    protected void onInitialize() {
        super.onInitialize();
        this.add(new Component[]{this.newListView(this.getModel())});
    }

    public void onEvent(IEvent<?> event) {
        AjaxRequestTarget target;
        if (event.getSource() instanceof Sortable && (target = RequestCycleUtils.getAjaxRequestTarget()) != null) {
            Object item = event.getPayload();
            this.onRemove(target, item);
        }
    }

    @Override
    public void onUpdate(AjaxRequestTarget target, T item, int index) {
        this.modelChanging();
        ListUtils.move(item, (int)index, (List)((List)this.getModelObject()));
        this.modelChanged();
    }

    @Override
    public void onReceive(AjaxRequestTarget target, T item, int index) {
        this.modelChanging();
        ((List)this.getModelObject()).add(index, item);
        this.modelChanged();
        this.send((IEventSink)this.connectedSortable, Broadcast.EXACT, item);
    }

    @Override
    public void onRemove(AjaxRequestTarget target, T item) {
        this.modelChanging();
        ((List)this.getModelObject()).remove(item);
        this.modelChanged();
    }

    @Override
    public boolean isOnReceiveEnabled() {
        return this.connectedSortable != null;
    }

    @Override
    public boolean isOnRemoveEnabled() {
        return false;
    }

    public Sortable<T> connectWith(Sortable<T> sortable) {
        Args.notNull(sortable, (String)"sortable");
        super.connect(this);
        return this.connectWith(IJQueryWidget.JQueryWidget.getSelector(sortable));
    }

    private Sortable<T> connectWith(String selector) {
        this.options.set("connectWith", (Object)Options.asString((String)selector));
        return this;
    }

    private void connect(Sortable<T> sortable) {
        this.connectedSortable = sortable;
    }

    protected T findItem(String id, List<T> list) {
        return (T)ListUtils.fromHash((int)Integer.parseInt(id), list);
    }

    public JQueryBehavior newWidgetBehavior(String selector) {
        return new SortableBehavior<T>(selector, this.options, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<T> getItemList() {
                return (List)Sortable.this.getModelObject();
            }

            @Override
            protected List<T> getConnectedList() {
                if (Sortable.this.connectedSortable != null) {
                    return (List)Sortable.this.connectedSortable.getModelObject();
                }
                return Collections.emptyList();
            }

            @Override
            protected T findItem(String id, List<T> list) {
                return Sortable.this.findItem(id, list);
            }
        };
    }

    protected abstract HashListView<T> newListView(IModel<List<T>> var1);

    public static abstract class HashListView<T>
    extends ListView<T> {
        private static final long serialVersionUID = 1L;

        public HashListView(String id) {
            super(id);
        }

        public HashListView(String id, List<T> list) {
            super(id, list);
        }

        public HashListView(String id, IModel<? extends List<T>> model) {
            super(id, model);
        }

        protected void onBeginPopulateItem(ListItem<T> item) {
            super.onBeginPopulateItem(item);
            item.add(new Behavior[]{AttributeModifier.replace((String)"data-hash", (Serializable)Integer.valueOf(item.getModelObject().hashCode()))});
        }
    }
}

