/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.dialog;

import com.googlecode.wicket.jquery.core.JQueryEvent;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.core.ajax.IJQueryAjaxAware;
import com.googlecode.wicket.jquery.core.ajax.JQueryAjaxBehavior;
import com.googlecode.wicket.jquery.ui.JQueryUIBehavior;
import com.googlecode.wicket.jquery.ui.widget.dialog.ButtonAjaxBehavior;
import com.googlecode.wicket.jquery.ui.widget.dialog.DialogButton;
import com.googlecode.wicket.jquery.ui.widget.dialog.IDialogListener;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.json.JSONObject;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.util.lang.Args;

public abstract class DialogBehavior
extends JQueryUIBehavior
implements IJQueryAjaxAware {
    private static final long serialVersionUID = 1L;
    public static final String METHOD = "dialog";
    private final IDialogListener listener;
    private JQueryAjaxBehavior onDefaultCloseAjaxBehavior = null;
    private JQueryAjaxBehavior onEscapeCloseAjaxBehavior = null;

    public DialogBehavior(String selector, IDialogListener listener) {
        this(selector, new Options(), listener);
    }

    public DialogBehavior(String selector, Options options, IDialogListener listener) {
        super(selector, METHOD, options);
        this.listener = (IDialogListener)Args.notNull((Object)listener, (String)"listener");
    }

    protected abstract List<DialogButton> getButtons();

    public void bind(Component component) {
        super.bind(component);
        for (DialogButton button : this.getButtons()) {
            component.add(new Behavior[]{this.newButtonAjaxBehavior(this, button)});
        }
        if (this.listener.isDefaultCloseEventEnabled()) {
            this.onDefaultCloseAjaxBehavior = this.newOnDefaultCloseAjaxBehavior(this);
            component.add(new Behavior[]{this.onDefaultCloseAjaxBehavior});
        }
        if (this.listener.isEscapeCloseEventEnabled()) {
            this.onEscapeCloseAjaxBehavior = this.newOnEscapeCloseAjaxBehavior(this);
            component.add(new Behavior[]{this.onEscapeCloseAjaxBehavior});
        }
    }

    public void open(IPartialPageRequestHandler handler) {
        handler.appendJavaScript((CharSequence)this.$(Options.asString((String)"open")));
    }

    public void close(IPartialPageRequestHandler handler) {
        handler.prependJavaScript((CharSequence)this.$(Options.asString((String)"close")));
    }

    @Override
    public void onConfigure(Component component) {
        if (this.onDefaultCloseAjaxBehavior != null) {
            this.setOption("close", this.onDefaultCloseAjaxBehavior.getCallbackFunction());
        }
        if (this.onEscapeCloseAjaxBehavior != null) {
            this.setOption("beforeClose", this.onEscapeCloseAjaxBehavior.getCallbackFunction());
        }
        StringBuilder buttons = new StringBuilder("[ ");
        int index = 0;
        for (ButtonAjaxBehavior behavior : component.getBehaviors(ButtonAjaxBehavior.class)) {
            DialogButton button = behavior.getButton();
            if (index++ > 0) {
                buttons.append(", ");
            }
            buttons.append("{");
            buttons.append("'id': '").append(button.getMarkupId()).append("', ");
            buttons.append("'text': ").append(JSONObject.quote((String)button.toString())).append(", ");
            if (!button.isEnabled()) {
                buttons.append("'disabled': true, ");
            }
            if (button.getIcon() != null) {
                buttons.append("icons: { primary: '").append(button.getIcon()).append("' }, ");
            }
            buttons.append("'click': function() { ").append(button.getCallbackScript(behavior)).append(" }");
            buttons.append("}");
        }
        buttons.append(" ]");
        this.setOption("buttons", buttons);
        super.onConfigure(component);
    }

    public void onAjax(AjaxRequestTarget target, JQueryEvent event) {
        if (event instanceof ButtonAjaxBehavior.ClickEvent) {
            this.listener.onClick(target, ((ButtonAjaxBehavior.ClickEvent)event).getButton());
        } else if (event instanceof CloseEvent) {
            this.listener.onClose((IPartialPageRequestHandler)target, null);
        }
    }

    protected abstract ButtonAjaxBehavior newButtonAjaxBehavior(IJQueryAjaxAware var1, DialogButton var2);

    protected JQueryAjaxBehavior newOnDefaultCloseAjaxBehavior(IJQueryAjaxAware source) {
        return new OnDefaultCloseAjaxBehavior(source);
    }

    protected JQueryAjaxBehavior newOnEscapeCloseAjaxBehavior(IJQueryAjaxAware source) {
        return new OnEscapeCloseAjaxBehavior(source);
    }

    protected static class CloseEvent
    extends JQueryEvent {
        protected CloseEvent() {
        }
    }

    protected static class OnEscapeCloseAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnEscapeCloseAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        public String getCallbackFunction() {
            return "function(event, ui) { if (event.keyCode == $.ui.keyCode.ESCAPE) { " + this.getCallbackScript() + " } }";
        }

        protected JQueryEvent newEvent() {
            return new CloseEvent();
        }
    }

    protected static class OnDefaultCloseAjaxBehavior
    extends JQueryAjaxBehavior {
        private static final long serialVersionUID = 1L;

        public OnDefaultCloseAjaxBehavior(IJQueryAjaxAware source) {
            super(source);
        }

        public String getCallbackFunction() {
            return "function(event, ui) { if (event.button == 0) { " + this.getCallbackScript() + " } }";
        }

        protected JQueryEvent newEvent() {
            return new CloseEvent();
        }
    }
}

