/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.wicket.jquery.ui.widget.tabs;

import com.googlecode.wicket.jquery.core.IJQueryWidget;
import com.googlecode.wicket.jquery.core.JQueryGenericPanel;
import com.googlecode.wicket.jquery.core.Options;
import com.googlecode.wicket.jquery.ui.widget.tabs.ITabsListener;
import com.googlecode.wicket.jquery.ui.widget.tabs.TabListModel;
import com.googlecode.wicket.jquery.ui.widget.tabs.TabsBehavior;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.core.request.handler.IPartialPageRequestHandler;
import org.apache.wicket.extensions.markup.html.tabs.ITab;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.list.ListItem;
import org.apache.wicket.markup.html.list.ListView;
import org.apache.wicket.markup.html.panel.Fragment;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;

public class TabbedPanel
extends JQueryGenericPanel<List<ITab>>
implements ITabsListener {
    private static final long serialVersionUID = 1L;
    private TabsBehavior widgetBehavior;

    public TabbedPanel(String id, List<ITab> tabs) {
        this(id, (IModel<List<ITab>>)Model.ofList(tabs), new Options());
    }

    public TabbedPanel(String id, List<ITab> tabs, Options options) {
        this(id, (IModel<List<ITab>>)Model.ofList(tabs), options);
    }

    public TabbedPanel(String id, IModel<List<ITab>> model) {
        this(id, model, new Options());
    }

    public TabbedPanel(String id, IModel<List<ITab>> model, Options options) {
        super(id, model, options);
    }

    public List<ITab> getModelObject() {
        List list = (List)super.getModelObject();
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public TabbedPanel setActiveTab(int index) {
        this.options.set("active", (Object)index);
        return this;
    }

    public void setActiveTab(int index, IPartialPageRequestHandler handler) {
        this.widgetBehavior.activate(index, handler);
    }

    public void enable(IPartialPageRequestHandler handler) {
        this.widgetBehavior.enable(handler);
    }

    public void enable(int index, IPartialPageRequestHandler handler) {
        this.widgetBehavior.enable(index, handler);
    }

    public void disable(IPartialPageRequestHandler handler) {
        this.widgetBehavior.disable(handler);
    }

    public void disable(int index, IPartialPageRequestHandler handler) {
        this.widgetBehavior.disable(index, handler);
    }

    public int getLastTabIndex() {
        int index = -1;
        Iterator iterator = this.getModelObject().iterator();
        while (iterator.hasNext()) {
            ITab tab = (ITab)iterator.next();
            if (!tab.isVisible()) continue;
            ++index;
        }
        return index;
    }

    @Override
    public boolean isCreateEventEnabled() {
        return true;
    }

    @Override
    public boolean isActivateEventEnabled() {
        return true;
    }

    @Override
    public boolean isActivatingEventEnabled() {
        return false;
    }

    public boolean add(ITab tab) {
        return this.getModelObject().add(tab);
    }

    public void reload(IPartialPageRequestHandler handler) {
        IModel model = this.getModel();
        if (model instanceof TabListModel) {
            ((TabListModel)model).flush();
        }
        handler.add(new Component[]{this});
    }

    protected void onInitialize() {
        super.onInitialize();
        final RepeatingView panels = new RepeatingView("panels"){
            private static final long serialVersionUID = 1L;

            public String newChildId() {
                return String.format("tab-%s-%s", this.getMarkupId(), super.newChildId());
            }

            protected void onConfigure() {
                super.onConfigure();
                this.removeAll();
            }
        };
        this.add(new Component[]{panels});
        this.add(new Component[]{new ListView<ITab>("tabs", this.getModel()){
            private static final long serialVersionUID = 1L;

            protected ListItem<ITab> newItem(int index, IModel<ITab> model) {
                ListItem item = super.newItem(index, model);
                item.setVisible(((ITab)model.getObject()).isVisible());
                return item;
            }

            protected void populateItem(ListItem<ITab> item) {
                ITab tab = (ITab)item.getModelObject();
                if (tab.isVisible()) {
                    String newId = panels.newChildId();
                    item.add(new Component[]{TabbedPanel.this.newTabContainer("tab", newId, tab, item.getIndex())});
                    panels.add(new Component[]{tab.getPanel(newId).setMarkupId(newId).setOutputMarkupId(true)});
                }
            }
        }});
        this.widgetBehavior = (TabsBehavior)IJQueryWidget.JQueryWidget.newWidgetBehavior((Component)this);
        this.add(new Behavior[]{this.widgetBehavior});
    }

    @Override
    public void onActivate(AjaxRequestTarget target, int index, ITab tab) {
    }

    @Override
    public void onActivating(AjaxRequestTarget target, int index, ITab tab) {
    }

    protected Component newTitleLabel(String id, IModel<String> title) {
        return new Label(id, title);
    }

    protected WebMarkupContainer newTabContainer(String id, String tabId, ITab tab, int index) {
        Fragment container = new Fragment(id, "tab-fragment", (MarkupContainer)this);
        Component link = this.newTitleLabel("link", (IModel<String>)tab.getTitle());
        link.add(new Behavior[]{AttributeModifier.replace((String)"href", (Serializable)((Object)("#" + tabId)))});
        container.add(new Component[]{link});
        return container;
    }

    public TabsBehavior newWidgetBehavior(String selector) {
        return new TabsBehavior(selector, this.options, this){
            private static final long serialVersionUID = 1L;

            @Override
            protected List<ITab> getTabs() {
                return TabbedPanel.this.getModelObject();
            }
        };
    }
}

