/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.util;

import com.google.code.yanf4j.util.LinkedTransferQueue;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.channels.Selector;
import java.nio.channels.spi.SelectorProvider;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SystemUtils {
    public static final String OS_NAME = System.getProperty("os.name");
    private static boolean isLinuxPlatform = false;
    public static final String JAVA_VERSION;
    private static boolean isAfterJava6u4Version;

    private SystemUtils() {
    }

    public static final boolean isLinuxPlatform() {
        return isLinuxPlatform;
    }

    public static final boolean isAfterJava6u4Version() {
        return isAfterJava6u4Version;
    }

    public static void main(String[] args) {
        System.out.println(SystemUtils.isAfterJava6u4Version());
    }

    public static final int getSystemThreadCount() {
        int cpus = SystemUtils.getCpuProcessorCount();
        if (cpus <= 8) {
            return cpus;
        }
        return 8 + (cpus - 8) * 5 / 8;
    }

    public static final int getCpuProcessorCount() {
        return Runtime.getRuntime().availableProcessors();
    }

    public static final Selector openSelector() throws IOException {
        Selector result;
        block7: {
            result = null;
            if (SystemUtils.isLinuxPlatform()) {
                try {
                    Class<?> providerClazz = Class.forName("sun.nio.ch.EPollSelectorProvider");
                    if (providerClazz == null) break block7;
                    try {
                        SelectorProvider selectorProvider;
                        Method method = providerClazz.getMethod("provider", new Class[0]);
                        if (method != null && (selectorProvider = (SelectorProvider)method.invoke(null, new Object[0])) != null) {
                            result = selectorProvider.openSelector();
                        }
                    }
                    catch (Exception exception) {}
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (result == null) {
            result = Selector.open();
        }
        return result;
    }

    public static final String getRawAddress(InetSocketAddress inetSocketAddress) {
        InetAddress address = inetSocketAddress.getAddress();
        return address != null ? address.getHostAddress() : inetSocketAddress.getHostName();
    }

    public static final Queue<?> createTransferQueue() {
        try {
            return (Queue)Class.forName("java.util.concurrent.LinkedTransferQueue").newInstance();
        }
        catch (Exception e) {
            return new LinkedTransferQueue();
        }
    }

    static {
        if (OS_NAME != null && OS_NAME.toLowerCase().indexOf("linux") >= 0) {
            isLinuxPlatform = true;
        }
        JAVA_VERSION = System.getProperty("java.version");
        isAfterJava6u4Version = false;
        if (JAVA_VERSION != null) {
            if (JAVA_VERSION.indexOf("1.4.") >= 0 || JAVA_VERSION.indexOf("1.5.") >= 0) {
                isAfterJava6u4Version = false;
            } else if (JAVA_VERSION.indexOf("1.6.") >= 0) {
                String subVersionStr;
                int index = JAVA_VERSION.indexOf("_");
                if (index > 0 && (subVersionStr = JAVA_VERSION.substring(index + 1)) != null && subVersionStr.length() > 0) {
                    try {
                        int subVersion = Integer.parseInt(subVersionStr);
                        if (subVersion >= 4) {
                            isAfterJava6u4Version = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                isAfterJava6u4Version = true;
            }
        }
    }
}

