/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.aws;

import com.google.code.yanf4j.core.Session;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeoutException;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.XMemcachedClient;
import net.rubyeye.xmemcached.aws.AWSUtils;
import net.rubyeye.xmemcached.aws.CacheNode;
import net.rubyeye.xmemcached.aws.ClusterConfigration;
import net.rubyeye.xmemcached.aws.ConfigUpdateListener;
import net.rubyeye.xmemcached.aws.ConfigurationPoller;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.TextCommandFactory;
import net.rubyeye.xmemcached.exception.MemcachedException;
import net.rubyeye.xmemcached.utils.InetSocketAddressWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AWSElasticCacheClient
extends XMemcachedClient
implements ConfigUpdateListener {
    private static final Logger log = LoggerFactory.getLogger(AWSElasticCacheClient.class);
    private boolean firstTimeUpdate = true;
    private List<InetSocketAddress> configAddrs = new ArrayList<InetSocketAddress>();
    private final ConfigurationPoller configPoller;
    public static final long DEFAULT_POLL_CONFIG_INTERVAL_MS = 60000L;
    private volatile ClusterConfigration currentClusterConfiguration;

    @Override
    public synchronized void onUpdate(ClusterConfigration config) {
        if (this.firstTimeUpdate) {
            this.firstTimeUpdate = false;
            this.removeConfigAddrs();
        }
        List<CacheNode> oldList = this.currentClusterConfiguration != null ? this.currentClusterConfiguration.getNodeList() : Collections.EMPTY_LIST;
        List<CacheNode> newList = config.getNodeList();
        ArrayList<CacheNode> addNodes = new ArrayList<CacheNode>();
        ArrayList<CacheNode> removeNodes = new ArrayList<CacheNode>();
        for (CacheNode node : newList) {
            if (oldList.contains(node)) continue;
            addNodes.add(node);
        }
        for (CacheNode node : oldList) {
            if (newList.contains(node)) continue;
            removeNodes.add(node);
        }
        for (CacheNode node : addNodes) {
            try {
                this.connect(new InetSocketAddressWrapper(node.getInetSocketAddress(), this.configPoller.getCacheNodeOrder(node), 1, null));
            }
            catch (IOException e) {
                log.error("Connect to " + node + "failed.", (Throwable)e);
            }
        }
        for (CacheNode node : removeNodes) {
            try {
                this.removeAddr(node.getInetSocketAddress());
            }
            catch (Exception e) {
                log.error("Remove " + node + " failed.");
            }
        }
        this.currentClusterConfiguration = config;
    }

    private void removeConfigAddrs() {
        for (InetSocketAddress configAddr : this.configAddrs) {
            this.removeAddr(configAddr);
            while (this.getConnector().getSessionByAddress(configAddr) != null && this.getConnector().getSessionByAddress(configAddr).size() > 0) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    public AWSElasticCacheClient(InetSocketAddress addr) throws IOException {
        this(addr, 60000L);
    }

    public AWSElasticCacheClient(InetSocketAddress addr, long pollConfigIntervalMills) throws IOException {
        this(addr, pollConfigIntervalMills, (CommandFactory)new TextCommandFactory());
    }

    public AWSElasticCacheClient(InetSocketAddress addr, long pollConfigIntervalMills, CommandFactory cmdFactory) throws IOException {
        this(AWSElasticCacheClient.asList(addr), pollConfigIntervalMills, cmdFactory);
    }

    private static List<InetSocketAddress> asList(InetSocketAddress addr) {
        ArrayList<InetSocketAddress> addrs = new ArrayList<InetSocketAddress>();
        addrs.add(addr);
        return addrs;
    }

    public AWSElasticCacheClient(List<InetSocketAddress> addrs) throws IOException {
        this(addrs, 60000L);
    }

    public AWSElasticCacheClient(List<InetSocketAddress> addrs, long pollConfigIntervalMills) throws IOException {
        this(addrs, pollConfigIntervalMills, (CommandFactory)new TextCommandFactory());
    }

    public AWSElasticCacheClient(List<InetSocketAddress> addrs, long pollConfigIntervalMills, CommandFactory commandFactory) throws IOException {
        super(addrs, commandFactory);
        if (pollConfigIntervalMills <= 0L) {
            throw new IllegalArgumentException("Invalid pollConfigIntervalMills value.");
        }
        this.commandFactory = commandFactory;
        this.setFailureMode(true);
        this.configAddrs = addrs;
        this.configPoller = new ConfigurationPoller(this, pollConfigIntervalMills);
        this.configPoller.run();
        if (this.currentClusterConfiguration == null) {
            throw new IllegalStateException("Retrieve ElasticCache config from `" + addrs.toString() + "` failed.");
        }
        this.configPoller.start();
    }

    public ClusterConfigration getConfig() throws MemcachedException, InterruptedException, TimeoutException {
        return this.getConfig("cluster");
    }

    public ClusterConfigration getConfig(String key) throws MemcachedException, InterruptedException, TimeoutException {
        Command cmd = this.commandFactory.createAWSElasticCacheConfigCommand("get", key);
        Session session = this.sendCommand(cmd);
        this.latchWait(cmd, this.opTimeout, session);
        cmd.getIoBuffer().free();
        this.checkException(cmd);
        String result = (String)cmd.getResult();
        if (result == null) {
            throw new MemcachedException("Operation fail,may be caused by networking or timeout");
        }
        return AWSUtils.parseConfiguration(result);
    }

    public ClusterConfigration getCurrentConfig() {
        return this.currentClusterConfiguration;
    }
}

