/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.kestrel;

import java.nio.ByteBuffer;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.text.TextFlushAllCommand;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class KestrelFlushAllCommand
extends TextFlushAllCommand {
    public KestrelFlushAllCommand(CountDownLatch latch, int delay, boolean noreply) {
        super(latch, delay, noreply);
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        if (buffer == null || !buffer.hasRemaining()) {
            return false;
        }
        String line = ByteUtils.nextLine(buffer);
        if (line == null) {
            return false;
        }
        if (line.startsWith("Flushed")) {
            this.setResult(Boolean.TRUE);
            this.countDownLatch();
            return true;
        }
        return this.decodeError(session, buffer);
    }
}

