/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.rubyeye.xmemcached.utils.ByteUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CachedString {
    private static ConcurrentHashMap<String, Reference<byte[]>> table = new ConcurrentHashMap();
    static final ReferenceQueue rq = new ReferenceQueue();

    public static byte[] getBytes(String s) {
        if (s == null || s.length() == 0) {
            return null;
        }
        byte[] bs = null;
        Reference existingRef = table.get(s);
        if (existingRef == null) {
            CachedString.clearCache(rq, table);
            bs = s.getBytes(ByteUtils.DEFAULT_CHARSET);
            existingRef = table.putIfAbsent(s, new WeakReference<byte[]>(bs, rq));
        }
        if (existingRef == null) {
            return bs;
        }
        byte[] existingbs = existingRef.get();
        if (existingbs != null) {
            return existingbs;
        }
        table.remove(s, existingRef);
        return CachedString.getBytes(s);
    }

    public static <K, V> void clearCache(ReferenceQueue rq, ConcurrentHashMap<K, Reference<V>> cache) {
        if (rq.poll() != null) {
            while (rq.poll() != null) {
            }
            for (Map.Entry<K, Reference<V>> e : cache.entrySet()) {
                Reference<V> val = e.getValue();
                if (val == null || val.get() != null) continue;
                cache.remove(e.getKey(), val);
            }
        }
    }

    private static long testString(int keyLen) {
        String k = CachedString.getKey(keyLen);
        long len = 0L;
        for (int i = 0; i < 1000; ++i) {
            byte[] bs = CachedString.getBytes(k);
            String nk = ByteUtils.getString(bs);
            if (!k.equals(nk)) {
                throw new RuntimeException();
            }
            len += (long)nk.length();
        }
        return len;
    }

    private static String getKey(int len) {
        StringBuilder sb = new StringBuilder();
        String[] chars = new String[]{"a", "b", "c", "d", "e", "f", "g", "h"};
        int index = (int)Math.floor(Math.random() * 8.0);
        for (int i = 0; i < len; ++i) {
            sb.append(chars[index]);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        int[] keys;
        long sum = 0L;
        for (int i = 0; i < 10000; ++i) {
            sum += CachedString.testString(8);
        }
        for (int k : keys = new int[]{8, 64, 128}) {
            long start = System.currentTimeMillis();
            for (int i = 0; i < 100000; ++i) {
                sum += CachedString.testString(k);
            }
            System.out.println("Key length=" + k + ", cost " + (System.currentTimeMillis() - start) + " ms.");
        }
        System.out.println(sum);
        System.out.println(table.size());
    }
}

