/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.rubyeye.xmemcached.command.text.TextStatsCommand;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextStatsCachedumpCommand
extends TextStatsCommand {
    static Pattern itemPattern = Pattern.compile("ITEM (?<key>[^ ]+) \\[(?<size>\\d+) b; (?<expire>\\d+) s\\]");

    public TextStatsCachedumpCommand(InetSocketAddress server, CountDownLatch latch, int slabId, int limit) {
        super(server, latch, String.format("cachedump %s %s", slabId, limit));
        this.result = new HashMap();
    }

    public final boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        String line = null;
        while ((line = ByteUtils.nextLine(buffer)) != null) {
            if (line.equals("END")) {
                return super.done(session);
            }
            if (line.startsWith("ITEM")) {
                Matcher m = itemPattern.matcher(line);
                if (!m.find()) continue;
                ((Map)this.getResult()).put(m.group("key"), new Integer[]{Integer.parseInt(m.group("size")), Integer.parseInt(m.group("expire"))});
                continue;
            }
            return this.decodeError(line);
        }
        return false;
    }
}

