/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.Session;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import net.rubyeye.xmemcached.HashAlgorithm;
import net.rubyeye.xmemcached.impl.AbstractMemcachedSessionLocator;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayMemcachedSessionLocator
extends AbstractMemcachedSessionLocator {
    private HashAlgorithm hashAlgorighm;
    private volatile transient List<List<Session>> sessions;
    final Random rand = new Random();

    public ArrayMemcachedSessionLocator() {
        this.hashAlgorighm = HashAlgorithm.NATIVE_HASH;
    }

    public ArrayMemcachedSessionLocator(HashAlgorithm hashAlgorighm) {
        this.hashAlgorighm = hashAlgorighm;
    }

    public final void setHashAlgorighm(HashAlgorithm hashAlgorighm) {
        this.hashAlgorighm = hashAlgorighm;
    }

    public final long getHash(int size, String key) {
        long hash = this.hashAlgorighm.hash(key);
        return hash % (long)size;
    }

    @Override
    public final Session getSessionByKey(String key) {
        if (this.sessions == null || this.sessions.size() == 0) {
            return null;
        }
        List<List<Session>> sessionList = this.sessions;
        int size = sessionList.size();
        if (size == 0) {
            return null;
        }
        long start = this.getHash(size, key);
        List<Session> sessions = sessionList.get((int)start);
        Session session = this.getRandomSession(sessions);
        if (!this.failureMode && (session == null || session.isClosed())) {
            long next = this.getNext(size, start);
            while ((session == null || session.isClosed()) && next != start) {
                sessions = sessionList.get((int)next);
                next = this.getNext(size, next);
                session = this.getRandomSession(sessions);
            }
        }
        return session;
    }

    private Session getRandomSession(List<Session> sessions) {
        if (sessions == null || sessions.isEmpty()) {
            return null;
        }
        return sessions.get(this.rand.nextInt(sessions.size()));
    }

    public final long getNext(int size, long start) {
        if (start == (long)(size - 1)) {
            return 0L;
        }
        return start + 1L;
    }

    @Override
    public final void updateSessions(Collection<Session> list) {
        if (list == null || list.isEmpty()) {
            this.sessions = Collections.emptyList();
            return;
        }
        Collection<Session> copySessions = list;
        ArrayList tmpList = new ArrayList();
        Session target = null;
        ArrayList<Session> subList = null;
        for (Session session : copySessions) {
            if (target == null) {
                target = session;
                subList = new ArrayList<Session>();
                subList.add(target);
                continue;
            }
            if (session.getRemoteSocketAddress().equals(target.getRemoteSocketAddress())) {
                subList.add(session);
                continue;
            }
            tmpList.add(subList);
            target = session;
            subList = new ArrayList();
            subList.add(target);
        }
        if (subList != null) {
            tmpList.add(subList);
        }
        ArrayList<List<Session>> newSessions = new ArrayList<List<Session>>(tmpList.size() * 2);
        for (List list2 : tmpList) {
            if (list2 == null || list2.isEmpty()) continue;
            Session session = (Session)list2.get(0);
            if (session instanceof MemcachedTCPSession) {
                int weight = ((MemcachedSession)session).getWeight();
                for (int i = 0; i < weight; ++i) {
                    newSessions.add(list2);
                }
                continue;
            }
            newSessions.add(list2);
        }
        this.sessions = newSessions;
    }
}

