/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.impl;

import com.google.code.yanf4j.core.WriteMessage;
import com.google.code.yanf4j.util.LinkedTransferQueue;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import net.rubyeye.xmemcached.FlowControl;
import net.rubyeye.xmemcached.command.Command;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlowControlLinkedTransferQueue
extends LinkedTransferQueue<WriteMessage> {
    private FlowControl flowControl;

    public FlowControlLinkedTransferQueue(FlowControl flowControl) {
        this.flowControl = flowControl;
    }

    private void checkPermits(WriteMessage e) {
        Command cmd;
        if (e.getMessage() instanceof Command && (cmd = (Command)e.getMessage()).isNoreply()) {
            int i = 3;
            boolean success = false;
            while (i-- > 0) {
                if (this.flowControl.aquire()) {
                    success = true;
                    break;
                }
                Thread.yield();
            }
            if (!success) {
                throw new IllegalStateException("No permit for noreply operation,max=" + this.flowControl.max());
            }
        }
    }

    @Override
    public void put(WriteMessage e) throws InterruptedException {
        this.checkPermits(e);
        super.put(e);
    }

    @Override
    public boolean offer(WriteMessage e, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkPermits(e);
        return super.offer(e, timeout, unit);
    }

    @Override
    public boolean offer(WriteMessage e) {
        this.checkPermits(e);
        return super.offer(e);
    }

    @Override
    public void transfer(WriteMessage e) throws InterruptedException {
        this.checkPermits(e);
        super.transfer(e);
    }

    @Override
    public boolean tryTransfer(WriteMessage e, long timeout, TimeUnit unit) throws InterruptedException {
        this.checkPermits(e);
        return super.tryTransfer(e, timeout, unit);
    }

    @Override
    public boolean tryTransfer(WriteMessage e) {
        this.checkPermits(e);
        return super.tryTransfer(e);
    }

    @Override
    public WriteMessage take() throws InterruptedException {
        WriteMessage rt = (WriteMessage)super.take();
        this.releasePermit(rt);
        return rt;
    }

    @Override
    public WriteMessage poll(long timeout, TimeUnit unit) throws InterruptedException {
        WriteMessage rt = (WriteMessage)super.poll(timeout, unit);
        this.releasePermit(rt);
        return rt;
    }

    @Override
    public WriteMessage poll() {
        WriteMessage rt = (WriteMessage)super.poll();
        this.releasePermit(rt);
        return rt;
    }

    private void releasePermit(WriteMessage rt) {
        Command cmd;
        if (rt != null && rt.getMessage() instanceof Command && (cmd = (Command)rt.getMessage()).isNoreply()) {
            this.flowControl.release();
        }
    }

    @Override
    public int drainTo(Collection<? super WriteMessage> c) {
        return super.drainTo(c);
    }

    @Override
    public int drainTo(Collection<? super WriteMessage> c, int maxElements) {
        return super.drainTo(c, maxElements);
    }

    @Override
    public Iterator<WriteMessage> iterator() {
        return super.iterator();
    }

    @Override
    public WriteMessage peek() {
        return (WriteMessage)super.peek();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty();
    }

    @Override
    public boolean hasWaitingConsumer() {
        return super.hasWaitingConsumer();
    }

    @Override
    public int size() {
        return super.size();
    }

    @Override
    public int getWaitingConsumerCount() {
        return super.getWaitingConsumerCount();
    }

    @Override
    public int remainingCapacity() {
        return super.remainingCapacity();
    }
}

