/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.yanf4j.nio.impl;

import com.google.code.yanf4j.config.Configuration;
import com.google.code.yanf4j.core.EventType;
import com.google.code.yanf4j.core.Session;
import com.google.code.yanf4j.nio.NioSession;
import com.google.code.yanf4j.nio.impl.AbstractNioSession;
import com.google.code.yanf4j.nio.impl.NioController;
import com.google.code.yanf4j.nio.impl.SelectorManager;
import com.google.code.yanf4j.util.SystemUtils;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Date;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reactor
extends Thread {
    public static final int JVMBUG_THRESHHOLD = Integer.getInteger("com.googlecode.yanf4j.nio.JVMBUG_THRESHHOLD", 128);
    public static final int JVMBUG_THRESHHOLD2 = JVMBUG_THRESHHOLD * 2;
    public static final int JVMBUG_THRESHHOLD1 = (JVMBUG_THRESHHOLD2 + JVMBUG_THRESHHOLD) / 2;
    public static final int DEFAULT_WAIT = 1000;
    private static final Logger log = LoggerFactory.getLogger((String)"remoting");
    private boolean jvmBug0;
    private boolean jvmBug1;
    private final int reactorIndex;
    private final SelectorManager selectorManager;
    private final AtomicInteger jvmBug = new AtomicInteger(0);
    private long lastJVMBug;
    private Selector selector;
    private final NioController controller;
    private final Configuration configuration;
    private final AtomicBoolean wakenUp = new PaddingAtomicBoolean(false);
    private Queue<RegisterEvent> register;
    private final Lock gate = new ReentrantLock();
    private int selectTries = 0;
    private long nextTimeout = 0L;
    private long lastCheckTimestamp = 0L;

    Reactor(SelectorManager selectorManager, Configuration configuration, int index) throws IOException {
        this.reactorIndex = index;
        this.register = SystemUtils.createTransferQueue();
        this.selectorManager = selectorManager;
        this.controller = selectorManager.getController();
        this.selector = SystemUtils.openSelector();
        this.configuration = configuration;
        this.setName("Xmemcached-Reactor-" + index);
        this.setDaemon(true);
    }

    public final Selector getSelector() {
        return this.selector;
    }

    public int getReactorIndex() {
        return this.reactorIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.selectorManager.notifyReady();
        while (this.selectorManager.isStarted() && this.selector.isOpen()) {
            try {
                int selected;
                this.beforeSelect();
                this.wakenUp.set(false);
                long before = -1L;
                if (SystemUtils.isLinuxPlatform() && !SystemUtils.isAfterJava6u4Version()) {
                    before = System.currentTimeMillis();
                }
                long wait = 1000L;
                if (this.nextTimeout > 0L) {
                    wait = this.nextTimeout;
                }
                if ((selected = this.selector.select(wait)) == 0) {
                    if (before != -1L) {
                        this.lookJVMBug(before, selected, wait);
                    }
                    ++this.selectTries;
                    this.nextTimeout = this.checkSessionTimeout();
                    continue;
                }
                this.selectTries = 0;
            }
            catch (ClosedSelectorException e) {
                break;
            }
            catch (IOException e) {
                log.error("Reactor select error", (Throwable)e);
                if (!this.selector.isOpen()) break;
                continue;
            }
            Set<SelectionKey> selectedKeys = this.selector.selectedKeys();
            this.gate.lock();
            try {
                this.postSelect(selectedKeys, this.selector.keys());
                this.dispatchEvent(selectedKeys);
            }
            finally {
                this.gate.unlock();
            }
        }
        if (this.selector != null && this.selector.isOpen()) {
            try {
                this.controller.closeChannel(this.selector);
                this.selector.close();
            }
            catch (IOException e) {
                this.controller.notifyException(e);
                log.error("stop reactor error", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean lookJVMBug(long before, int selected, long wait) throws IOException {
        boolean seeing = false;
        long now = System.currentTimeMillis();
        if (JVMBUG_THRESHHOLD > 0 && selected == 0 && wait > (long)JVMBUG_THRESHHOLD && now - before < wait / 4L && !this.wakenUp.get() && !Thread.currentThread().isInterrupted()) {
            this.jvmBug.incrementAndGet();
            if (this.jvmBug.get() >= JVMBUG_THRESHHOLD2) {
                this.gate.lock();
                try {
                    this.lastJVMBug = now;
                    log.warn("JVM bug occured at " + new Date(this.lastJVMBug) + ",http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=6403933,reactIndex=" + this.reactorIndex);
                    if (this.jvmBug1) {
                        log.debug("seeing JVM BUG(s) - recreating selector,reactIndex=" + this.reactorIndex);
                    } else {
                        this.jvmBug1 = true;
                        log.info("seeing JVM BUG(s) - recreating selector,reactIndex=" + this.reactorIndex);
                    }
                    seeing = true;
                    Selector new_selector = SystemUtils.openSelector();
                    for (SelectionKey k : this.selector.keys()) {
                        if (!k.isValid() || k.interestOps() == 0) continue;
                        SelectableChannel channel = k.channel();
                        Object attachment = k.attachment();
                        channel.register(new_selector, k.interestOps(), attachment);
                    }
                    this.selector.close();
                    this.selector = new_selector;
                }
                finally {
                    this.gate.unlock();
                }
                this.jvmBug.set(0);
            } else if (this.jvmBug.get() == JVMBUG_THRESHHOLD || this.jvmBug.get() == JVMBUG_THRESHHOLD1) {
                if (this.jvmBug0) {
                    log.debug("seeing JVM BUG(s) - cancelling interestOps==0,reactIndex=" + this.reactorIndex);
                } else {
                    this.jvmBug0 = true;
                    log.info("seeing JVM BUG(s) - cancelling interestOps==0,reactIndex=" + this.reactorIndex);
                }
                this.gate.lock();
                seeing = true;
                try {
                    for (SelectionKey k : this.selector.keys()) {
                        if (!k.isValid() || k.interestOps() != 0) continue;
                        k.cancel();
                    }
                }
                finally {
                    this.gate.unlock();
                }
            }
        } else {
            this.jvmBug.set(0);
        }
        return seeing;
    }

    public final void dispatchEvent(Set<SelectionKey> selectedKeySet) {
        Iterator<SelectionKey> it = selectedKeySet.iterator();
        boolean skipOpRead = false;
        while (it.hasNext()) {
            SelectionKey key = it.next();
            it.remove();
            if (!key.isValid()) {
                if (key.attachment() != null) {
                    this.controller.closeSelectionKey(key);
                    continue;
                }
                key.cancel();
                continue;
            }
            try {
                if (key.isValid() && key.isAcceptable()) {
                    this.controller.onAccept(key);
                    continue;
                }
                if (key.isValid() && (key.readyOps() & 4) == 4) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFB);
                    this.controller.onWrite(key);
                    if (!this.controller.isHandleReadWriteConcurrently()) {
                        skipOpRead = true;
                    }
                }
                if (!skipOpRead && key.isValid() && (key.readyOps() & 1) == 1) {
                    key.interestOps(key.interestOps() & 0xFFFFFFFE);
                    if (!this.controller.getStatistics().isReceiveOverFlow()) {
                        this.controller.onRead(key);
                    } else {
                        key.interestOps(key.interestOps() | 1);
                    }
                }
                if ((key.readyOps() & 8) != 8) continue;
                this.controller.onConnect(key);
            }
            catch (CancelledKeyException cancelledKeyException) {
            }
            catch (RejectedExecutionException e) {
                if (key.attachment() instanceof AbstractNioSession) {
                    ((AbstractNioSession)key.attachment()).onException(e);
                }
                this.controller.notifyException(e);
                if (!this.selector.isOpen()) break;
            }
            catch (Exception e) {
                if (key.attachment() instanceof AbstractNioSession) {
                    ((AbstractNioSession)key.attachment()).onException(e);
                }
                this.controller.closeSelectionKey(key);
                this.controller.notifyException(e);
                log.error("Reactor dispatch events error", (Throwable)e);
                if (!this.selector.isOpen()) break;
            }
        }
    }

    final void unregisterChannel(SelectableChannel channel) throws IOException {
        SelectionKey key;
        Selector selector = this.selector;
        if (selector != null && channel != null && (key = channel.keyFor(selector)) != null) {
            key.cancel();
        }
        this.wakeup();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final long checkSessionTimeout() {
        long nextTimeout = 0L;
        if (this.configuration.getCheckSessionTimeoutInterval() > 0L) {
            this.gate.lock();
            try {
                if (this.isNeedCheckSessionIdleTimeout()) {
                    nextTimeout = this.configuration.getCheckSessionTimeoutInterval();
                    for (SelectionKey key : this.selector.keys()) {
                        if (key.attachment() == null) continue;
                        long n = this.checkExpiredIdle(key, this.getSessionFromAttchment(key));
                        nextTimeout = n < nextTimeout ? n : nextTimeout;
                    }
                    this.selectTries = 0;
                    this.lastCheckTimestamp = System.currentTimeMillis();
                }
            }
            finally {
                this.gate.unlock();
            }
        }
        return nextTimeout;
    }

    private boolean isNeedCheckSessionIdleTimeout() {
        return (long)(this.selectTries * 1000) >= this.configuration.getCheckSessionTimeoutInterval() || System.currentTimeMillis() - this.lastCheckTimestamp >= this.configuration.getCheckSessionTimeoutInterval();
    }

    private final Session getSessionFromAttchment(SelectionKey key) {
        if (key.attachment() instanceof Session) {
            return (Session)key.attachment();
        }
        return null;
    }

    public final void registerSession(Session session, EventType event) {
        Selector selector = this.selector;
        if (this.isReactorThread() && selector != null) {
            this.dispatchSessionEvent(session, event);
        } else {
            this.register.offer(new RegisterEvent(session, event));
            this.wakeup();
        }
    }

    private final boolean isReactorThread() {
        return Thread.currentThread() == this;
    }

    final void beforeSelect() {
        this.controller.checkStatisticsForRestart();
        this.processRegister();
    }

    private final void processRegister() {
        RegisterEvent event = null;
        while ((event = this.register.poll()) != null) {
            if (event.session != null) {
                this.dispatchSessionEvent(event.session, event.eventType);
                continue;
            }
            this.registerChannelNow(event.channel, event.ops, event.attachment);
        }
    }

    Configuration getConfiguration() {
        return this.configuration;
    }

    private final void dispatchSessionEvent(Session session, EventType event) {
        if (session.isClosed() && event != EventType.UNREGISTER) {
            return;
        }
        switch (event) {
            case REGISTER: {
                this.controller.registerSession(session);
                break;
            }
            case UNREGISTER: {
                this.controller.unregisterSession(session);
                break;
            }
            default: {
                ((NioSession)session).onEvent(event, this.selector);
            }
        }
    }

    public final void postSelect(Set<SelectionKey> selectedKeys, Set<SelectionKey> allKeys) {
        if ((this.controller.getSessionTimeout() > 0L || this.controller.getSessionIdleTimeout() > 0L) && this.isNeedCheckSessionIdleTimeout()) {
            for (SelectionKey key : allKeys) {
                if (selectedKeys.contains(key) || key.attachment() == null) continue;
                this.checkExpiredIdle(key, this.getSessionFromAttchment(key));
            }
            this.lastCheckTimestamp = System.currentTimeMillis();
        }
    }

    private long checkExpiredIdle(SelectionKey key, Session session) {
        if (session == null) {
            return 0L;
        }
        long nextTimeout = 0L;
        boolean expired = false;
        if (this.controller.getSessionTimeout() > 0L) {
            expired = this.checkExpired(key, session);
            nextTimeout = this.controller.getSessionTimeout();
        }
        if (this.controller.getSessionIdleTimeout() > 0L && !expired) {
            this.checkIdle(session);
            nextTimeout = this.controller.getSessionIdleTimeout();
        }
        return nextTimeout;
    }

    private final void checkIdle(Session session) {
        if (this.controller.getSessionIdleTimeout() > 0L && session.isIdle()) {
            ((NioSession)session).onEvent(EventType.IDLE, this.selector);
        }
    }

    private final boolean checkExpired(SelectionKey key, Session session) {
        if (session != null && session.isExpired()) {
            ((NioSession)session).onEvent(EventType.EXPIRED, this.selector);
            this.controller.closeSelectionKey(key);
            return true;
        }
        return false;
    }

    public final void registerChannel(SelectableChannel channel, int ops, Object attachment) {
        if (this.isReactorThread()) {
            this.registerChannelNow(channel, ops, attachment);
        } else {
            this.register.offer(new RegisterEvent(channel, ops, attachment));
            this.wakeup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerChannelNow(SelectableChannel channel, int ops, Object attachment) {
        if (channel.isOpen()) {
            this.gate.lock();
            try {
                channel.register(this.selector, ops, attachment);
            }
            catch (ClosedChannelException e) {
                log.error("Register channel error", (Throwable)e);
                this.controller.notifyException(e);
            }
            finally {
                this.gate.unlock();
            }
        }
    }

    final void wakeup() {
        Selector selector;
        if (this.wakenUp.compareAndSet(false, true) && (selector = this.selector) != null) {
            selector.wakeup();
        }
    }

    final void selectNow() throws IOException {
        Selector selector = this.selector;
        if (selector != null) {
            selector.selectNow();
        }
    }

    public static class RegisterEvent {
        SelectableChannel channel;
        int ops;
        EventType eventType;
        Object attachment;
        Session session;

        public RegisterEvent(SelectableChannel channel, int ops, Object attachment) {
            this.channel = channel;
            this.ops = ops;
            this.attachment = attachment;
        }

        public RegisterEvent(Session session, EventType eventType) {
            this.session = session;
            this.eventType = eventType;
        }
    }

    public static class PaddingAtomicBoolean
    extends AtomicBoolean {
        private static final long serialVersionUID = 5227571972657902891L;
        public int p1;
        public long p2;
        public long p3;
        public long p4;
        public long p5;
        public long p6;
        public long p7;
        public long p8;

        PaddingAtomicBoolean(boolean v) {
            super(v);
        }
    }
}

