/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.auth;

import java.util.Map;
import net.rubyeye.xmemcached.MemcachedClient;
import net.rubyeye.xmemcached.XMemcachedClient;
import net.rubyeye.xmemcached.auth.AuthInfo;
import net.rubyeye.xmemcached.auth.AuthTask;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import net.rubyeye.xmemcached.networking.MemcachedSessionConnectListener;
import net.rubyeye.xmemcached.utils.AddrUtil;

public class AuthMemcachedConnectListener
implements MemcachedSessionConnectListener {
    public void onConnect(MemcachedSession session, MemcachedClient client) {
        AuthInfo authInfo;
        MemcachedTCPSession tcpSession = (MemcachedTCPSession)session;
        Map<String, AuthInfo> authInfoMap = client.getAuthInfoStringMap();
        if (authInfoMap != null && (authInfo = authInfoMap.get(AddrUtil.getServerString(tcpSession.getRemoteSocketAddress()))) != null) {
            XMemcachedClient xMemcachedClient = (XMemcachedClient)client;
            AuthTask task = new AuthTask(authInfo, xMemcachedClient.getCommandFactory(), tcpSession);
            task.start();
            if (authInfo.isFirstTime()) {
                try {
                    task.join(1000L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }
}

