/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.aws;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import net.rubyeye.xmemcached.aws.AWSElasticCacheClient;
import net.rubyeye.xmemcached.aws.CacheNode;
import net.rubyeye.xmemcached.aws.ClusterConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationPoller
implements Runnable {
    private final AtomicInteger serverOrderCounter = new AtomicInteger(0);
    private Map<String, Integer> ordersMap = new HashMap<String, Integer>();
    private static final Logger log = LoggerFactory.getLogger(ConfigurationPoller.class);
    private final AWSElasticCacheClient client;
    private final long pollIntervalMills;
    private ScheduledExecutorService scheduledExecutorService;
    private volatile ClusterConfiguration clusterConfigration = null;

    public ClusterConfiguration getClusterConfiguration() {
        return this.clusterConfigration;
    }

    public synchronized int getCacheNodeOrder(CacheNode node) {
        Integer order = this.ordersMap.get(node.getCacheKey());
        if (order != null) {
            return order;
        }
        order = this.serverOrderCounter.incrementAndGet();
        this.ordersMap.put(node.getCacheKey(), order);
        return order;
    }

    public synchronized void removeCacheNodeOrder(CacheNode node) {
        this.ordersMap.remove(node.getCacheKey());
    }

    public ConfigurationPoller(AWSElasticCacheClient client, long pollIntervalMills) {
        this.client = client;
        this.pollIntervalMills = pollIntervalMills;
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "AWSElasticCacheConfigPoller");
                t.setDaemon(true);
                if (t.getPriority() != 5) {
                    t.setPriority(5);
                }
                return t;
            }
        });
    }

    public void start() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this, this.pollIntervalMills, this.pollIntervalMills, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        this.scheduledExecutorService.shutdown();
    }

    public void run() {
        try {
            ClusterConfiguration newConfig = this.client.getConfig();
            if (newConfig != null) {
                ClusterConfiguration currentConfig = this.clusterConfigration;
                if (currentConfig == null) {
                    this.clusterConfigration = newConfig;
                } else {
                    if (newConfig.getVersion() < currentConfig.getVersion()) {
                        log.warn("Ignored new config from ElasticCache node, it's too old, current version is: " + currentConfig.getVersion() + ", but the new version is: " + newConfig.getVersion());
                        return;
                    }
                    this.clusterConfigration = newConfig;
                }
                log.info("Retrieved new  config from ElasticCache node: " + this.clusterConfigration);
                this.client.onUpdate(newConfig);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            log.error("Poll config from ElasticCache node failed", (Throwable)e);
        }
    }
}

