/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command;

import java.net.InetSocketAddress;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.CommandFactory;
import net.rubyeye.xmemcached.buffer.BufferAllocator;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.text.TextAWSElasticCacheConfigCommand;
import net.rubyeye.xmemcached.command.text.TextCASCommand;
import net.rubyeye.xmemcached.command.text.TextDeleteCommand;
import net.rubyeye.xmemcached.command.text.TextFlushAllCommand;
import net.rubyeye.xmemcached.command.text.TextGetMultiCommand;
import net.rubyeye.xmemcached.command.text.TextGetOneCommand;
import net.rubyeye.xmemcached.command.text.TextIncrDecrCommand;
import net.rubyeye.xmemcached.command.text.TextQuitCommand;
import net.rubyeye.xmemcached.command.text.TextStatsCachedumpCommand;
import net.rubyeye.xmemcached.command.text.TextStatsCommand;
import net.rubyeye.xmemcached.command.text.TextStoreCommand;
import net.rubyeye.xmemcached.command.text.TextTouchCommand;
import net.rubyeye.xmemcached.command.text.TextVerbosityCommand;
import net.rubyeye.xmemcached.command.text.TextVersionCommand;
import net.rubyeye.xmemcached.transcoders.Transcoder;
import net.rubyeye.xmemcached.utils.ByteUtils;
import net.rubyeye.xmemcached.utils.Protocol;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextCommandFactory
implements CommandFactory {
    @Override
    public Command createAWSElasticCacheConfigCommand(String subCommand, String key) {
        return new TextAWSElasticCacheConfigCommand(new CountDownLatch(1), subCommand, key);
    }

    @Override
    public void setBufferAllocator(BufferAllocator bufferAllocator) {
    }

    @Override
    public final Command createDeleteCommand(String key, byte[] keyBytes, int time, long cas, boolean noreply) {
        return new TextDeleteCommand(key, keyBytes, time, new CountDownLatch(1), noreply);
    }

    @Override
    public final Command createVersionCommand(CountDownLatch latch, InetSocketAddress server) {
        return new TextVersionCommand(latch, server);
    }

    @Override
    public final Command createFlushAllCommand(CountDownLatch latch, int exptime, boolean noreply) {
        return new TextFlushAllCommand(latch, exptime, noreply);
    }

    @Override
    public final Command createVerbosityCommand(CountDownLatch latch, int level, boolean noreply) {
        return new TextVerbosityCommand(latch, level, noreply);
    }

    @Override
    public final Command createStatsCommand(InetSocketAddress server, CountDownLatch latch, String itemName) {
        return new TextStatsCommand(server, latch, itemName);
    }

    public final Command createStatsCachedumpCommand(InetSocketAddress server, CountDownLatch latch, int slabId, int limit) {
        return new TextStatsCachedumpCommand(server, latch, slabId, limit);
    }

    @Override
    public final Command createCASCommand(String key, byte[] keyBytes, int exp, Object value, long cas, boolean noreply, Transcoder transcoder) {
        return new TextCASCommand(key, keyBytes, CommandType.CAS, new CountDownLatch(1), exp, cas, value, noreply, transcoder);
    }

    @Override
    public final Command createSetCommand(String key, byte[] keyBytes, int exp, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, exp, value, CommandType.SET, noreply, transcoder);
    }

    @Override
    public final Command createAddCommand(String key, byte[] keyBytes, int exp, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, exp, value, CommandType.ADD, noreply, transcoder);
    }

    @Override
    public final Command createReplaceCommand(String key, byte[] keyBytes, int exp, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, exp, value, CommandType.REPLACE, noreply, transcoder);
    }

    @Override
    public final Command createAppendCommand(String key, byte[] keyBytes, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, 0, value, CommandType.APPEND, noreply, transcoder);
    }

    @Override
    public final Command createPrependCommand(String key, byte[] keyBytes, Object value, boolean noreply, Transcoder transcoder) {
        return this.createStoreCommand(key, keyBytes, 0, value, CommandType.PREPEND, noreply, transcoder);
    }

    final Command createStoreCommand(String key, byte[] keyBytes, int exp, Object value, CommandType cmdType, boolean noreply, Transcoder transcoder) {
        return new TextStoreCommand(key, keyBytes, cmdType, new CountDownLatch(1), exp, -1L, value, noreply, transcoder);
    }

    @Override
    public final Command createGetCommand(String key, byte[] keyBytes, CommandType cmdType, Transcoder transcoder) {
        return new TextGetOneCommand(key, keyBytes, cmdType, new CountDownLatch(1));
    }

    @Override
    public final <T> Command createGetMultiCommand(Collection<String> keys, CountDownLatch latch, CommandType cmdType, Transcoder<T> transcoder) {
        StringBuilder sb = new StringBuilder(keys.size() * 5);
        for (String tmpKey : keys) {
            ByteUtils.checkKey(tmpKey);
            sb.append(tmpKey).append(" ");
        }
        String gatherKey = sb.toString();
        byte[] keyBytes = ByteUtils.getBytes(gatherKey.substring(0, gatherKey.length() - 1));
        return new TextGetMultiCommand(keys.iterator().next(), keyBytes, cmdType, latch, transcoder);
    }

    @Override
    public final Command createIncrDecrCommand(String key, byte[] keyBytes, long amount, long initial, int exptime, CommandType cmdType, boolean noreply) {
        return new TextIncrDecrCommand(key, keyBytes, cmdType, new CountDownLatch(1), amount, initial, noreply);
    }

    @Override
    public Command createAuthListMechanismsCommand(CountDownLatch latch) {
        throw new UnsupportedOperationException("SASL is only supported by binary protocol");
    }

    @Override
    public Command createAuthStartCommand(String mechanism, CountDownLatch latch, byte[] authData) {
        throw new UnsupportedOperationException("SASL is only supported by binary protocol");
    }

    @Override
    public Command createAuthStepCommand(String mechanism, CountDownLatch latch, byte[] authData) {
        throw new UnsupportedOperationException("SASL is only supported by binary protocol");
    }

    @Override
    public Command createGetAndTouchCommand(String key, byte[] keyBytes, CountDownLatch latch, int exp, boolean noreply) {
        throw new UnsupportedOperationException("GAT is only supported by binary protocol");
    }

    @Override
    public Command createTouchCommand(String key, byte[] keyBytes, CountDownLatch latch, int exp, boolean noreply) {
        return new TextTouchCommand(key, keyBytes, CommandType.TOUCH, latch, exp, noreply);
    }

    @Override
    public Command createQuitCommand() {
        return new TextQuitCommand();
    }

    @Override
    public Protocol getProtocol() {
        return Protocol.Text;
    }
}

