/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.command.text;

import com.google.code.yanf4j.buffer.IoBuffer;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import net.rubyeye.xmemcached.command.Command;
import net.rubyeye.xmemcached.command.CommandType;
import net.rubyeye.xmemcached.command.ServerAddressAware;
import net.rubyeye.xmemcached.impl.MemcachedTCPSession;
import net.rubyeye.xmemcached.networking.MemcachedSession;
import net.rubyeye.xmemcached.utils.ByteUtils;

public class TextStatsCommand
extends Command
implements ServerAddressAware {
    public static final ByteBuffer STATS = ByteBuffer.wrap("stats\r\n".getBytes());
    private InetSocketAddress server;
    private String itemName;

    public String getItemName() {
        return this.itemName;
    }

    public final InetSocketAddress getServer() {
        return this.server;
    }

    public final void setServer(InetSocketAddress server) {
        this.server = server;
    }

    public void setItemName(String item) {
        this.itemName = item;
    }

    public TextStatsCommand(InetSocketAddress server, CountDownLatch latch, String itemName) {
        super("stats", (byte[])null, latch);
        this.commandType = CommandType.STATS;
        this.server = server;
        this.itemName = itemName;
        this.result = new HashMap();
    }

    public boolean decode(MemcachedTCPSession session, ByteBuffer buffer) {
        String line = null;
        while ((line = ByteUtils.nextLine(buffer)) != null) {
            if (line.equals("END")) {
                return this.done(session);
            }
            if (line.startsWith("STAT") || line.startsWith("PREFIX") || line.startsWith("ITEM")) {
                String[] items = line.split(" ");
                ((Map)this.getResult()).put(items[1], items[2]);
                continue;
            }
            return this.decodeError(line);
        }
        return false;
    }

    protected final boolean done(MemcachedSession session) {
        this.countDownLatch();
        return true;
    }

    public final void encode() {
        if (this.itemName == null) {
            this.ioBuffer = IoBuffer.wrap(STATS.slice());
        } else {
            this.ioBuffer = IoBuffer.allocate(5 + this.itemName.length() + 3);
            ByteUtils.setArguments(this.ioBuffer, "stats", this.itemName);
            this.ioBuffer.flip();
        }
    }
}

