/*
 * Decompiled with CFR 0.152.
 */
package net.rubyeye.xmemcached.utils;

import java.util.Arrays;

public class FastStringEncoder {
    private static final int STEP = 128;
    private static ThreadLocal<byte[]> bufLocal = new ThreadLocal();

    private static byte[] getBuf(int length) {
        byte[] buf = bufLocal.get();
        if (buf != null) {
            bufLocal.set(null);
        } else {
            buf = new byte[length < 128 ? 128 : length];
        }
        return buf;
    }

    private static void close(byte[] buf) {
        if (buf.length <= 65536) {
            bufLocal.set(buf);
        }
    }

    private static byte[] expandCapacity(byte[] buf, int minNewCapacity) {
        int newCapacity = buf.length + (buf.length >> 1) + 1;
        if (newCapacity < minNewCapacity) {
            newCapacity = minNewCapacity;
        }
        return Arrays.copyOf(buf, newCapacity);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static byte[] encodeUTF8(String s) {
        int len = s.length();
        byte[] bytes = FastStringEncoder.getBuf(len);
        int offset = 0;
        int sl = offset + len;
        int dp = 0;
        int dlASCII = dp + Math.min(len, bytes.length);
        while (dp < dlASCII && s.charAt(offset) < '\u0080') {
            bytes[dp++] = (byte)s.charAt(offset++);
        }
        while (offset < sl) {
            char c;
            if (dp >= bytes.length - 4) {
                bytes = FastStringEncoder.expandCapacity(bytes, bytes.length + 256);
            }
            if ((c = s.charAt(offset++)) < '\u0080') {
                bytes[dp++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                bytes[dp++] = (byte)(0xC0 | c >> 6);
                bytes[dp++] = (byte)(0x80 | c & 0x3F);
                continue;
            }
            if (c >= '\ud800' && c < '\ue000') {
                char c2;
                int ip = offset - 1;
                if (Character.isHighSurrogate(c)) {
                    if (sl - ip < 2) {
                        c2 = '\uffffffff';
                    } else {
                        char d = s.charAt(ip + 1);
                        if (!Character.isLowSurrogate(d)) throw new IllegalStateException("encodeUTF8 error");
                        c2 = Character.toCodePoint(c, d);
                    }
                } else {
                    if (Character.isLowSurrogate(c)) {
                        throw new IllegalStateException("encodeUTF8 error");
                    }
                    c2 = c;
                }
                if (c2 < '\u0000') {
                    bytes[dp++] = 63;
                    continue;
                }
                bytes[dp++] = (byte)(0xF0 | c2 >> 18);
                bytes[dp++] = (byte)(0x80 | c2 >> 12 & 0x3F);
                bytes[dp++] = (byte)(0x80 | c2 >> 6 & 0x3F);
                bytes[dp++] = (byte)(0x80 | c2 & 0x3F);
                ++offset;
                continue;
            }
            bytes[dp++] = (byte)(0xE0 | c >> 12);
            bytes[dp++] = (byte)(0x80 | c >> 6 & 0x3F);
            bytes[dp++] = (byte)(0x80 | c & 0x3F);
        }
        byte[] resultBytes = new byte[dp];
        System.arraycopy(bytes, 0, resultBytes, 0, dp);
        FastStringEncoder.close(bytes);
        return resultBytes;
    }
}

