/*
 * Decompiled with CFR 0.152.
 */
package com.hortonworks.registries.shaded.org.glassfish.jersey.internal;

import com.hortonworks.registries.shaded.javax.ws.rs.core.CacheControl;
import com.hortonworks.registries.shaded.javax.ws.rs.core.Cookie;
import com.hortonworks.registries.shaded.javax.ws.rs.core.EntityTag;
import com.hortonworks.registries.shaded.javax.ws.rs.core.Link;
import com.hortonworks.registries.shaded.javax.ws.rs.core.MediaType;
import com.hortonworks.registries.shaded.javax.ws.rs.core.NewCookie;
import com.hortonworks.registries.shaded.javax.ws.rs.core.Response;
import com.hortonworks.registries.shaded.javax.ws.rs.core.UriBuilder;
import com.hortonworks.registries.shaded.javax.ws.rs.core.Variant;
import com.hortonworks.registries.shaded.javax.ws.rs.ext.RuntimeDelegate;
import com.hortonworks.registries.shaded.org.glassfish.hk2.api.ServiceLocator;
import com.hortonworks.registries.shaded.org.glassfish.jersey.internal.inject.Providers;
import com.hortonworks.registries.shaded.org.glassfish.jersey.message.internal.JerseyLink;
import com.hortonworks.registries.shaded.org.glassfish.jersey.message.internal.OutboundJaxrsResponse;
import com.hortonworks.registries.shaded.org.glassfish.jersey.message.internal.OutboundMessageContext;
import com.hortonworks.registries.shaded.org.glassfish.jersey.message.internal.VariantListBuilder;
import com.hortonworks.registries.shaded.org.glassfish.jersey.spi.HeaderDelegateProvider;
import com.hortonworks.registries.shaded.org.glassfish.jersey.uri.internal.JerseyUriBuilder;
import java.net.URI;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public abstract class AbstractRuntimeDelegate
extends RuntimeDelegate {
    private final Set<HeaderDelegateProvider> hps;
    private final Map<Class<?>, RuntimeDelegate.HeaderDelegate<?>> map;

    protected AbstractRuntimeDelegate(ServiceLocator serviceLocator) {
        try {
            this.hps = Providers.getProviders(serviceLocator, HeaderDelegateProvider.class);
            this.map = new WeakHashMap();
            this.map.put(EntityTag.class, this._createHeaderDelegate(EntityTag.class));
            this.map.put(MediaType.class, this._createHeaderDelegate(MediaType.class));
            this.map.put(CacheControl.class, this._createHeaderDelegate(CacheControl.class));
            this.map.put(NewCookie.class, this._createHeaderDelegate(NewCookie.class));
            this.map.put(Cookie.class, this._createHeaderDelegate(Cookie.class));
            this.map.put(URI.class, this._createHeaderDelegate(URI.class));
            this.map.put(Date.class, this._createHeaderDelegate(Date.class));
            this.map.put(String.class, this._createHeaderDelegate(String.class));
        }
        finally {
            serviceLocator.shutdown();
        }
    }

    @Override
    public Variant.VariantListBuilder createVariantListBuilder() {
        return new VariantListBuilder();
    }

    @Override
    public Response.ResponseBuilder createResponseBuilder() {
        return new OutboundJaxrsResponse.Builder(new OutboundMessageContext());
    }

    @Override
    public UriBuilder createUriBuilder() {
        return new JerseyUriBuilder();
    }

    @Override
    public Link.Builder createLinkBuilder() {
        return new JerseyLink.Builder();
    }

    @Override
    public <T> RuntimeDelegate.HeaderDelegate<T> createHeaderDelegate(Class<T> type) {
        if (type == null) {
            throw new IllegalArgumentException("type parameter cannot be null");
        }
        RuntimeDelegate.HeaderDelegate<?> delegate = this.map.get(type);
        if (delegate != null) {
            return delegate;
        }
        return this._createHeaderDelegate(type);
    }

    private <T> RuntimeDelegate.HeaderDelegate<T> _createHeaderDelegate(Class<T> type) {
        for (HeaderDelegateProvider hp : this.hps) {
            if (!hp.supports(type)) continue;
            return hp;
        }
        return null;
    }
}

