/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;

public class GetSynonymOptions
extends GenericModel {
    private String workspaceId;
    private String entity;
    private String value;
    private String synonym;
    private Boolean includeAudit;

    private GetSynonymOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.entity, (String)"entity cannot be empty");
        Validator.notEmpty((String)builder.value, (String)"value cannot be empty");
        Validator.notEmpty((String)builder.synonym, (String)"synonym cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.entity = builder.entity;
        this.value = builder.value;
        this.synonym = builder.synonym;
        this.includeAudit = builder.includeAudit;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String entity() {
        return this.entity;
    }

    public String value() {
        return this.value;
    }

    public String synonym() {
        return this.synonym;
    }

    public Boolean includeAudit() {
        return this.includeAudit;
    }

    public static class Builder {
        private String workspaceId;
        private String entity;
        private String value;
        private String synonym;
        private Boolean includeAudit;

        private Builder(GetSynonymOptions getSynonymOptions) {
            this.workspaceId = getSynonymOptions.workspaceId;
            this.entity = getSynonymOptions.entity;
            this.value = getSynonymOptions.value;
            this.synonym = getSynonymOptions.synonym;
            this.includeAudit = getSynonymOptions.includeAudit;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String entity, String value, String synonym) {
            this.workspaceId = workspaceId;
            this.entity = entity;
            this.value = value;
            this.synonym = synonym;
        }

        public GetSynonymOptions build() {
            return new GetSynonymOptions(this);
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder entity(String entity) {
            this.entity = entity;
            return this;
        }

        public Builder value(String value) {
            this.value = value;
            return this;
        }

        public Builder synonym(String synonym) {
            this.synonym = synonym;
            return this;
        }

        public Builder includeAudit(Boolean includeAudit) {
            this.includeAudit = includeAudit;
            return this;
        }
    }
}

