/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model;

import com.ibm.watson.developer_cloud.assistant.v1.model.DialogNodeAction;
import com.ibm.watson.developer_cloud.assistant.v1.model.DialogNodeNextStep;
import com.ibm.watson.developer_cloud.service.model.GenericModel;
import com.ibm.watson.developer_cloud.util.Validator;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UpdateDialogNodeOptions
extends GenericModel {
    private String workspaceId;
    private String dialogNode;
    private String nodeType;
    private List<DialogNodeAction> newActions;
    private String newConditions;
    private Map newContext;
    private String newPreviousSibling;
    private String newVariable;
    private Map newMetadata;
    private String newTitle;
    private String newDescription;
    private String newDigressOut;
    private String newEventName;
    private String newDigressOutSlots;
    private DialogNodeNextStep newNextStep;
    private String newDigressIn;
    private Map newOutput;
    private String newParent;
    private String newDialogNode;

    private UpdateDialogNodeOptions(Builder builder) {
        Validator.notEmpty((String)builder.workspaceId, (String)"workspaceId cannot be empty");
        Validator.notEmpty((String)builder.dialogNode, (String)"dialogNode cannot be empty");
        this.workspaceId = builder.workspaceId;
        this.dialogNode = builder.dialogNode;
        this.nodeType = builder.nodeType;
        this.newActions = builder.newActions;
        this.newConditions = builder.newConditions;
        this.newContext = builder.newContext;
        this.newPreviousSibling = builder.newPreviousSibling;
        this.newVariable = builder.newVariable;
        this.newMetadata = builder.newMetadata;
        this.newTitle = builder.newTitle;
        this.newDescription = builder.newDescription;
        this.newDigressOut = builder.newDigressOut;
        this.newEventName = builder.newEventName;
        this.newDigressOutSlots = builder.newDigressOutSlots;
        this.newNextStep = builder.newNextStep;
        this.newDigressIn = builder.newDigressIn;
        this.newOutput = builder.newOutput;
        this.newParent = builder.newParent;
        this.newDialogNode = builder.newDialogNode;
    }

    public Builder newBuilder() {
        return new Builder(this);
    }

    public String workspaceId() {
        return this.workspaceId;
    }

    public String dialogNode() {
        return this.dialogNode;
    }

    public String nodeType() {
        return this.nodeType;
    }

    public List<DialogNodeAction> newActions() {
        return this.newActions;
    }

    public String newConditions() {
        return this.newConditions;
    }

    public Map newContext() {
        return this.newContext;
    }

    public String newPreviousSibling() {
        return this.newPreviousSibling;
    }

    public String newVariable() {
        return this.newVariable;
    }

    public Map newMetadata() {
        return this.newMetadata;
    }

    public String newTitle() {
        return this.newTitle;
    }

    public String newDescription() {
        return this.newDescription;
    }

    public String newDigressOut() {
        return this.newDigressOut;
    }

    public String newEventName() {
        return this.newEventName;
    }

    public String newDigressOutSlots() {
        return this.newDigressOutSlots;
    }

    public DialogNodeNextStep newNextStep() {
        return this.newNextStep;
    }

    public String newDigressIn() {
        return this.newDigressIn;
    }

    public Map newOutput() {
        return this.newOutput;
    }

    public String newParent() {
        return this.newParent;
    }

    public String newDialogNode() {
        return this.newDialogNode;
    }

    public static class Builder {
        private String workspaceId;
        private String dialogNode;
        private String nodeType;
        private List<DialogNodeAction> newActions;
        private String newConditions;
        private Map newContext;
        private String newPreviousSibling;
        private String newVariable;
        private Map newMetadata;
        private String newTitle;
        private String newDescription;
        private String newDigressOut;
        private String newEventName;
        private String newDigressOutSlots;
        private DialogNodeNextStep newNextStep;
        private String newDigressIn;
        private Map newOutput;
        private String newParent;
        private String newDialogNode;

        private Builder(UpdateDialogNodeOptions updateDialogNodeOptions) {
            this.workspaceId = updateDialogNodeOptions.workspaceId;
            this.dialogNode = updateDialogNodeOptions.dialogNode;
            this.nodeType = updateDialogNodeOptions.nodeType;
            this.newActions = updateDialogNodeOptions.newActions;
            this.newConditions = updateDialogNodeOptions.newConditions;
            this.newContext = updateDialogNodeOptions.newContext;
            this.newPreviousSibling = updateDialogNodeOptions.newPreviousSibling;
            this.newVariable = updateDialogNodeOptions.newVariable;
            this.newMetadata = updateDialogNodeOptions.newMetadata;
            this.newTitle = updateDialogNodeOptions.newTitle;
            this.newDescription = updateDialogNodeOptions.newDescription;
            this.newDigressOut = updateDialogNodeOptions.newDigressOut;
            this.newEventName = updateDialogNodeOptions.newEventName;
            this.newDigressOutSlots = updateDialogNodeOptions.newDigressOutSlots;
            this.newNextStep = updateDialogNodeOptions.newNextStep;
            this.newDigressIn = updateDialogNodeOptions.newDigressIn;
            this.newOutput = updateDialogNodeOptions.newOutput;
            this.newParent = updateDialogNodeOptions.newParent;
            this.newDialogNode = updateDialogNodeOptions.newDialogNode;
        }

        public Builder() {
        }

        public Builder(String workspaceId, String dialogNode) {
            this.workspaceId = workspaceId;
            this.dialogNode = dialogNode;
        }

        public UpdateDialogNodeOptions build() {
            return new UpdateDialogNodeOptions(this);
        }

        public Builder addNewActions(DialogNodeAction newActions) {
            Validator.notNull((Object)((Object)newActions), (String)"newActions cannot be null");
            if (this.newActions == null) {
                this.newActions = new ArrayList<DialogNodeAction>();
            }
            this.newActions.add(newActions);
            return this;
        }

        public Builder workspaceId(String workspaceId) {
            this.workspaceId = workspaceId;
            return this;
        }

        public Builder dialogNode(String dialogNode) {
            this.dialogNode = dialogNode;
            return this;
        }

        public Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public Builder newActions(List<DialogNodeAction> newActions) {
            this.newActions = newActions;
            return this;
        }

        public Builder newConditions(String newConditions) {
            this.newConditions = newConditions;
            return this;
        }

        public Builder newContext(Map newContext) {
            this.newContext = newContext;
            return this;
        }

        public Builder newPreviousSibling(String newPreviousSibling) {
            this.newPreviousSibling = newPreviousSibling;
            return this;
        }

        public Builder newVariable(String newVariable) {
            this.newVariable = newVariable;
            return this;
        }

        public Builder newMetadata(Map newMetadata) {
            this.newMetadata = newMetadata;
            return this;
        }

        public Builder newTitle(String newTitle) {
            this.newTitle = newTitle;
            return this;
        }

        public Builder newDescription(String newDescription) {
            this.newDescription = newDescription;
            return this;
        }

        public Builder newDigressOut(String newDigressOut) {
            this.newDigressOut = newDigressOut;
            return this;
        }

        public Builder newEventName(String newEventName) {
            this.newEventName = newEventName;
            return this;
        }

        public Builder newDigressOutSlots(String newDigressOutSlots) {
            this.newDigressOutSlots = newDigressOutSlots;
            return this;
        }

        public Builder newNextStep(DialogNodeNextStep newNextStep) {
            this.newNextStep = newNextStep;
            return this;
        }

        public Builder newDigressIn(String newDigressIn) {
            this.newDigressIn = newDigressIn;
            return this;
        }

        public Builder newOutput(Map newOutput) {
            this.newOutput = newOutput;
            return this;
        }

        public Builder newParent(String newParent) {
            this.newParent = newParent;
            return this;
        }

        public Builder newDialogNode(String newDialogNode) {
            this.newDialogNode = newDialogNode;
            return this;
        }
    }

    public static interface NewDigressIn {
        public static final String NOT_AVAILABLE = "not_available";
        public static final String RETURNS = "returns";
        public static final String DOES_NOT_RETURN = "does_not_return";
    }

    public static interface NewDigressOutSlots {
        public static final String NOT_ALLOWED = "not_allowed";
        public static final String ALLOW_RETURNING = "allow_returning";
        public static final String ALLOW_ALL = "allow_all";
    }

    public static interface NewEventName {
        public static final String FOCUS = "focus";
        public static final String INPUT = "input";
        public static final String FILLED = "filled";
        public static final String VALIDATE = "validate";
        public static final String FILLED_MULTIPLE = "filled_multiple";
        public static final String GENERIC = "generic";
        public static final String NOMATCH = "nomatch";
        public static final String NOMATCH_RESPONSES_DEPLETED = "nomatch_responses_depleted";
    }

    public static interface NewDigressOut {
        public static final String ALLOW_RETURNING = "allow_returning";
        public static final String ALLOW_ALL = "allow_all";
        public static final String ALLOW_ALL_NEVER_RETURN = "allow_all_never_return";
    }

    public static interface NodeType {
        public static final String STANDARD = "standard";
        public static final String EVENT_HANDLER = "event_handler";
        public static final String FRAME = "frame";
        public static final String SLOT = "slot";
        public static final String RESPONSE_CONDITION = "response_condition";
        public static final String FOLDER = "folder";
    }
}

