/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.assistant.v1.model.util;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import com.ibm.watson.developer_cloud.assistant.v1.model.Pagination;
import java.io.IOException;
import okhttp3.HttpUrl;

public class PaginationTypeAdapter
extends TypeAdapter<Pagination> {
    private static final String MATCHED = "matched";
    private static final String TOTAL = "total";
    private static final String NEXT_URL = "next_url";
    private static final String REFRESH_URL = "refresh_url";
    private static final String CURSOR = "cursor";
    private static final String DEFAULT_ENDPOINT = "http://do.not.use";

    public void write(JsonWriter writer, Pagination pagination) throws IOException {
        writer.beginObject();
        writer.name(REFRESH_URL).value(pagination.getRefreshUrl());
        writer.name(NEXT_URL).value(pagination.getNextUrl());
        writer.name(TOTAL).value((Number)pagination.getTotal());
        writer.name(MATCHED).value((Number)pagination.getMatched());
        writer.endObject();
        writer.flush();
    }

    public Pagination read(JsonReader reader) throws IOException {
        if (reader.peek() == JsonToken.NULL) {
            reader.nextNull();
            return null;
        }
        reader.beginObject();
        Pagination pagination = new Pagination();
        while (reader.hasNext()) {
            String name = reader.nextName();
            if (name.equals(REFRESH_URL)) {
                pagination.setRefreshUrl(reader.nextString());
                continue;
            }
            if (name.equals(NEXT_URL)) {
                String nextUrl = reader.nextString();
                HttpUrl url = HttpUrl.parse((String)(DEFAULT_ENDPOINT + nextUrl));
                pagination.setCursor(url.queryParameter(CURSOR));
                pagination.setNextUrl(nextUrl);
                continue;
            }
            if (name.equals(TOTAL)) {
                pagination.setTotal(reader.nextLong());
                continue;
            }
            if (name.equals(MATCHED)) {
                pagination.setMatched(reader.nextLong());
                continue;
            }
            reader.skipValue();
        }
        reader.endObject();
        return pagination;
    }
}

