/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.http;

import com.ibm.watson.developer_cloud.http.WatsonCookieJar;
import com.ibm.watson.developer_cloud.service.WatsonService;
import com.ibm.watson.developer_cloud.service.security.DelegatingSSLSocketFactory;
import com.ibm.watson.developer_cloud.util.HttpLogging;
import java.io.IOException;
import java.net.CookieManager;
import java.net.CookiePolicy;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import okhttp3.ConnectionSpec;
import okhttp3.CookieJar;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.TlsVersion;

public class HttpClientSingleton {
    private static HttpClientSingleton instance = null;
    private static final Logger LOG = Logger.getLogger(WatsonService.class.getName());
    private OkHttpClient okHttpClient = this.configureHttpClient();

    public static HttpClientSingleton getInstance() {
        if (instance == null) {
            instance = new HttpClientSingleton();
        }
        return instance;
    }

    protected HttpClientSingleton() {
    }

    private OkHttpClient configureHttpClient() {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        this.addCookieJar(builder);
        builder.connectTimeout(60L, TimeUnit.SECONDS);
        builder.writeTimeout(60L, TimeUnit.SECONDS);
        builder.readTimeout(90L, TimeUnit.SECONDS);
        builder.addNetworkInterceptor((Interceptor)HttpLogging.getLoggingInterceptor());
        ConnectionSpec spec = new ConnectionSpec.Builder(ConnectionSpec.MODERN_TLS).allEnabledCipherSuites().build();
        builder.connectionSpecs(Arrays.asList(spec, ConnectionSpec.CLEARTEXT));
        this.setupTLSProtocol(builder);
        return builder.build();
    }

    private void addCookieJar(OkHttpClient.Builder builder) {
        CookieManager cookieManager = new CookieManager();
        cookieManager.setCookiePolicy(CookiePolicy.ACCEPT_ALL);
        builder.cookieJar((CookieJar)new WatsonCookieJar(cookieManager));
    }

    private void setupTLSProtocol(OkHttpClient.Builder builder) {
        try {
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustManagerFactory.init((KeyStore)null);
            Object[] trustManagers = trustManagerFactory.getTrustManagers();
            if (trustManagers.length != 1 || !(trustManagers[0] instanceof X509TrustManager)) {
                throw new IllegalStateException("Unexpected default trust managers:" + Arrays.toString(trustManagers));
            }
            X509TrustManager trustManager = (X509TrustManager)trustManagers[0];
            System.setProperty("com.ibm.jsse2.overrideDefaultTLS", "true");
            SSLContext sslContext = SSLContext.getInstance("TLSv1.2");
            sslContext.init(null, new TrustManager[]{trustManager}, null);
            DelegatingSSLSocketFactory sslSocketFactory = new DelegatingSSLSocketFactory(sslContext.getSocketFactory()){

                @Override
                protected SSLSocket configureSocket(SSLSocket socket) throws IOException {
                    socket.setEnabledProtocols(new String[]{TlsVersion.TLS_1_0.javaName(), TlsVersion.TLS_1_1.javaName(), TlsVersion.TLS_1_2.javaName()});
                    return socket;
                }
            };
            builder.sslSocketFactory((SSLSocketFactory)sslSocketFactory, trustManager);
        }
        catch (NoSuchAlgorithmException e) {
            LOG.log(Level.SEVERE, "The cryptographic algorithm requested is not available in the environment.", e);
        }
        catch (KeyStoreException e) {
            LOG.log(Level.SEVERE, "Error using the keystore.", e);
        }
        catch (KeyManagementException e) {
            LOG.log(Level.SEVERE, "Error initializing the SSL Context.", e);
        }
    }

    public OkHttpClient createHttpClient() {
        OkHttpClient.Builder builder = this.okHttpClient.newBuilder();
        this.addCookieJar(builder);
        return builder.build();
    }
}

