/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.watson.developer_cloud.service.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class DelegatingSSLSocketFactory
extends SSLSocketFactory {
    private final SSLSocketFactory delegate;

    public DelegatingSSLSocketFactory(SSLSocketFactory delegate) {
        this.delegate = delegate;
    }

    @Override
    public SSLSocket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket();
        return this.configureSocket(sslSocket);
    }

    @Override
    public SSLSocket createSocket(String host, int port) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(host, port);
        return this.configureSocket(sslSocket);
    }

    @Override
    public SSLSocket createSocket(String host, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(host, port, localAddress, localPort);
        return this.configureSocket(sslSocket);
    }

    @Override
    public SSLSocket createSocket(InetAddress host, int port) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(host, port);
        return this.configureSocket(sslSocket);
    }

    @Override
    public SSLSocket createSocket(InetAddress host, int port, InetAddress localAddress, int localPort) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(host, port, localAddress, localPort);
        return this.configureSocket(sslSocket);
    }

    @Override
    public String[] getDefaultCipherSuites() {
        return this.delegate.getDefaultCipherSuites();
    }

    @Override
    public String[] getSupportedCipherSuites() {
        return this.delegate.getSupportedCipherSuites();
    }

    @Override
    public SSLSocket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException {
        SSLSocket sslSocket = (SSLSocket)this.delegate.createSocket(socket, host, port, autoClose);
        return this.configureSocket(sslSocket);
    }

    protected SSLSocket configureSocket(SSLSocket sslSocket) throws IOException {
        return sslSocket;
    }
}

