/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.css;

import com.itextpdf.tool.xml.Tag;
import com.itextpdf.tool.xml.css.CssUtils;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CssSelector {
    private final CssUtils utils = CssUtils.getInstance();

    public Set<String> createAllSelectors(Tag t) {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(this.createTagSelectors(t));
        set.addAll(this.createClassSelectors(t));
        set.addAll(this.createIdSelector(t));
        return set;
    }

    public void createSelectors(Tag t, Set<String> selectors) {
        StringBuilder builder;
        LinkedHashSet<String> tagNameSet = new LinkedHashSet<String>();
        for (String selector : selectors) {
            tagNameSet.add(t.getName() + (selector.startsWith(" ") ? "" : " ") + selector);
        }
        LinkedHashSet<String> tagClassSet = new LinkedHashSet<String>();
        String tagClasses = t.getAttributes().get("class");
        String[] classSplit = null;
        if (tagClasses != null) {
            classSplit = this.utils.stripDoubleSpacesAndTrim(tagClasses).split(" ");
            for (String selector : selectors) {
                for (String tagClass : classSplit) {
                    builder = new StringBuilder();
                    builder.append('.').append(tagClass);
                    if (selector.startsWith("#") || selector.startsWith(".") || selector.startsWith(" ")) {
                        tagClassSet.add(builder.toString() + selector);
                        if (!selector.startsWith(" ")) {
                            tagClassSet.add(builder.toString() + " " + selector);
                        }
                        for (String tagSelector : tagNameSet) {
                            builder = new StringBuilder(tagSelector);
                            builder.append('.').append(tagClass);
                            tagClassSet.add(builder.toString());
                        }
                        continue;
                    }
                    builder.append(" " + selector);
                    tagClassSet.add(builder.toString());
                }
            }
        }
        String id = t.getAttributes().get("id");
        LinkedHashSet<String> tagIdSet = new LinkedHashSet<String>(1);
        if (id != null) {
            for (String selector : selectors) {
                StringBuilder builder2 = new StringBuilder();
                builder2.append('#').append(id);
                if (selector.startsWith("#") || selector.startsWith(".") || selector.startsWith(" ")) {
                    tagClassSet.add(builder2.toString() + selector);
                    if (selector.startsWith(" ")) continue;
                    tagClassSet.add(builder2.toString() + " " + selector);
                    continue;
                }
                builder2.append(" " + selector);
                tagClassSet.add(builder2.toString());
            }
        }
        if (selectors.isEmpty()) {
            tagNameSet.add(t.getName());
            if (tagClasses != null) {
                for (String tagClass : classSplit) {
                    builder = new StringBuilder();
                    builder.append('.').append(tagClass);
                    tagClassSet.add(builder.toString());
                    builder = new StringBuilder();
                    builder.append(" .").append(tagClass);
                    tagClassSet.add(builder.toString());
                    for (String tagSelector : tagNameSet) {
                        builder = new StringBuilder(tagSelector);
                        builder.append('.').append(tagClass);
                        tagClassSet.add(builder.toString());
                    }
                }
            }
            if (id != null) {
                StringBuilder builder3 = new StringBuilder();
                builder3.append('#').append(id);
                tagIdSet.add(builder3.toString());
                builder3 = new StringBuilder();
                builder3.append(" #").append(id);
                tagIdSet.add(builder3.toString());
            }
        }
        selectors.addAll(tagNameSet);
        selectors.addAll(tagClassSet);
        selectors.addAll(tagIdSet);
        if (t.getParent() != null && selectors.size() < 30) {
            this.createSelectors(t.getParent(), selectors);
        }
    }

    public Set<String> createTagSelectors(Tag t) {
        LinkedHashSet<String> selectors = new LinkedHashSet<String>();
        selectors.add(t.getName());
        if (null != t.getParent()) {
            StringBuilder b = new StringBuilder(t.getName());
            StringBuilder bStripped = new StringBuilder(t.getName());
            StringBuilder bElem = new StringBuilder(t.getName());
            StringBuilder bChild = new StringBuilder(t.getName());
            StringBuilder bChildSpaced = new StringBuilder(t.getName());
            Tag child = t;
            for (Tag parent = t.getParent(); null != parent; parent = parent.getParent()) {
                if (parent.getChildren().indexOf(child) == 0) {
                    bChild.insert(0, '+').insert(0, parent.getName());
                    bChildSpaced.insert(0, " + ").insert(0, parent.getName());
                    selectors.add(bChild.toString());
                    selectors.add(bChildSpaced.toString());
                }
                b.insert(0, " > ").insert(0, parent.getName());
                selectors.add(b.toString());
                bStripped.insert(0, ">").insert(0, parent.getName());
                selectors.add(bStripped.toString());
                bElem.insert(0, ' ').insert(0, parent.getName());
                selectors.add(bElem.toString());
                child = parent;
            }
        }
        return selectors;
    }

    public Set<String> createClassSelectors(Tag t) {
        String classes = t.getAttributes().get("class");
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        if (null != classes) {
            String[] classSplit;
            for (String klass : classSplit = this.utils.stripDoubleSpacesAndTrim(classes).split(" ")) {
                StringBuilder builder = new StringBuilder();
                builder.append('.').append(klass);
                set.add(builder.toString());
            }
        }
        return set;
    }

    public Set<String> createIdSelector(Tag t) {
        String id = t.getAttributes().get("id");
        LinkedHashSet<String> set = new LinkedHashSet<String>(1);
        if (null != id) {
            StringBuilder builder = new StringBuilder();
            builder.append('#').append(id);
            set.add(builder.toString());
        }
        return set;
    }
}

