/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.tool.xml.svg.graphic;

import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.tool.xml.svg.tags.Graphic;
import java.util.ArrayList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Rectangle
extends Graphic {
    float x;
    float y;
    float width;
    float height;
    float rx;
    float ry;

    public float getX() {
        return this.x;
    }

    public float getY() {
        return this.y;
    }

    public float getWidth() {
        return this.width;
    }

    public float getHeight() {
        return this.height;
    }

    public float getRx() {
        return this.rx;
    }

    public float getRy() {
        return this.ry;
    }

    public Rectangle(float x, float y, float width, float height, float rx, float ry, Map<String, String> css) {
        super(css);
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        this.rx = rx;
        this.ry = ry;
    }

    @Override
    public void draw(PdfContentByte cb) {
        if (this.rx == 0.0f || this.ry == 0.0f) {
            cb.rectangle(this.x, this.y, this.width, this.height);
        } else {
            cb.moveTo(this.x + this.rx, this.y);
            cb.lineTo(this.x + this.width - this.rx, this.y);
            this.arc(this.x + this.width - 2.0f * this.rx, this.y, this.x + this.width, this.y + 2.0f * this.ry, -90.0f, 90.0f, cb);
            cb.lineTo(this.x + this.width, this.y + this.height - this.ry);
            this.arc(this.x + this.width, this.y + this.height - 2.0f * this.ry, this.x + this.width - 2.0f * this.rx, this.y + this.height, 0.0f, 90.0f, cb);
            cb.lineTo(this.x + this.rx, this.y + this.height);
            this.arc(this.x + 2.0f * this.rx, this.y + this.height, this.x, this.y + this.height - 2.0f * this.ry, 90.0f, 90.0f, cb);
            cb.lineTo(this.x, this.y + this.ry);
            this.arc(this.x, this.y + 2.0f * this.ry, this.x + 2.0f * this.rx, this.y, 180.0f, 90.0f, cb);
            cb.closePath();
        }
    }

    public void arc(float x1, float y1, float x2, float y2, float startAng, float extent, PdfContentByte cb) {
        ArrayList ar = PdfContentByte.bezierArc((float)x1, (float)y1, (float)x2, (float)y2, (float)startAng, (float)extent);
        if (ar.isEmpty()) {
            return;
        }
        float[] pt = (float[])ar.get(0);
        for (int k = 0; k < ar.size(); ++k) {
            pt = (float[])ar.get(k);
            cb.curveTo(pt[2], pt[3], pt[4], pt[5], pt[6], pt[7]);
        }
    }
}

