/*
 * $Id: c3d261af25e60ac79de9f04c3be57201f93fd5ac $
 *
 * This file is part of the iText (R) project.
 * Copyright (c) 1998-2015 iText Group NV
 * Authors: Balder Van Camp, Emiel Ackermann, et al.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License version 3
 * as published by the Free Software Foundation with the addition of the
 * following permission added to Section 15 as permitted in Section 7(a):
 * FOR ANY PART OF THE COVERED WORK IN WHICH THE COPYRIGHT IS OWNED BY
 * ITEXT GROUP. ITEXT GROUP DISCLAIMS THE WARRANTY OF NON INFRINGEMENT
 * OF THIRD PARTY RIGHTS
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Affero General Public License for more details.
 * You should have received a copy of the GNU Affero General Public License
 * along with this program; if not, see http://www.gnu.org/licenses or write to
 * the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA, 02110-1301 USA, or download the license from the following URL:
 * http://itextpdf.com/terms-of-use/
 *
 * The interactive user interfaces in modified source and object code versions
 * of this program must display Appropriate Legal Notices, as required under
 * Section 5 of the GNU Affero General Public License.
 *
 * In accordance with Section 7(b) of the GNU Affero General Public License,
 * a covered work must retain the producer line in every PDF that is created
 * or manipulated using iText.
 *
 * You can be released from the requirements of the license by purchasing
 * a commercial license. Buying such a license is mandatory as soon as you
 * develop commercial activities involving the iText software without
 * disclosing the source code of your own applications.
 * These activities include: offering paid services to customers as an ASP,
 * serving PDFs on the fly in a web application, shipping iText with a closed
 * source product.
 *
 * For more information, please contact iText Software Corp. at this
 * address: sales@itextpdf.com
 */
package com.itextpdf.tool.xml;

import java.util.List;

import com.itextpdf.tool.xml.exceptions.LocaleMessages;
import com.itextpdf.tool.xml.exceptions.NoSiblingException;

/**
 *
 * Utilities that perform operations on tags.
 * @author Emiel Ackermann
 *
 */
public class TagUtils {

	private static final TagUtils myself = new TagUtils();

	/**
	 *
	 */
	public TagUtils() {
	}
	/**
	 * Method used for retrieving a sibling of the given tag t.
	 *
	 * @param t tag to find the previous sibling of
	 * @param i int index relative to the one of the given tag. (-i for previous siblings)
	 * @return the previous sibling
	 * @throws NoSiblingException when no previous sibling can be found, because the tag is the first child.
	 */
	public Tag getSibling(final Tag t, final int i) throws NoSiblingException {
		Tag sibling = null;
		try {
			List<Tag> siblings = t.getParent().getChildren();
			sibling = siblings.get(siblings.indexOf(t)+i);
		} catch(IndexOutOfBoundsException e) {
			throw new NoSiblingException(String.format(LocaleMessages.getInstance().getMessage(LocaleMessages.NO_SIBLING),t.getName(), i), e);
		}
		return sibling;
	}

	/**
	 * @return singleton instance of TagUtils
	 *
	 */
	public static TagUtils getInstance() {
		return myself;
	}
}
