/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.fields;

import com.itextpdf.forms.fields.PdfChoiceFormField;
import com.itextpdf.forms.fields.PdfFormAnnotation;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.fields.PdfTextFormField;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.Style;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.properties.Leading;
import com.itextpdf.layout.properties.TextAlignment;
import com.itextpdf.layout.properties.TransparentColor;
import com.itextpdf.layout.properties.VerticalAlignment;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class TextAndChoiceLegacyDrawer {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextAndChoiceLegacyDrawer.class);

    private TextAndChoiceLegacyDrawer() {
    }

    static boolean regenerateTextAndChoiceField(PdfFormAnnotation formAnnotation) {
        PdfArray matrix;
        double translationHeight;
        double translationWidth;
        String value = formAnnotation.parent.getDisplayValue();
        PdfName type = formAnnotation.parent.getFormType();
        PdfPage page = PdfAnnotation.makeAnnotation((PdfObject)formAnnotation.getPdfObject()).getPage();
        PdfArray bBox = formAnnotation.getPdfObject().getAsArray(PdfName.Rect);
        int pageRotation = 0;
        if (page != null) {
            pageRotation = page.getRotation();
            pageRotation *= -1;
        }
        if (pageRotation % 90 == 0) {
            double angle = pageRotation % 360;
            angle = TextAndChoiceLegacyDrawer.degreeToRadians(angle);
            Rectangle initialBboxRectangle = bBox.toRectangle();
            Rectangle rect = initialBboxRectangle.clone();
            translationWidth = 0.0;
            translationHeight = 0.0;
            if (angle >= -Math.PI && angle <= -1.5707963267948966) {
                translationWidth = rect.getWidth();
            }
            if (angle <= -Math.PI) {
                translationHeight = rect.getHeight();
            }
            matrix = new PdfArray(new double[]{Math.cos(angle), -Math.sin(angle), Math.sin(angle), Math.cos(angle), translationWidth, translationHeight});
            if (angle % 1.5707963267948966 == 0.0 && angle % Math.PI != 0.0) {
                rect.setWidth(initialBboxRectangle.getHeight());
                rect.setHeight(initialBboxRectangle.getWidth());
            }
            rect.setX(rect.getX() + (float)translationWidth);
            rect.setY(rect.getY() + (float)translationHeight);
            bBox = new PdfArray(rect);
        } else {
            LOGGER.error("Encountered a page rotation that was not a multiple of 90\u00b0/ (Pi/2) when generating default appearances for form fields");
            matrix = new PdfArray(new double[]{1.0, 0.0, 0.0, 1.0, 0.0, 0.0});
        }
        float fieldRotation = 0.0f;
        if (formAnnotation.getPdfObject().getAsDictionary(PdfName.MK) != null && formAnnotation.getPdfObject().getAsDictionary(PdfName.MK).get(PdfName.R) != null) {
            fieldRotation = formAnnotation.getPdfObject().getAsDictionary(PdfName.MK).getAsFloat(PdfName.R).floatValue();
            fieldRotation += (float)pageRotation;
        }
        if (fieldRotation % 90.0f == 0.0f) {
            Rectangle initialBboxRectangle = bBox.toRectangle();
            double angle = fieldRotation % 360.0f;
            angle = TextAndChoiceLegacyDrawer.degreeToRadians(angle);
            translationWidth = TextAndChoiceLegacyDrawer.calculateTranslationWidthAfterFieldRot(initialBboxRectangle, TextAndChoiceLegacyDrawer.degreeToRadians(pageRotation), angle);
            translationHeight = TextAndChoiceLegacyDrawer.calculateTranslationHeightAfterFieldRot(initialBboxRectangle, TextAndChoiceLegacyDrawer.degreeToRadians(pageRotation), angle);
            Matrix currentMatrix = new Matrix(matrix.getAsNumber(0).floatValue(), matrix.getAsNumber(1).floatValue(), matrix.getAsNumber(2).floatValue(), matrix.getAsNumber(3).floatValue(), matrix.getAsNumber(4).floatValue(), matrix.getAsNumber(5).floatValue());
            Matrix toConcatenate = new Matrix((float)Math.cos(angle), (float)(-Math.sin(angle)), (float)Math.sin(angle), (float)Math.cos(angle), (float)translationWidth, (float)translationHeight);
            currentMatrix = currentMatrix.multiply(toConcatenate);
            matrix = new PdfArray(new float[]{currentMatrix.get(0), currentMatrix.get(1), currentMatrix.get(3), currentMatrix.get(4), currentMatrix.get(6), currentMatrix.get(7)});
            Rectangle rect = initialBboxRectangle.clone();
            if (angle % 1.5707963267948966 == 0.0 && angle % Math.PI != 0.0) {
                rect.setWidth(initialBboxRectangle.getHeight());
                rect.setHeight(initialBboxRectangle.getWidth());
            }
            rect.setX(rect.getX() + (float)translationWidth);
            rect.setY(rect.getY() + (float)translationHeight);
            bBox = new PdfArray(rect);
        }
        Rectangle bboxRectangle = bBox.toRectangle();
        PdfFormXObject appearance = new PdfFormXObject(new Rectangle(0.0f, 0.0f, bboxRectangle.getWidth(), bboxRectangle.getHeight()));
        appearance.put(PdfName.Matrix, (PdfObject)matrix);
        if (PdfName.Tx.equals((Object)type)) {
            TextAndChoiceLegacyDrawer.drawCombTextAppearance(formAnnotation, bboxRectangle, formAnnotation.getFont(), formAnnotation.getFontSize(bBox, value), value, appearance);
        } else {
            int topIndex = 0;
            if (!formAnnotation.parent.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
                PdfNumber topIndexNum = formAnnotation.getParent().getAsNumber(PdfName.TI);
                PdfArray options = formAnnotation.parent.getOptions();
                if (null != options) {
                    topIndex = null != topIndexNum ? topIndexNum.intValue() : 0;
                    PdfArray visibleOptions = topIndex > 0 ? new PdfArray(options.subList(topIndex, options.size())) : (PdfArray)options.clone();
                    value = PdfFormField.optionsArrayToString(visibleOptions);
                }
            }
            TextAndChoiceLegacyDrawer.drawChoiceAppearance(formAnnotation, bboxRectangle, formAnnotation.getFontSize(bBox, value), value, appearance, topIndex);
        }
        PdfDictionary ap = new PdfDictionary();
        ap.put(PdfName.N, appearance.getPdfObject());
        ap.setModified();
        formAnnotation.put(PdfName.AP, (PdfObject)ap);
        return true;
    }

    static void drawChoiceAppearance(PdfFormAnnotation formAnnotation, Rectangle rect, float fontSize, String value, PdfFormXObject appearance, int topIndex) {
        Boolean isFull;
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(formAnnotation.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, formAnnotation.getDocument());
        float width = rect.getWidth();
        float height = rect.getHeight();
        float widthBorder = 6.0f;
        float heightBorder = 2.0f;
        formAnnotation.drawBorder(canvas, appearance, width, height);
        canvas.beginVariableText().saveState().rectangle(3.0, 3.0, (double)(width - widthBorder), (double)(height - heightBorder)).clip().endPath();
        Canvas modelCanvas = new Canvas(canvas, new Rectangle(3.0f, 0.0f, Math.max(0.0f, width - widthBorder), Math.max(0.0f, height - heightBorder)));
        modelCanvas.setProperty(82, (Object)Boolean.TRUE);
        PdfFormAnnotation.setMetaInfoToCanvas(modelCanvas);
        Div div = new Div();
        if (formAnnotation.parent.getFieldFlag(PdfChoiceFormField.FF_COMBO)) {
            div.setVerticalAlignment(VerticalAlignment.MIDDLE);
        }
        div.setHeight(Math.max(0.0f, height - heightBorder));
        List strings = formAnnotation.getFont().splitString(value, fontSize, width - widthBorder);
        for (int index = 0; index < strings.size() && !Boolean.TRUE.equals(isFull = modelCanvas.getRenderer().getPropertyAsBoolean(25)); ++index) {
            PdfArray indices;
            Paragraph paragraph = ((Paragraph)((Paragraph)((Paragraph)new Paragraph((String)strings.get(index)).setFont(formAnnotation.getFont())).setFontSize(fontSize)).setMargins(0.0f, 0.0f, 0.0f, 0.0f)).setMultipliedLeading(1.0f);
            paragraph.setProperty(26, (Object)Boolean.TRUE);
            paragraph.setTextAlignment(formAnnotation.parent.getJustification());
            if (formAnnotation.getColor() != null) {
                paragraph.setFontColor(formAnnotation.getColor());
            }
            if (!formAnnotation.parent.getFieldFlag(PdfChoiceFormField.FF_COMBO) && (indices = formAnnotation.getParent().getAsArray(PdfName.I)) != null && indices.size() > 0) {
                for (PdfObject ind : indices) {
                    if (!ind.isNumber() || ((PdfNumber)ind).getValue() != (double)(index + topIndex)) continue;
                    paragraph.setBackgroundColor((Color)new DeviceRgb(10, 36, 106));
                    paragraph.setFontColor(ColorConstants.LIGHT_GRAY);
                }
            }
            div.add((IBlockElement)paragraph);
        }
        modelCanvas.add((IBlockElement)div);
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    private static void drawCombTextAppearance(PdfFormAnnotation formAnnotation, Rectangle rect, PdfFont font, float fontSize, String value, PdfFormXObject appearance) {
        int start;
        PdfStream stream = (PdfStream)new PdfStream().makeIndirect(formAnnotation.getDocument());
        PdfResources resources = appearance.getResources();
        PdfCanvas canvas = new PdfCanvas(stream, resources, formAnnotation.getDocument());
        float height = rect.getHeight();
        float width = rect.getWidth();
        PdfFormXObject xObject = new PdfFormXObject(new Rectangle(0.0f, 0.0f, width, height));
        formAnnotation.drawBorder(canvas, xObject, width, height);
        if (formAnnotation.parent.isPassword()) {
            value = TextAndChoiceLegacyDrawer.obfuscatePassword(value);
        }
        canvas.beginVariableText().saveState().endPath();
        Canvas modelCanvas = new Canvas(canvas, new Rectangle(0.0f, -height, 0.0f, 2.0f * height));
        modelCanvas.setProperty(82, (Object)Boolean.TRUE);
        PdfFormAnnotation.setMetaInfoToCanvas(modelCanvas);
        Style paragraphStyle = (Style)((Style)new Style().setFont(font)).setFontSize(fontSize);
        paragraphStyle.setProperty(33, (Object)new Leading(2, 1.0f));
        if (formAnnotation.getColor() != null) {
            paragraphStyle.setProperty(21, (Object)new TransparentColor(formAnnotation.getColor()));
        }
        int maxLen = new PdfTextFormField(formAnnotation.parent.getPdfObject()).getMaxLen();
        float widthPerCharacter = width / (float)maxLen;
        int numberOfCharacters = Math.min(maxLen, value.length());
        TextAlignment textAlignment = formAnnotation.parent.getJustification() == null ? TextAlignment.LEFT : formAnnotation.parent.getJustification();
        switch (textAlignment) {
            case RIGHT: {
                start = maxLen - numberOfCharacters;
                break;
            }
            case CENTER: {
                start = (maxLen - numberOfCharacters) / 2;
                break;
            }
            default: {
                start = 0;
            }
        }
        float startOffset = widthPerCharacter * ((float)start + 0.5f);
        for (int i = 0; i < numberOfCharacters; ++i) {
            modelCanvas.showTextAligned((Paragraph)new Paragraph(value.substring(i, i + 1)).addStyle(paragraphStyle), startOffset + widthPerCharacter * (float)i, rect.getHeight() / 2.0f, TextAlignment.CENTER, VerticalAlignment.MIDDLE);
        }
        canvas.restoreState().endVariableText();
        ((PdfStream)appearance.getPdfObject()).setData(stream.getBytes());
    }

    private static String obfuscatePassword(String text) {
        char[] pchar = new char[text.length()];
        for (int i = 0; i < text.length(); ++i) {
            pchar[i] = 42;
        }
        return new String(pchar);
    }

    private static float calculateTranslationHeightAfterFieldRot(Rectangle bBox, double pageRotation, double relFieldRotation) {
        if (relFieldRotation == 0.0) {
            return 0.0f;
        }
        if (pageRotation == 0.0) {
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == Math.PI) {
                return bBox.getHeight();
            }
        }
        if (pageRotation == -1.5707963267948966) {
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getWidth() - bBox.getHeight();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == Math.PI) {
                return bBox.getWidth();
            }
        }
        if (pageRotation == -Math.PI) {
            if (relFieldRotation == -Math.PI) {
                return bBox.getHeight();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getHeight() - bBox.getWidth();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return bBox.getWidth();
            }
        }
        if (pageRotation == -4.71238898038469) {
            if (relFieldRotation == -4.71238898038469) {
                return bBox.getWidth();
            }
            if (relFieldRotation == -Math.PI) {
                return bBox.getWidth();
            }
        }
        return 0.0f;
    }

    private static float calculateTranslationWidthAfterFieldRot(Rectangle bBox, double pageRotation, double relFieldRotation) {
        if (relFieldRotation == 0.0) {
            return 0.0f;
        }
        if (pageRotation == 0.0 && (relFieldRotation == Math.PI || relFieldRotation == 4.71238898038469)) {
            return bBox.getWidth();
        }
        if (pageRotation == -1.5707963267948966 && (relFieldRotation == -1.5707963267948966 || relFieldRotation == Math.PI)) {
            return bBox.getHeight();
        }
        if (pageRotation == -Math.PI) {
            if (relFieldRotation == -Math.PI) {
                return bBox.getWidth();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getHeight();
            }
            if (relFieldRotation == 1.5707963267948966) {
                return -1.0f * (bBox.getHeight() - bBox.getWidth());
            }
        }
        if (pageRotation == -4.71238898038469) {
            if (relFieldRotation == -4.71238898038469) {
                return -1.0f * (bBox.getWidth() - bBox.getHeight());
            }
            if (relFieldRotation == -Math.PI) {
                return bBox.getHeight();
            }
            if (relFieldRotation == -1.5707963267948966) {
                return bBox.getWidth();
            }
        }
        return 0.0f;
    }

    private static double degreeToRadians(double angle) {
        return Math.PI * angle / 180.0;
    }
}

