/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.form.renderer;

import com.itextpdf.forms.form.element.IFormField;
import com.itextpdf.forms.form.renderer.AbstractTextFieldRenderer;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import java.util.List;

public abstract class AbstractOneLineTextFieldRenderer
extends AbstractTextFieldRenderer {
    AbstractOneLineTextFieldRenderer(IFormField modelElement) {
        super(modelElement);
    }

    void cropContentLines(List<LineRenderer> lines, Rectangle bBox) {
        this.adjustNumberOfContentLines(lines, bBox, 1);
        this.updateParagraphHeight();
    }

    private void updateParagraphHeight() {
        Float height = this.retrieveHeight();
        Float minHeight = this.retrieveMinHeight();
        Float maxHeight = this.retrieveMaxHeight();
        float originalHeight = this.flatRenderer.getOccupiedArea().getBBox().getHeight();
        if (height != null && height.floatValue() > 0.0f) {
            this.setContentHeight(this.flatRenderer, height.floatValue());
        } else if (minHeight != null && minHeight.floatValue() > originalHeight) {
            this.setContentHeight(this.flatRenderer, minHeight.floatValue());
        } else if (maxHeight != null && maxHeight.floatValue() > 0.0f && maxHeight.floatValue() < originalHeight) {
            this.setContentHeight(this.flatRenderer, maxHeight.floatValue());
        }
    }

    void setContentHeight(IRenderer flatRenderer, float height) {
        Rectangle bBox = flatRenderer.getOccupiedArea().getBBox();
        float dy = (height - bBox.getHeight()) / 2.0f;
        bBox.moveDown(dy);
        bBox.setHeight(height);
        flatRenderer.move(0.0f, -dy);
    }
}

