/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.property.HorizontalAlignment;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.styledxmlparser.css.util.CssDimensionParsingUtils;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MarginApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(MarginApplierUtil.class);

    private MarginApplierUtil() {
    }

    public static void applyMargins(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        MarginApplierUtil.applyMargins(cssProps, context, element, 0.0f, 0.0f);
    }

    public static void applyMargins(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element, float baseValueVertical, float baseValueHorizontal) {
        boolean isRightAuto;
        String marginTop = cssProps.get("margin-top");
        String marginBottom = cssProps.get("margin-bottom");
        String marginLeft = cssProps.get("margin-left");
        String marginRight = cssProps.get("margin-right");
        boolean isBlock = element instanceof IBlockElement || "block".equals(cssProps.get("display"));
        boolean isImage = element instanceof Image;
        float em = CssDimensionParsingUtils.parseAbsoluteLength((String)cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        if (isBlock || isImage) {
            MarginApplierUtil.trySetMarginIfNotAuto(46, marginTop, element, em, rem, baseValueVertical);
            MarginApplierUtil.trySetMarginIfNotAuto(43, marginBottom, element, em, rem, baseValueVertical);
        }
        boolean isLeftAuto = !MarginApplierUtil.trySetMarginIfNotAuto(44, marginLeft, element, em, rem, baseValueHorizontal);
        boolean bl = isRightAuto = !MarginApplierUtil.trySetMarginIfNotAuto(45, marginRight, element, em, rem, baseValueHorizontal);
        if (isBlock) {
            if (isLeftAuto && isRightAuto) {
                element.setProperty(28, (Object)HorizontalAlignment.CENTER);
            } else if (isLeftAuto) {
                element.setProperty(28, (Object)HorizontalAlignment.RIGHT);
            } else if (isRightAuto) {
                element.setProperty(28, (Object)HorizontalAlignment.LEFT);
            }
        }
    }

    private static boolean trySetMarginIfNotAuto(int marginProperty, String marginValue, IPropertyContainer element, float em, float rem, float baseValue) {
        boolean isAuto = "auto".equals(marginValue);
        if (isAuto) {
            return false;
        }
        Float marginVal = MarginApplierUtil.parseMarginValue(marginValue, em, rem, baseValue);
        if (marginVal != null) {
            element.setProperty(marginProperty, (Object)UnitValue.createPointValue((float)marginVal.floatValue()));
        }
        return true;
    }

    private static Float parseMarginValue(String marginValString, float em, float rem, float baseValue) {
        UnitValue marginUnitVal = CssDimensionParsingUtils.parseLengthValueToPt((String)marginValString, (float)em, (float)rem);
        if (marginUnitVal != null) {
            if (!marginUnitVal.isPointValue()) {
                if (baseValue != 0.0f) {
                    return new Float((double)(baseValue * marginUnitVal.getValue()) * 0.01);
                }
                logger.error("Margin value in percents not supported");
                return null;
            }
            return Float.valueOf(marginUnitVal.getValue());
        }
        return null;
    }
}

