/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.forms.util.DrawingUtil;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.Radio;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractFormFieldRenderer;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.properties.HorizontalAlignment;
import com.itextpdf.layout.properties.UnitValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;

public class RadioRenderer
extends AbstractFormFieldRenderer {
    private static final Color DEFAULT_CHECKED_COLOR = ColorConstants.BLACK;
    private static final Color DEFAULT_COLOR = ColorConstants.LIGHT_GRAY;
    private static final float DEFAULT_SIZE = 8.25f;
    private static final HorizontalAlignment DEFAULT_HORIZONTAL_ALIGNMENT = HorizontalAlignment.CENTER;
    private static final VerticalAlignment DEFAULT_VERTICAL_ALIGNMENT = VerticalAlignment.MIDDLE;

    public RadioRenderer(Radio modelElement) {
        super(modelElement);
        this.setProperty(75, VerticalAlignment.MIDDLE);
    }

    public IRenderer getNextRenderer() {
        return new RadioRenderer((Radio)this.modelElement);
    }

    @Override
    protected IRenderer createFlatRenderer() {
        UnitValue heightUV = this.getPropertyAsUnitValue(27);
        UnitValue widthUV = this.getPropertyAsUnitValue(77);
        float height = null == heightUV ? 8.25f : heightUV.getValue();
        float width = null == widthUV ? 8.25f : widthUV.getValue();
        float size = Math.min(height, width);
        Paragraph paragraph = (Paragraph)((Paragraph)((Paragraph)((Paragraph)new Paragraph().setWidth(size)).setHeight(size)).setHorizontalAlignment(DEFAULT_HORIZONTAL_ALIGNMENT)).setVerticalAlignment(DEFAULT_VERTICAL_ALIGNMENT);
        return new FlatParagraphRenderer(paragraph);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        this.setProperty(6, null);
    }

    public boolean isBoxChecked() {
        return null != this.getProperty(0x100009);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        PdfDocument doc = drawContext.getDocument();
        PdfAcroForm form = PdfAcroForm.getAcroForm((PdfDocument)doc, (boolean)true);
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        String groupName = (String)this.getProperty(0x100005);
        PdfButtonFormField radioGroup = (PdfButtonFormField)form.getField(groupName);
        boolean addNew = false;
        if (null == radioGroup) {
            radioGroup = PdfFormField.createRadioGroup((PdfDocument)doc, (String)groupName, (String)"on");
            addNew = true;
        }
        if (this.isBoxChecked()) {
            radioGroup.setValue(this.getModelId());
        }
        PdfFormField radio = PdfFormField.createRadioButton((PdfDocument)doc, (Rectangle)area, (PdfButtonFormField)radioGroup, (String)this.getModelId());
        radio.setCheckType(2);
        if (addNew) {
            form.addField((PdfFormField)radioGroup, page);
        } else {
            form.replaceField(this.getModelId(), (PdfFormField)radioGroup);
        }
        this.writeAcroFormFieldLangAttribute(doc);
    }

    @Override
    protected boolean isLayoutBasedOnFlatRenderer() {
        return false;
    }

    private class FlatParagraphRenderer
    extends ParagraphRenderer {
        public FlatParagraphRenderer(Paragraph modelElement) {
            super(modelElement);
        }

        public void drawChildren(DrawContext drawContext) {
            PdfCanvas canvas = drawContext.getCanvas();
            Rectangle rectangle = RadioRenderer.this.flatRenderer.getOccupiedArea().getBBox();
            float radius = Math.min(rectangle.getWidth(), rectangle.getHeight()) / 2.0f;
            canvas.saveState();
            canvas.setFillColor(DEFAULT_COLOR);
            DrawingUtil.drawCircle((PdfCanvas)canvas, (float)(rectangle.getLeft() + radius), (float)(rectangle.getBottom() + radius), (float)radius);
            if (RadioRenderer.this.isBoxChecked()) {
                canvas.setFillColor(DEFAULT_CHECKED_COLOR);
                DrawingUtil.drawCircle((PdfCanvas)canvas, (float)(rectangle.getLeft() + radius), (float)(rectangle.getBottom() + radius), (float)(radius / 2.0f));
            }
            canvas.restoreState();
        }
    }
}

