/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.image;

import com.itextpdf.io.IOException;
import com.itextpdf.io.font.PdfEncodings;
import com.itextpdf.io.image.BmpImageData;
import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageType;
import com.itextpdf.io.image.RawImageHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

final class BmpImageHelper {
    private static final int VERSION_2_1_BIT = 0;
    private static final int VERSION_2_4_BIT = 1;
    private static final int VERSION_2_8_BIT = 2;
    private static final int VERSION_2_24_BIT = 3;
    private static final int VERSION_3_1_BIT = 4;
    private static final int VERSION_3_4_BIT = 5;
    private static final int VERSION_3_8_BIT = 6;
    private static final int VERSION_3_24_BIT = 7;
    private static final int VERSION_3_NT_16_BIT = 8;
    private static final int VERSION_3_NT_32_BIT = 9;
    private static final int VERSION_4_1_BIT = 10;
    private static final int VERSION_4_4_BIT = 11;
    private static final int VERSION_4_8_BIT = 12;
    private static final int VERSION_4_16_BIT = 13;
    private static final int VERSION_4_24_BIT = 14;
    private static final int VERSION_4_32_BIT = 15;
    private static final int LCS_CALIBRATED_RGB = 0;
    private static final int LCS_SRGB = 1;
    private static final int LCS_CMYK = 2;
    private static final int BI_RGB = 0;
    private static final int BI_RLE8 = 1;
    private static final int BI_RLE4 = 2;
    private static final int BI_BITFIELDS = 3;

    BmpImageHelper() {
    }

    public static void processImage(ImageData image) {
        BmpParameters bmp;
        if (image.getOriginalType() != ImageType.BMP) {
            throw new IllegalArgumentException("BMP image expected");
        }
        try {
            if (image.getData() == null) {
                image.loadData();
            }
            ByteArrayInputStream bmpStream = new ByteArrayInputStream(image.getData());
            image.imageSize = image.getData().length;
            bmp = new BmpParameters((BmpImageData)image);
            BmpImageHelper.process(bmp, bmpStream);
            if (BmpImageHelper.getImage(bmp)) {
                image.setWidth(bmp.width);
                image.setHeight(bmp.height);
                image.setDpi((int)((double)bmp.xPelsPerMeter * 0.0254 + 0.5), (int)((double)bmp.yPelsPerMeter * 0.0254 + 0.5));
            }
        }
        catch (java.io.IOException e) {
            throw new IOException("bmp.image.exception", e);
        }
        RawImageHelper.updateImageAttributes(bmp.image, bmp.additional);
    }

    private static void process(BmpParameters bmp, InputStream stream) throws java.io.IOException {
        block90: {
            long colorsUsed;
            long size;
            block91: {
                block89: {
                    bmp.inputStream = stream;
                    if (!bmp.image.isNoHeader()) {
                        if (BmpImageHelper.readUnsignedByte(bmp.inputStream) != 66 || BmpImageHelper.readUnsignedByte(bmp.inputStream) != 77) {
                            throw new IOException("invalid.magic.value.for.bmp.file");
                        }
                        bmp.bitmapFileSize = BmpImageHelper.readDWord(bmp.inputStream);
                        BmpImageHelper.readWord(bmp.inputStream);
                        BmpImageHelper.readWord(bmp.inputStream);
                        bmp.bitmapOffset = BmpImageHelper.readDWord(bmp.inputStream);
                    }
                    if ((size = BmpImageHelper.readDWord(bmp.inputStream)) == 12L) {
                        bmp.width = BmpImageHelper.readWord(bmp.inputStream);
                        bmp.height = BmpImageHelper.readWord(bmp.inputStream);
                    } else {
                        bmp.width = BmpImageHelper.readLong(bmp.inputStream);
                        bmp.height = BmpImageHelper.readLong(bmp.inputStream);
                    }
                    int planes = BmpImageHelper.readWord(bmp.inputStream);
                    bmp.bitsPerPixel = BmpImageHelper.readWord(bmp.inputStream);
                    bmp.properties.put("color_planes", planes);
                    bmp.properties.put("bits_per_pixel", bmp.bitsPerPixel);
                    bmp.numBands = 3;
                    if (bmp.bitmapOffset == 0L) {
                        bmp.bitmapOffset = size;
                    }
                    if (size != 12L) break block89;
                    bmp.properties.put("bmp_version", "BMP v. 2.x");
                    if (bmp.bitsPerPixel == 1) {
                        bmp.imageType = 0;
                    } else if (bmp.bitsPerPixel == 4) {
                        bmp.imageType = 1;
                    } else if (bmp.bitsPerPixel == 8) {
                        bmp.imageType = 2;
                    } else if (bmp.bitsPerPixel == 24) {
                        bmp.imageType = 3;
                    }
                    int numberOfEntries = (int)((bmp.bitmapOffset - 14L - size) / 3L);
                    int sizeOfPalette = numberOfEntries * 3;
                    if (bmp.bitmapOffset == size) {
                        switch (bmp.imageType) {
                            case 0: {
                                sizeOfPalette = 6;
                                break;
                            }
                            case 1: {
                                sizeOfPalette = 48;
                                break;
                            }
                            case 2: {
                                sizeOfPalette = 768;
                                break;
                            }
                            case 3: {
                                sizeOfPalette = 0;
                            }
                        }
                        bmp.bitmapOffset = size + (long)sizeOfPalette;
                    }
                    BmpImageHelper.readPalette(sizeOfPalette, bmp);
                    break block90;
                }
                bmp.compression = BmpImageHelper.readDWord(bmp.inputStream);
                bmp.imageSize = BmpImageHelper.readDWord(bmp.inputStream);
                bmp.xPelsPerMeter = BmpImageHelper.readLong(bmp.inputStream);
                bmp.yPelsPerMeter = BmpImageHelper.readLong(bmp.inputStream);
                colorsUsed = BmpImageHelper.readDWord(bmp.inputStream);
                long colorsImportant = BmpImageHelper.readDWord(bmp.inputStream);
                switch ((int)bmp.compression) {
                    case 0: {
                        bmp.properties.put("compression", "BI_RGB");
                        break;
                    }
                    case 1: {
                        bmp.properties.put("compression", "BI_RLE8");
                        break;
                    }
                    case 2: {
                        bmp.properties.put("compression", "BI_RLE4");
                        break;
                    }
                    case 3: {
                        bmp.properties.put("compression", "BI_BITFIELDS");
                    }
                }
                bmp.properties.put("x_pixels_per_meter", bmp.xPelsPerMeter);
                bmp.properties.put("y_pixels_per_meter", bmp.yPelsPerMeter);
                bmp.properties.put("colors_used", colorsUsed);
                bmp.properties.put("colors_important", colorsImportant);
                if (size != 40L && size != 52L && size != 56L) break block91;
                switch ((int)bmp.compression) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (bmp.bitsPerPixel == 1) {
                            bmp.imageType = 4;
                        } else if (bmp.bitsPerPixel == 4) {
                            bmp.imageType = 5;
                        } else if (bmp.bitsPerPixel == 8) {
                            bmp.imageType = 6;
                        } else if (bmp.bitsPerPixel == 24) {
                            bmp.imageType = 7;
                        } else if (bmp.bitsPerPixel == 16) {
                            bmp.imageType = 8;
                            bmp.redMask = 31744;
                            bmp.greenMask = 992;
                            bmp.blueMask = 31;
                            bmp.properties.put("red_mask", bmp.redMask);
                            bmp.properties.put("green_mask", bmp.greenMask);
                            bmp.properties.put("blue_mask", bmp.blueMask);
                        } else if (bmp.bitsPerPixel == 32) {
                            bmp.imageType = 9;
                            bmp.redMask = 0xFF0000;
                            bmp.greenMask = 65280;
                            bmp.blueMask = 255;
                            bmp.properties.put("red_mask", bmp.redMask);
                            bmp.properties.put("green_mask", bmp.greenMask);
                            bmp.properties.put("blue_mask", bmp.blueMask);
                        }
                        if (size >= 52L) {
                            bmp.redMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                            bmp.greenMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                            bmp.blueMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                            bmp.properties.put("red_mask", bmp.redMask);
                            bmp.properties.put("green_mask", bmp.greenMask);
                            bmp.properties.put("blue_mask", bmp.blueMask);
                        }
                        if (size == 56L) {
                            bmp.alphaMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                            bmp.properties.put("alpha_mask", bmp.alphaMask);
                        }
                        int numberOfEntries = (int)((bmp.bitmapOffset - 14L - size) / 4L);
                        int sizeOfPalette = numberOfEntries * 4;
                        if (bmp.bitmapOffset == size) {
                            switch (bmp.imageType) {
                                case 4: {
                                    sizeOfPalette = (int)(colorsUsed == 0L ? 2L : colorsUsed) * 4;
                                    break;
                                }
                                case 5: {
                                    sizeOfPalette = (int)(colorsUsed == 0L ? 16L : colorsUsed) * 4;
                                    break;
                                }
                                case 6: {
                                    sizeOfPalette = (int)(colorsUsed == 0L ? 256L : colorsUsed) * 4;
                                    break;
                                }
                                default: {
                                    sizeOfPalette = 0;
                                }
                            }
                            bmp.bitmapOffset = size + (long)sizeOfPalette;
                        }
                        BmpImageHelper.readPalette(sizeOfPalette, bmp);
                        bmp.properties.put("bmp_version", "BMP v. 3.x");
                        break block90;
                    }
                    case 3: {
                        if (bmp.bitsPerPixel == 16) {
                            bmp.imageType = 8;
                        } else if (bmp.bitsPerPixel == 32) {
                            bmp.imageType = 9;
                        }
                        bmp.redMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                        bmp.greenMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                        bmp.blueMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                        if (size == 56L) {
                            bmp.alphaMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                            bmp.properties.put("alpha_mask", bmp.alphaMask);
                        }
                        bmp.properties.put("red_mask", bmp.redMask);
                        bmp.properties.put("green_mask", bmp.greenMask);
                        bmp.properties.put("blue_mask", bmp.blueMask);
                        if (colorsUsed != 0L) {
                            int sizeOfPalette = (int)colorsUsed * 4;
                            BmpImageHelper.readPalette(sizeOfPalette, bmp);
                        }
                        bmp.properties.put("bmp_version", "BMP v. 3.x NT");
                        break block90;
                    }
                    default: {
                        throw new IOException("invalid.bmp.file.compression");
                    }
                }
            }
            if (size == 108L) {
                bmp.properties.put("bmp_version", "BMP v. 4.x");
                bmp.redMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                bmp.greenMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                bmp.blueMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                bmp.alphaMask = (int)BmpImageHelper.readDWord(bmp.inputStream);
                long csType = BmpImageHelper.readDWord(bmp.inputStream);
                int redX = BmpImageHelper.readLong(bmp.inputStream);
                int redY = BmpImageHelper.readLong(bmp.inputStream);
                int redZ = BmpImageHelper.readLong(bmp.inputStream);
                int greenX = BmpImageHelper.readLong(bmp.inputStream);
                int greenY = BmpImageHelper.readLong(bmp.inputStream);
                int greenZ = BmpImageHelper.readLong(bmp.inputStream);
                int blueX = BmpImageHelper.readLong(bmp.inputStream);
                int blueY = BmpImageHelper.readLong(bmp.inputStream);
                int blueZ = BmpImageHelper.readLong(bmp.inputStream);
                long gammaRed = BmpImageHelper.readDWord(bmp.inputStream);
                long gammaGreen = BmpImageHelper.readDWord(bmp.inputStream);
                long gammaBlue = BmpImageHelper.readDWord(bmp.inputStream);
                if (bmp.bitsPerPixel == 1) {
                    bmp.imageType = 10;
                } else if (bmp.bitsPerPixel == 4) {
                    bmp.imageType = 11;
                } else if (bmp.bitsPerPixel == 8) {
                    bmp.imageType = 12;
                } else if (bmp.bitsPerPixel == 16) {
                    bmp.imageType = 13;
                    if ((int)bmp.compression == 0) {
                        bmp.redMask = 31744;
                        bmp.greenMask = 992;
                        bmp.blueMask = 31;
                    }
                } else if (bmp.bitsPerPixel == 24) {
                    bmp.imageType = 14;
                } else if (bmp.bitsPerPixel == 32) {
                    bmp.imageType = 15;
                    if ((int)bmp.compression == 0) {
                        bmp.redMask = 0xFF0000;
                        bmp.greenMask = 65280;
                        bmp.blueMask = 255;
                    }
                }
                bmp.properties.put("red_mask", bmp.redMask);
                bmp.properties.put("green_mask", bmp.greenMask);
                bmp.properties.put("blue_mask", bmp.blueMask);
                bmp.properties.put("alpha_mask", bmp.alphaMask);
                int numberOfEntries = (int)((bmp.bitmapOffset - 14L - size) / 4L);
                int sizeOfPalette = numberOfEntries * 4;
                if (bmp.bitmapOffset == size) {
                    switch (bmp.imageType) {
                        case 10: {
                            sizeOfPalette = (int)(colorsUsed == 0L ? 2L : colorsUsed) * 4;
                            break;
                        }
                        case 11: {
                            sizeOfPalette = (int)(colorsUsed == 0L ? 16L : colorsUsed) * 4;
                            break;
                        }
                        case 12: {
                            sizeOfPalette = (int)(colorsUsed == 0L ? 256L : colorsUsed) * 4;
                            break;
                        }
                        default: {
                            sizeOfPalette = 0;
                        }
                    }
                    bmp.bitmapOffset = size + (long)sizeOfPalette;
                }
                BmpImageHelper.readPalette(sizeOfPalette, bmp);
                switch ((int)csType) {
                    case 0: {
                        bmp.properties.put("color_space", "LCS_CALIBRATED_RGB");
                        bmp.properties.put("redX", redX);
                        bmp.properties.put("redY", redY);
                        bmp.properties.put("redZ", redZ);
                        bmp.properties.put("greenX", greenX);
                        bmp.properties.put("greenY", greenY);
                        bmp.properties.put("greenZ", greenZ);
                        bmp.properties.put("blueX", blueX);
                        bmp.properties.put("blueY", blueY);
                        bmp.properties.put("blueZ", blueZ);
                        bmp.properties.put("gamma_red", gammaRed);
                        bmp.properties.put("gamma_green", gammaGreen);
                        bmp.properties.put("gamma_blue", gammaBlue);
                        throw new RuntimeException("Not implemented yet.");
                    }
                    case 1: {
                        bmp.properties.put("color_space", "LCS_sRGB");
                        break;
                    }
                    case 2: {
                        bmp.properties.put("color_space", "LCS_CMYK");
                        throw new RuntimeException("Not implemented yet.");
                    }
                }
            } else {
                bmp.properties.put("bmp_version", "BMP v. 5.x");
                throw new RuntimeException("Not implemented yet.");
            }
        }
        if (bmp.height > 0) {
            bmp.isBottomUp = true;
        } else {
            bmp.isBottomUp = false;
            bmp.height = Math.abs(bmp.height);
        }
        if (bmp.bitsPerPixel == 1 || bmp.bitsPerPixel == 4 || bmp.bitsPerPixel == 8) {
            int i;
            bmp.numBands = 1;
            if (bmp.imageType == 0 || bmp.imageType == 1 || bmp.imageType == 2) {
                int sizep = bmp.palette.length / 3;
                if (sizep > 256) {
                    sizep = 256;
                }
                byte[] r = new byte[sizep];
                byte[] g = new byte[sizep];
                byte[] b = new byte[sizep];
                for (i = 0; i < sizep; ++i) {
                    int off = 3 * i;
                    b[i] = bmp.palette[off];
                    g[i] = bmp.palette[off + 1];
                    r[i] = bmp.palette[off + 2];
                }
            } else {
                int sizep = bmp.palette.length / 4;
                if (sizep > 256) {
                    sizep = 256;
                }
                byte[] r = new byte[sizep];
                byte[] g = new byte[sizep];
                byte[] b = new byte[sizep];
                for (i = 0; i < sizep; ++i) {
                    int off = 4 * i;
                    b[i] = bmp.palette[off];
                    g[i] = bmp.palette[off + 1];
                    r[i] = bmp.palette[off + 2];
                }
            }
        } else {
            bmp.numBands = bmp.bitsPerPixel == 16 ? 3 : (bmp.bitsPerPixel == 32 ? (bmp.alphaMask == 0 ? 3 : 4) : 3);
        }
    }

    private static byte[] getPalette(int group, BmpParameters bmp) {
        if (bmp.palette == null) {
            return null;
        }
        byte[] np = new byte[bmp.palette.length / group * 3];
        int e = bmp.palette.length / group;
        for (int k = 0; k < e; ++k) {
            int src = k * group;
            int dest = k * 3;
            np[dest + 2] = bmp.palette[src++];
            np[dest + 1] = bmp.palette[src++];
            np[dest] = bmp.palette[src];
        }
        return np;
    }

    private static boolean getImage(BmpParameters bmp) throws java.io.IOException {
        switch (bmp.imageType) {
            case 0: {
                BmpImageHelper.read1Bit(3, bmp);
                return true;
            }
            case 1: {
                BmpImageHelper.read4Bit(3, bmp);
                return true;
            }
            case 2: {
                BmpImageHelper.read8Bit(3, bmp);
                return true;
            }
            case 3: {
                byte[] bdata = new byte[bmp.width * bmp.height * 3];
                BmpImageHelper.read24Bit(bdata, bmp);
                RawImageHelper.updateRawImageParameters(bmp.image, bmp.width, bmp.height, 3, 8, bdata);
                return true;
            }
            case 4: {
                BmpImageHelper.read1Bit(4, bmp);
                return true;
            }
            case 5: {
                switch ((int)bmp.compression) {
                    case 0: {
                        BmpImageHelper.read4Bit(4, bmp);
                        break;
                    }
                    case 2: {
                        BmpImageHelper.readRLE4(bmp);
                        break;
                    }
                    default: {
                        throw new IOException("invalid.bmp.file.compression");
                    }
                }
                return true;
            }
            case 6: {
                switch ((int)bmp.compression) {
                    case 0: {
                        BmpImageHelper.read8Bit(4, bmp);
                        break;
                    }
                    case 1: {
                        BmpImageHelper.readRLE8(bmp);
                        break;
                    }
                    default: {
                        throw new IOException("invalid.bmp.file.compression");
                    }
                }
                return true;
            }
            case 7: {
                byte[] bdata = new byte[bmp.width * bmp.height * 3];
                BmpImageHelper.read24Bit(bdata, bmp);
                RawImageHelper.updateRawImageParameters(bmp.image, bmp.width, bmp.height, 3, 8, bdata);
                return true;
            }
            case 8: {
                BmpImageHelper.read1632Bit(false, bmp);
                return true;
            }
            case 9: {
                BmpImageHelper.read1632Bit(true, bmp);
                return true;
            }
            case 10: {
                BmpImageHelper.read1Bit(4, bmp);
                return true;
            }
            case 11: {
                switch ((int)bmp.compression) {
                    case 0: {
                        BmpImageHelper.read4Bit(4, bmp);
                        break;
                    }
                    case 2: {
                        BmpImageHelper.readRLE4(bmp);
                        break;
                    }
                    default: {
                        throw new IOException("invalid.bmp.file.compression");
                    }
                }
                return true;
            }
            case 12: {
                switch ((int)bmp.compression) {
                    case 0: {
                        BmpImageHelper.read8Bit(4, bmp);
                        break;
                    }
                    case 1: {
                        BmpImageHelper.readRLE8(bmp);
                        break;
                    }
                    default: {
                        throw new IOException("invalid.bmp.file.compression");
                    }
                }
                return true;
            }
            case 13: {
                BmpImageHelper.read1632Bit(false, bmp);
                return true;
            }
            case 14: {
                byte[] bdata = new byte[bmp.width * bmp.height * 3];
                BmpImageHelper.read24Bit(bdata, bmp);
                RawImageHelper.updateRawImageParameters(bmp.image, bmp.width, bmp.height, 3, 8, bdata);
                return true;
            }
            case 15: {
                BmpImageHelper.read1632Bit(true, bmp);
                return true;
            }
        }
        return false;
    }

    private static void indexedModel(byte[] bdata, int bpc, int paletteEntries, BmpParameters bmp) {
        RawImageHelper.updateRawImageParameters(bmp.image, bmp.width, bmp.height, 1, bpc, bdata);
        Object[] colorSpace = new Object[4];
        colorSpace[0] = "/Indexed";
        colorSpace[1] = "/DeviceRGB";
        byte[] np = BmpImageHelper.getPalette(paletteEntries, bmp);
        int len = np.length;
        colorSpace[2] = len / 3 - 1;
        colorSpace[3] = PdfEncodings.convertToString(np, null);
        bmp.additional = new HashMap<String, Object>();
        bmp.additional.put("ColorSpace", colorSpace);
    }

    private static void readPalette(int sizeOfPalette, BmpParameters bmp) throws java.io.IOException {
        int r;
        if (sizeOfPalette == 0) {
            return;
        }
        bmp.palette = new byte[sizeOfPalette];
        for (int bytesRead = 0; bytesRead < sizeOfPalette; bytesRead += r) {
            r = bmp.inputStream.read(bmp.palette, bytesRead, sizeOfPalette - bytesRead);
            if (r >= 0) continue;
            throw new IOException("incomplete.palette");
        }
        bmp.properties.put("palette", bmp.palette);
    }

    private static void read1Bit(int paletteEntries, BmpParameters bmp) throws java.io.IOException {
        byte[] bdata = new byte[(bmp.width + 7) / 8 * bmp.height];
        int padding = 0;
        int bytesPerScanline = (int)Math.ceil((double)bmp.width / 8.0);
        int remainder = bytesPerScanline % 4;
        if (remainder != 0) {
            padding = 4 - remainder;
        }
        int imSize = (bytesPerScanline + padding) * bmp.height;
        byte[] values = new byte[imSize];
        for (int bytesRead = 0; bytesRead < imSize; bytesRead += bmp.inputStream.read(values, bytesRead, imSize - bytesRead)) {
        }
        if (bmp.isBottomUp) {
            for (int i = 0; i < bmp.height; ++i) {
                System.arraycopy(values, imSize - (i + 1) * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
            }
        } else {
            for (int i = 0; i < bmp.height; ++i) {
                System.arraycopy(values, i * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
            }
        }
        BmpImageHelper.indexedModel(bdata, 1, paletteEntries, bmp);
    }

    private static void read4Bit(int paletteEntries, BmpParameters bmp) throws java.io.IOException {
        byte[] bdata = new byte[(bmp.width + 1) / 2 * bmp.height];
        int padding = 0;
        int bytesPerScanline = (int)Math.ceil((double)bmp.width / 2.0);
        int remainder = bytesPerScanline % 4;
        if (remainder != 0) {
            padding = 4 - remainder;
        }
        int imSize = (bytesPerScanline + padding) * bmp.height;
        byte[] values = new byte[imSize];
        for (int bytesRead = 0; bytesRead < imSize; bytesRead += bmp.inputStream.read(values, bytesRead, imSize - bytesRead)) {
        }
        if (bmp.isBottomUp) {
            for (int i = 0; i < bmp.height; ++i) {
                System.arraycopy(values, imSize - (i + 1) * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
            }
        } else {
            for (int i = 0; i < bmp.height; ++i) {
                System.arraycopy(values, i * (bytesPerScanline + padding), bdata, i * bytesPerScanline, bytesPerScanline);
            }
        }
        BmpImageHelper.indexedModel(bdata, 4, paletteEntries, bmp);
    }

    private static void read8Bit(int paletteEntries, BmpParameters bmp) throws java.io.IOException {
        byte[] bdata = new byte[bmp.width * bmp.height];
        int padding = 0;
        int bitsPerScanline = bmp.width * 8;
        if (bitsPerScanline % 32 != 0) {
            padding = (bitsPerScanline / 32 + 1) * 32 - bitsPerScanline;
            padding = (int)Math.ceil((double)padding / 8.0);
        }
        int imSize = (bmp.width + padding) * bmp.height;
        byte[] values = new byte[imSize];
        for (int bytesRead = 0; bytesRead < imSize; bytesRead += bmp.inputStream.read(values, bytesRead, imSize - bytesRead)) {
        }
        if (bmp.isBottomUp) {
            for (int i = 0; i < bmp.height; ++i) {
                System.arraycopy(values, imSize - (i + 1) * (bmp.width + padding), bdata, i * bmp.width, bmp.width);
            }
        } else {
            for (int i = 0; i < bmp.height; ++i) {
                System.arraycopy(values, i * (bmp.width + padding), bdata, i * bmp.width, bmp.width);
            }
        }
        BmpImageHelper.indexedModel(bdata, 8, paletteEntries, bmp);
    }

    private static void read24Bit(byte[] bdata, BmpParameters bmp) throws java.io.IOException {
        int r;
        int padding = 0;
        int bitsPerScanline = bmp.width * 24;
        if (bitsPerScanline % 32 != 0) {
            padding = (bitsPerScanline / 32 + 1) * 32 - bitsPerScanline;
            padding = (int)Math.ceil((double)padding / 8.0);
        }
        int imSize = (bmp.width * 3 + 3) / 4 * 4 * bmp.height;
        byte[] values = new byte[imSize];
        for (int bytesRead = 0; bytesRead < imSize && (r = bmp.inputStream.read(values, bytesRead, imSize - bytesRead)) >= 0; bytesRead += r) {
        }
        int l = 0;
        if (bmp.isBottomUp) {
            int max = bmp.width * bmp.height * 3 - 1;
            int count = -padding;
            for (int i = 0; i < bmp.height; ++i) {
                l = max - (i + 1) * bmp.width * 3 + 1;
                count += padding;
                for (int j = 0; j < bmp.width; ++j) {
                    bdata[l + 2] = values[count++];
                    bdata[l + 1] = values[count++];
                    bdata[l] = values[count++];
                    l += 3;
                }
            }
        } else {
            int count = -padding;
            for (int i = 0; i < bmp.height; ++i) {
                count += padding;
                for (int j = 0; j < bmp.width; ++j) {
                    bdata[l + 2] = values[count++];
                    bdata[l + 1] = values[count++];
                    bdata[l] = values[count++];
                    l += 3;
                }
            }
        }
    }

    private static int findMask(int mask) {
        for (int k = 0; k < 32 && (mask & 1) != 1; ++k) {
            mask >>>= 1;
        }
        return mask;
    }

    private static int findShift(int mask) {
        int k;
        for (k = 0; k < 32 && (mask & 1) != 1; ++k) {
            mask >>>= 1;
        }
        return k;
    }

    private static void read1632Bit(boolean is32, BmpParameters bmp) throws java.io.IOException {
        int imSize;
        int bitsPerScanline;
        int red_mask = BmpImageHelper.findMask(bmp.redMask);
        int red_shift = BmpImageHelper.findShift(bmp.redMask);
        int red_factor = red_mask + 1;
        int green_mask = BmpImageHelper.findMask(bmp.greenMask);
        int green_shift = BmpImageHelper.findShift(bmp.greenMask);
        int green_factor = green_mask + 1;
        int blue_mask = BmpImageHelper.findMask(bmp.blueMask);
        int blue_shift = BmpImageHelper.findShift(bmp.blueMask);
        int blue_factor = blue_mask + 1;
        byte[] bdata = new byte[bmp.width * bmp.height * 3];
        int padding = 0;
        if (!is32 && (bitsPerScanline = bmp.width * 16) % 32 != 0) {
            padding = (bitsPerScanline / 32 + 1) * 32 - bitsPerScanline;
            padding = (int)Math.ceil((double)padding / 8.0);
        }
        if ((imSize = (int)bmp.imageSize) == 0) {
            imSize = (int)(bmp.bitmapFileSize - bmp.bitmapOffset);
        }
        int l = 0;
        if (bmp.isBottomUp) {
            for (int i = bmp.height - 1; i >= 0; --i) {
                l = bmp.width * 3 * i;
                for (int j = 0; j < bmp.width; ++j) {
                    int v = is32 ? (int)BmpImageHelper.readDWord(bmp.inputStream) : BmpImageHelper.readWord(bmp.inputStream);
                    bdata[l++] = (byte)((v >>> red_shift & red_mask) * 256 / red_factor);
                    bdata[l++] = (byte)((v >>> green_shift & green_mask) * 256 / green_factor);
                    bdata[l++] = (byte)((v >>> blue_shift & blue_mask) * 256 / blue_factor);
                }
                for (int m = 0; m < padding; ++m) {
                    bmp.inputStream.read();
                }
            }
        } else {
            for (int i = 0; i < bmp.height; ++i) {
                for (int j = 0; j < bmp.width; ++j) {
                    int v = is32 ? (int)BmpImageHelper.readDWord(bmp.inputStream) : BmpImageHelper.readWord(bmp.inputStream);
                    bdata[l++] = (byte)((v >>> red_shift & red_mask) * 256 / red_factor);
                    bdata[l++] = (byte)((v >>> green_shift & green_mask) * 256 / green_factor);
                    bdata[l++] = (byte)((v >>> blue_shift & blue_mask) * 256 / blue_factor);
                }
                for (int m = 0; m < padding; ++m) {
                    bmp.inputStream.read();
                }
            }
        }
        RawImageHelper.updateRawImageParameters(bmp.image, bmp.width, bmp.height, 3, 8, bdata);
    }

    private static void readRLE8(BmpParameters bmp) throws java.io.IOException {
        int imSize = (int)bmp.imageSize;
        if (imSize == 0) {
            imSize = (int)(bmp.bitmapFileSize - bmp.bitmapOffset);
        }
        byte[] values = new byte[imSize];
        for (int bytesRead = 0; bytesRead < imSize; bytesRead += bmp.inputStream.read(values, bytesRead, imSize - bytesRead)) {
        }
        byte[] val = BmpImageHelper.decodeRLE(true, values, bmp);
        imSize = bmp.width * bmp.height;
        if (bmp.isBottomUp) {
            byte[] temp = new byte[val.length];
            int bytesPerScanline = bmp.width;
            for (int i = 0; i < bmp.height; ++i) {
                System.arraycopy(val, imSize - (i + 1) * bytesPerScanline, temp, i * bytesPerScanline, bytesPerScanline);
            }
            val = temp;
        }
        BmpImageHelper.indexedModel(val, 8, 4, bmp);
    }

    private static void readRLE4(BmpParameters bmp) throws java.io.IOException {
        int imSize = (int)bmp.imageSize;
        if (imSize == 0) {
            imSize = (int)(bmp.bitmapFileSize - bmp.bitmapOffset);
        }
        byte[] values = new byte[imSize];
        for (int bytesRead = 0; bytesRead < imSize; bytesRead += bmp.inputStream.read(values, bytesRead, imSize - bytesRead)) {
        }
        byte[] val = BmpImageHelper.decodeRLE(false, values, bmp);
        if (bmp.isBottomUp) {
            byte[] inverted = val;
            val = new byte[bmp.width * bmp.height];
            int l = 0;
            for (int i = bmp.height - 1; i >= 0; --i) {
                int index = i * bmp.width;
                int lineEnd = l + bmp.width;
                while (l != lineEnd) {
                    val[l++] = inverted[index++];
                }
            }
        }
        int stride = (bmp.width + 1) / 2;
        byte[] bdata = new byte[stride * bmp.height];
        int ptr = 0;
        int sh = 0;
        for (int h = 0; h < bmp.height; ++h) {
            for (int w = 0; w < bmp.width; ++w) {
                if ((w & 1) == 0) {
                    bdata[sh + w / 2] = (byte)(val[ptr++] << 4);
                    continue;
                }
                int n = sh + w / 2;
                bdata[n] = (byte)(bdata[n] | (byte)(val[ptr++] & 0xF));
            }
            sh += stride;
        }
        BmpImageHelper.indexedModel(bdata, 4, 4, bmp);
    }

    private static byte[] decodeRLE(boolean is8, byte[] values, BmpParameters bmp) {
        byte[] val = new byte[bmp.width * bmp.height];
        try {
            int ptr = 0;
            int x = 0;
            int q = 0;
            int y = 0;
            block6: while (y < bmp.height && ptr < values.length) {
                int i;
                int bt;
                int count;
                if ((count = values[ptr++] & 0xFF) != 0) {
                    bt = values[ptr++] & 0xFF;
                    if (is8) {
                        for (i = count; i != 0; --i) {
                            val[q++] = (byte)bt;
                        }
                    } else {
                        for (i = 0; i < count; ++i) {
                            val[q++] = (byte)((i & 1) == 1 ? bt & 0xF : bt >>> 4 & 0xF);
                        }
                    }
                    x += count;
                    continue;
                }
                if ((count = values[ptr++] & 0xFF) == 1) break;
                switch (count) {
                    case 0: {
                        x = 0;
                        q = ++y * bmp.width;
                        continue block6;
                    }
                    case 2: {
                        q = (y += values[ptr++] & 0xFF) * bmp.width + (x += values[ptr++] & 0xFF);
                        continue block6;
                    }
                }
                if (is8) {
                    for (int i2 = count; i2 != 0; --i2) {
                        val[q++] = (byte)(values[ptr++] & 0xFF);
                    }
                } else {
                    bt = 0;
                    for (i = 0; i < count; ++i) {
                        if ((i & 1) == 0) {
                            bt = values[ptr++] & 0xFF;
                        }
                        val[q++] = (byte)((i & 1) == 1 ? bt & 0xF : bt >>> 4 & 0xF);
                    }
                }
                x += count;
                if (is8) {
                    if ((count & 1) != 1) continue;
                    ++ptr;
                    continue;
                }
                if ((count & 3) != 1 && (count & 3) != 2) continue;
                ++ptr;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return val;
    }

    private static int readUnsignedByte(InputStream stream) throws java.io.IOException {
        return stream.read() & 0xFF;
    }

    private static int readUnsignedShort(InputStream stream) throws java.io.IOException {
        int b1 = BmpImageHelper.readUnsignedByte(stream);
        int b2 = BmpImageHelper.readUnsignedByte(stream);
        return (b2 << 8 | b1) & 0xFFFF;
    }

    private static int readShort(InputStream stream) throws java.io.IOException {
        int b1 = BmpImageHelper.readUnsignedByte(stream);
        int b2 = BmpImageHelper.readUnsignedByte(stream);
        return b2 << 8 | b1;
    }

    private static int readWord(InputStream stream) throws java.io.IOException {
        return BmpImageHelper.readUnsignedShort(stream);
    }

    private static long readUnsignedInt(InputStream stream) throws java.io.IOException {
        int b1 = BmpImageHelper.readUnsignedByte(stream);
        int b2 = BmpImageHelper.readUnsignedByte(stream);
        int b3 = BmpImageHelper.readUnsignedByte(stream);
        int b4 = BmpImageHelper.readUnsignedByte(stream);
        long l = b4 << 24 | b3 << 16 | b2 << 8 | b1;
        return l & 0xFFFFFFFFFFFFFFFFL;
    }

    private static int readInt(InputStream stream) throws java.io.IOException {
        int b1 = BmpImageHelper.readUnsignedByte(stream);
        int b2 = BmpImageHelper.readUnsignedByte(stream);
        int b3 = BmpImageHelper.readUnsignedByte(stream);
        int b4 = BmpImageHelper.readUnsignedByte(stream);
        return b4 << 24 | b3 << 16 | b2 << 8 | b1;
    }

    private static long readDWord(InputStream stream) throws java.io.IOException {
        return BmpImageHelper.readUnsignedInt(stream);
    }

    private static int readLong(InputStream stream) throws java.io.IOException {
        return BmpImageHelper.readInt(stream);
    }

    private static class BmpParameters {
        BmpImageData image;
        int width;
        int height;
        Map<String, Object> additional;
        InputStream inputStream;
        long bitmapFileSize;
        long bitmapOffset;
        long compression;
        long imageSize;
        byte[] palette;
        int imageType;
        int numBands;
        boolean isBottomUp;
        int bitsPerPixel;
        int redMask;
        int greenMask;
        int blueMask;
        int alphaMask;
        Map<String, Object> properties = new HashMap<String, Object>();
        long xPelsPerMeter;
        long yPelsPerMeter;

        public BmpParameters(BmpImageData image) {
            this.image = image;
        }
    }
}

