/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.util;

import com.itextpdf.commons.utils.FileUtil;
import com.itextpdf.commons.utils.SystemUtil;
import com.itextpdf.io.util.CliCommandUtil;
import java.io.IOException;

public class ImageMagickHelper {
    public static final String MAGICK_COMPARE_ENVIRONMENT_VARIABLE = "ITEXT_MAGICK_COMPARE_EXEC";
    @Deprecated
    static final String MAGICK_COMPARE_ENVIRONMENT_VARIABLE_LEGACY = "compareExec";
    static final String MAGICK_COMPARE_KEYWORD = "ImageMagick Studio LLC";
    private static final String TEMP_FILE_PREFIX = "itext_im_io_temp";
    private String compareExec;

    public ImageMagickHelper() {
        this(null);
    }

    public ImageMagickHelper(String newCompareExec) {
        this.compareExec = newCompareExec;
        if (this.compareExec == null) {
            this.compareExec = SystemUtil.getPropertyOrEnvironmentVariable((String)MAGICK_COMPARE_ENVIRONMENT_VARIABLE);
            if (this.compareExec == null) {
                this.compareExec = SystemUtil.getPropertyOrEnvironmentVariable((String)MAGICK_COMPARE_ENVIRONMENT_VARIABLE_LEGACY);
            }
        }
        if (!CliCommandUtil.isVersionCommandExecutable(this.compareExec, MAGICK_COMPARE_KEYWORD)) {
            throw new IllegalArgumentException("ImageMagick comparison command specified incorrectly. Set the ITEXT_MAGICK_COMPARE_EXEC environment variable with the CLI command which can run the ImageMagic comparison. See BUILDING.MD in the root of the repository for more details.");
        }
    }

    public String getCliExecutionCommand() {
        return this.compareExec;
    }

    public boolean runImageMagickImageCompare(String outImageFilePath, String cmpImageFilePath, String diffImageName) throws IOException, InterruptedException {
        return this.runImageMagickImageCompare(outImageFilePath, cmpImageFilePath, diffImageName, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean runImageMagickImageCompare(String outImageFilePath, String cmpImageFilePath, String diffImageName, String fuzzValue) throws IOException, InterruptedException {
        boolean bl;
        if (!ImageMagickHelper.validateFuzziness(fuzzValue)) {
            throw new IllegalArgumentException("Invalid fuzziness value: " + fuzzValue);
        }
        fuzzValue = fuzzValue == null ? "" : " -metric AE -fuzz <fuzzValue>%".replace("<fuzzValue>", fuzzValue);
        String replacementOutFile = null;
        String replacementCmpFile = null;
        String replacementDiff = null;
        try {
            replacementOutFile = FileUtil.createTempCopy((String)outImageFilePath, (String)TEMP_FILE_PREFIX, null);
            replacementCmpFile = FileUtil.createTempCopy((String)cmpImageFilePath, (String)TEMP_FILE_PREFIX, null);
            replacementDiff = FileUtil.createTempFile((String)TEMP_FILE_PREFIX, (String)".png").getAbsolutePath();
            String currCompareParams = fuzzValue + " '" + replacementOutFile + "' '" + replacementCmpFile + "' '" + replacementDiff + "'";
            boolean result = SystemUtil.runProcessAndWait((String)this.compareExec, (String)currCompareParams);
            if (FileUtil.fileExists((String)replacementDiff)) {
                FileUtil.copy((String)replacementDiff, (String)diffImageName);
            }
            bl = result;
        }
        catch (Throwable throwable) {
            FileUtil.removeFiles((String[])new String[]{replacementOutFile, replacementCmpFile, replacementDiff});
            throw throwable;
        }
        FileUtil.removeFiles((String[])new String[]{replacementOutFile, replacementCmpFile, replacementDiff});
        return bl;
    }

    static boolean validateFuzziness(String fuzziness) {
        if (null == fuzziness) {
            return true;
        }
        try {
            return Double.parseDouble(fuzziness) >= 0.0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }
}

