/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.io.font;

import com.itextpdf.commons.utils.StringNormalizer;
import com.itextpdf.io.font.FontMetrics;
import com.itextpdf.io.font.FontNames;
import java.util.HashSet;
import java.util.Set;

public class FontProgramDescriptor {
    private final String fontName;
    private final String fullNameLowerCase;
    private final String fontNameLowerCase;
    private final String familyNameLowerCase;
    private final String familyName2LowerCase;
    private final String style;
    private final int macStyle;
    private final int weight;
    private final float italicAngle;
    private final boolean isMonospace;
    private final Set<String> fullNamesAllLangs;
    private final Set<String> fullNamesEnglishOpenType;
    private final String familyNameEnglishOpenType;
    private static final String[] TT_FAMILY_ORDER = new String[]{"3", "1", "1033", "3", "0", "1033", "1", "0", "0", "0", "3", "0"};

    FontProgramDescriptor(FontNames fontNames, float italicAngle, boolean isMonospace) {
        this.fontName = fontNames.getFontName();
        this.fontNameLowerCase = StringNormalizer.toLowerCase((String)this.fontName);
        this.fullNameLowerCase = StringNormalizer.toLowerCase((String)fontNames.getFullName()[0][3]);
        this.familyNameLowerCase = fontNames.getFamilyName() != null && fontNames.getFamilyName()[0][3] != null ? StringNormalizer.toLowerCase((String)fontNames.getFamilyName()[0][3]) : null;
        String[][] familyName2 = fontNames.getFamilyName2();
        this.familyName2LowerCase = familyName2 != null && familyName2[familyName2.length - 1][3] != null ? StringNormalizer.toLowerCase((String)familyName2[familyName2.length - 1][3]) : null;
        this.style = fontNames.getStyle();
        this.weight = fontNames.getFontWeight();
        this.macStyle = fontNames.getMacStyle();
        this.italicAngle = italicAngle;
        this.isMonospace = isMonospace;
        this.familyNameEnglishOpenType = this.extractFamilyNameEnglishOpenType(fontNames);
        this.fullNamesAllLangs = this.extractFullFontNames(fontNames);
        this.fullNamesEnglishOpenType = this.extractFullNamesEnglishOpenType(fontNames);
    }

    FontProgramDescriptor(FontNames fontNames, FontMetrics fontMetrics) {
        this(fontNames, fontMetrics.getItalicAngle(), fontMetrics.isFixedPitch());
    }

    public String getFontName() {
        return this.fontName;
    }

    public String getStyle() {
        return this.style;
    }

    public int getFontWeight() {
        return this.weight;
    }

    public float getItalicAngle() {
        return this.italicAngle;
    }

    public boolean isMonospace() {
        return this.isMonospace;
    }

    public boolean isBold() {
        return (this.macStyle & 1) != 0;
    }

    public boolean isItalic() {
        return (this.macStyle & 2) != 0;
    }

    public String getFullNameLowerCase() {
        return this.fullNameLowerCase;
    }

    public String getFontNameLowerCase() {
        return this.fontNameLowerCase;
    }

    public String getFamilyNameLowerCase() {
        return this.familyNameLowerCase;
    }

    public String getFamilyName2LowerCase() {
        return this.familyName2LowerCase;
    }

    public Set<String> getFullNameAllLangs() {
        return this.fullNamesAllLangs;
    }

    public Set<String> getFullNamesEnglishOpenType() {
        return this.fullNamesEnglishOpenType;
    }

    String getFamilyNameEnglishOpenType() {
        return this.familyNameEnglishOpenType;
    }

    private Set<String> extractFullFontNames(FontNames fontNames) {
        HashSet<String> uniqueFullNames = new HashSet<String>();
        for (String[] fullName : fontNames.getFullName()) {
            uniqueFullNames.add(StringNormalizer.toLowerCase((String)fullName[3]));
        }
        return uniqueFullNames;
    }

    private String extractFamilyNameEnglishOpenType(FontNames fontNames) {
        if (fontNames.getFamilyName() != null) {
            for (int k = 0; k < TT_FAMILY_ORDER.length; k += 3) {
                for (String[] name : fontNames.getFamilyName()) {
                    if (!TT_FAMILY_ORDER[k].equals(name[0]) || !TT_FAMILY_ORDER[k + 1].equals(name[1]) || !TT_FAMILY_ORDER[k + 2].equals(name[2])) continue;
                    return StringNormalizer.toLowerCase((String)name[3]);
                }
            }
        }
        return null;
    }

    private Set<String> extractFullNamesEnglishOpenType(FontNames fontNames) {
        if (this.familyNameEnglishOpenType != null) {
            String[][] names;
            HashSet<String> uniqueTtfSuitableFullNames = new HashSet<String>();
            block0: for (String[] name : names = fontNames.getFullName()) {
                for (int k = 0; k < TT_FAMILY_ORDER.length; k += 3) {
                    if (!TT_FAMILY_ORDER[k].equals(name[0]) || !TT_FAMILY_ORDER[k + 1].equals(name[1]) || !TT_FAMILY_ORDER[k + 2].equals(name[2])) continue;
                    uniqueTtfSuitableFullNames.add(name[3]);
                    continue block0;
                }
            }
            return uniqueTtfSuitableFullNames;
        }
        return new HashSet<String>();
    }
}

