/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.text.pdf;

import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.api.Spaceable;
import com.itextpdf.text.pdf.ColumnText;
import com.itextpdf.text.pdf.PdfContentByte;
import com.itextpdf.text.pdf.PdfDiv;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FloatLayout {
    protected float maxY;
    protected float minY;
    protected float leftX;
    protected float rightX;
    protected float yLine;
    protected float floatLeftX;
    protected float floatRightX;
    protected float filledWidth;
    protected final ColumnText compositeColumn;
    protected final List<Element> content;

    public float getYLine() {
        return this.yLine;
    }

    public void setYLine(float yLine) {
        this.yLine = yLine;
    }

    public float getFilledWidth() {
        return this.filledWidth;
    }

    public void setFilledWidth(float filledWidth) {
        this.filledWidth = filledWidth;
    }

    public FloatLayout(ColumnText compositeColumn, List<Element> elements) {
        this.compositeColumn = ColumnText.duplicate(compositeColumn);
        this.content = elements;
    }

    public FloatLayout(PdfContentByte canvas, List<Element> elements) {
        this.compositeColumn = new ColumnText(canvas);
        this.compositeColumn.setUseAscender(false);
        this.content = elements;
    }

    public void setSimpleColumn(float llx, float lly, float urx, float ury) {
        this.leftX = Math.min(llx, urx);
        this.maxY = Math.max(lly, ury);
        this.minY = Math.min(lly, ury);
        this.rightX = Math.max(llx, urx);
        this.floatLeftX = this.leftX;
        this.floatRightX = this.rightX;
        this.yLine = this.maxY;
        this.filledWidth = 0.0f;
    }

    public int layout(boolean simulate) throws DocumentException {
        int status = 1;
        this.filledWidth = 0.0f;
        ArrayList<Element> floatingElements = new ArrayList<Element>();
        while (!this.content.isEmpty()) {
            if (this.content.get(0) instanceof PdfDiv) {
                PdfDiv floatingElement = (PdfDiv)this.content.get(0);
                if (floatingElement.getFloatType() == PdfDiv.FloatType.LEFT || floatingElement.getFloatType() == PdfDiv.FloatType.RIGHT) {
                    floatingElements.add(floatingElement);
                    this.content.remove(0);
                    continue;
                }
                if (!floatingElements.isEmpty()) {
                    status = this.floatingLayout(floatingElements, simulate);
                }
                status = floatingElement.layout(this.compositeColumn, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                if (!simulate) {
                    status = floatingElement.layout(this.compositeColumn, simulate, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                }
                this.yLine -= floatingElement.getActualHeight();
                if (floatingElement.getActualWidth() > this.filledWidth) {
                    this.filledWidth = floatingElement.getActualWidth();
                }
                this.content.remove(0);
                continue;
            }
            floatingElements.add(this.content.get(0));
            this.content.remove(0);
        }
        if (!floatingElements.isEmpty()) {
            status = this.floatingLayout(floatingElements, simulate);
        }
        this.content.addAll(floatingElements);
        return status;
    }

    private int floatingLayout(List<Element> floatingElements, boolean simulate) throws DocumentException {
        int status = 1;
        float minYLine = this.yLine;
        float leftWidth = 0.0f;
        float rightWidth = 0.0f;
        while (!floatingElements.isEmpty()) {
            if (floatingElements.get(0) instanceof PdfDiv) {
                PdfDiv floatingElement = (PdfDiv)floatingElements.get(0);
                status = floatingElement.layout(this.compositeColumn, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                if ((status & 1) == 0) {
                    this.yLine = minYLine;
                    this.floatLeftX = this.leftX;
                    this.floatRightX = this.rightX;
                    status = floatingElement.layout(this.compositeColumn, true, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                }
                if (floatingElement.getFloatType() == PdfDiv.FloatType.LEFT) {
                    status = floatingElement.layout(this.compositeColumn, simulate, this.floatLeftX, this.minY, this.floatRightX, this.yLine);
                    this.floatLeftX += floatingElement.getActualWidth();
                    leftWidth += floatingElement.getActualWidth();
                } else if (floatingElement.getFloatType() == PdfDiv.FloatType.RIGHT) {
                    status = floatingElement.layout(this.compositeColumn, simulate, this.floatRightX - floatingElement.getActualWidth() - 0.01f, this.minY, this.floatRightX, this.yLine);
                    this.floatRightX -= floatingElement.getActualWidth();
                    rightWidth += floatingElement.getActualWidth();
                }
                minYLine = Math.min(minYLine, this.yLine - floatingElement.getActualHeight());
            } else {
                Element firstElement = floatingElements.get(0);
                if (firstElement instanceof Spaceable) {
                    this.yLine -= ((Spaceable)((Object)firstElement)).getSpacingBefore();
                }
                this.compositeColumn.addElement(firstElement);
                if (this.yLine > minYLine) {
                    this.compositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, minYLine);
                } else {
                    this.compositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, this.minY);
                }
                this.compositeColumn.setFilledWidth(0.0f);
                status = this.compositeColumn.go(simulate);
                if (this.yLine > minYLine && (this.floatLeftX > this.leftX || this.floatRightX < this.rightX) && (status & 1) == 0) {
                    this.yLine = minYLine;
                    this.floatLeftX = this.leftX;
                    this.floatRightX = this.rightX;
                    if (leftWidth != 0.0f && rightWidth != 0.0f) {
                        this.filledWidth = this.rightX - this.leftX;
                    } else {
                        if (leftWidth > this.filledWidth) {
                            this.filledWidth = leftWidth;
                        }
                        if (rightWidth > this.filledWidth) {
                            this.filledWidth = rightWidth;
                        }
                    }
                    leftWidth = 0.0f;
                    rightWidth = 0.0f;
                    this.compositeColumn.setSimpleColumn(this.floatLeftX, this.yLine, this.floatRightX, this.minY);
                    status = this.compositeColumn.go(simulate);
                    this.yLine = minYLine = this.compositeColumn.getYLine() + this.compositeColumn.getDescender();
                    if (this.compositeColumn.getFilledWidth() > this.filledWidth) {
                        this.filledWidth = this.compositeColumn.getFilledWidth();
                    }
                } else {
                    if (rightWidth > 0.0f) {
                        rightWidth += this.compositeColumn.getFilledWidth();
                    } else if (leftWidth > 0.0f) {
                        leftWidth += this.compositeColumn.getFilledWidth();
                    } else if (this.compositeColumn.getFilledWidth() > this.filledWidth) {
                        this.filledWidth = this.compositeColumn.getFilledWidth();
                    }
                    minYLine = Math.min(this.compositeColumn.getYLine() + this.compositeColumn.getDescender(), minYLine);
                    this.yLine = this.compositeColumn.getYLine() + this.compositeColumn.getDescender();
                }
                this.compositeColumn.getCompositeElements().clear();
            }
            floatingElements.remove(0);
        }
        if (leftWidth != 0.0f && rightWidth != 0.0f) {
            this.filledWidth = this.rightX - this.leftX;
        } else {
            if (leftWidth > this.filledWidth) {
                this.filledWidth = leftWidth;
            }
            if (rightWidth > this.filledWidth) {
                this.filledWidth = rightWidth;
            }
        }
        this.yLine = minYLine;
        this.floatLeftX = this.leftX;
        this.floatRightX = this.rightX;
        return status;
    }
}

